/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#ifndef __PDB_TEMPLATE_ARG_H__
#define __PDB_TEMPLATE_ARG_H__

static const string EMPTY;

class pdbTemplateArg {
public:
  enum targ_t { TA_NA, TA_TYPE, TA_NONTYPE, TA_TEMPL };
  pdbTemplateArg(targ_t kind, bool specialization = false);

  void adjustPtrs(PDB* pdb);

  targ_t kind() const;
  const string& name() const;
  const pdbType* type() const;
  const pdbTemplate* templateArg() const;
  const string& value() const;
  const pdbType* defaultType() const;
  const pdbTemplate* defaultTemplateArg() const;
  const string& defaultValue() const;
  bool isSpecialization() const;

  void name(const string& name);
  void type(const pdbType* type);
  void templateArg(const pdbTemplate* templ);
  void value(const string& val);
  void defaultType(const pdbType* type);
  void defaultTemplateArg(const pdbTemplate* templ);
  void defaultValue(const string& val);

  static const char *toName(targ_t v);
  static targ_t toTarg(const char* v);

private:
  targ_t               knd;
  string               nam;	
  union {
    const pdbType*     typ;
    const pdbTemplate* tmpl;
  };
  union {
    const pdbType*     deftyp;
    const pdbTemplate* deftmpl;
  };
  string               defval;
  bool                 specl;
};

ostream& operator<<(ostream& ostr, const pdbTemplateArg& ta);

#ifndef NO_INLINE
#  include "pdbTemplateArg.inl"
#endif
#endif
