/*************************************************************************/
/* DUCTAPE Version 2.0                                                   */
/* Copyright (C) 2001                                                    */
/* Forschungszentrum Juelich, Zentralinstitut fuer Angewandte Mathematik */
/*************************************************************************/

#include <unistd.h>
#include "pdb.h"

int main(int argc, char *argv[]) {
  int ch;
  char *outfile = 0;
  bool errflag = argc < 4;
  bool verbose = false;

  while ( (ch = getopt(argc, argv, "o:v")) != -1 ) {
    switch (ch) {
    case 'o': outfile = optarg;
              break;
    case 'v': verbose = true;
              break;
    case '?': errflag = true;
              break;
    }
  }
  if ( errflag ) {
    cerr << "usage: " << argv[0] << " [[-v] -o outfile] pdbfile..." << endl;
    return 1;
  }

  if ( outfile && verbose )
    cout << "opening " << argv[optind] << " ..." << endl;
  PDB pdb(argv[optind++]);

  if ( pdb ) {
    for (; optind<argc; ++optind) {
      if ( outfile && verbose )
        cout << "merging " << argv[optind] << " ..." << endl;
      if ( ! pdb.merge(argv[optind]) ) return 1;
    }
  }
  if ( outfile ) {
    if ( verbose ) cout << "writing " << outfile << " ..." << endl;
    pdb.write(outfile);
  } else
    pdb.write(cout);
  return 0;
}
