#!/usr/bin/env perl
############################################################################
## PDB -> SQLite3 enumeration generator
## Matthew Sottile / matt@cs.uoregon.edu
############################################################################

use strict;
use pdbSql;

############################################################################
## main program

sub hash_to_pythondict {
    my ($name, %hash) = @_;
    my $str = "$name = {\n";
    my $key = "";
    foreach $key (keys(%hash)) {
	$str .= "  $hash{$key}: '$key',\n";
    }
    chop($str);
    chop($str);
    $str .= "\n}\n";
    return $str;
}

sub hash_to_rubyhash {
  my ($name, %hash) = @_;

  my $str ="$name = {\n";
  my $key = "";
  foreach $key (keys(%hash)) {
    $str .= "  '$hash{$key}' => '$key',\n";
  }
  chop($str);
  chop($str);
  $str .= "\n}\n";
  return $str;
}

sub hash_to_cxx_enum {
  my ($name, $pfx, %hash) = @_;

  my $str = "  enum $name {\n";

  $pfx = uc $pfx;

  my $first = 0;
  my $key = "";
  foreach $key (keys(%hash)) {
      my $val = $hash{$key};
      $key =~ s/\+\+/xx/g;
      $key = uc $key;
      if ($first == 0) {
	  $str .= "     $pfx"."_$key = $val\n";
	  $first++;
      } else {
	  $str .= "   , $pfx"."_$key = $val\n";
      }
  }
  $str .= "  };\n";
  return $str;
}

#print &hash_to_rubyhash("groupkinds",%groupkinds);
#print &hash_to_rubyhash("typekind",%typekind);

sub emitPython {
  print &hash_to_pythondict("quals",%pdbSql::quals);
  print &hash_to_pythondict("gmkinds",%pdbSql::gmkinds);
  print &hash_to_pythondict("nsmemtype",%pdbSql::nsmemtype);
  print &hash_to_pythondict("linkage",%pdbSql::linkage);
  print &hash_to_pythondict("kind",%pdbSql::kind);
  print &hash_to_pythondict("skind",%pdbSql::skind);
  print &hash_to_pythondict("virt",%pdbSql::virt);
  print &hash_to_pythondict("floatkinds",%pdbSql::floatkinds);
  print &hash_to_pythondict("intkinds",%pdbSql::intkinds);
  print &hash_to_pythondict("tekinds",%pdbSql::tekinds);  
  print &hash_to_pythondict("macrokinds",%pdbSql::macrokinds);
  print &hash_to_pythondict("groupkinds",%pdbSql::groupkinds);
  print &hash_to_pythondict("typekind",%pdbSql::typekind);
  print &hash_to_pythondict("access",%pdbSql::access);
  print &hash_to_pythondict("languages",%pdbSql::languages);
}

sub emitRuby {
  print &hash_to_rubyhash("quals",%pdbSql::quals);
  print &hash_to_rubyhash("gmkinds",%pdbSql::gmkinds);
  print &hash_to_rubyhash("nsmemtype",%pdbSql::nsmemtype);
  print &hash_to_rubyhash("linkage",%pdbSql::linkage);
  print &hash_to_rubyhash("kind",%pdbSql::kind);
  print &hash_to_rubyhash("skind",%pdbSql::skind);
  print &hash_to_rubyhash("virt",%pdbSql::virt);
  print &hash_to_rubyhash("floatkinds",%pdbSql::floatkinds);
  print &hash_to_rubyhash("intkinds",%pdbSql::intkinds);
  print &hash_to_rubyhash("tekinds",%pdbSql::tekinds);  
  print &hash_to_rubyhash("macrokinds",%pdbSql::macrokinds);
  print &hash_to_rubyhash("groupkinds",%pdbSql::groupkinds);
  print &hash_to_rubyhash("typekind",%pdbSql::typekind);
  print &hash_to_rubyhash("access",%pdbSql::access);
  print &hash_to_rubyhash("languages",%pdbSql::languages);
}

sub emitCxx {
  print "class pdbSql {\npublic:\n";
  print &hash_to_cxx_enum("quals","QUAL",%pdbSql::quals);
  print &hash_to_cxx_enum("gmkinds","GMK",%pdbSql::gmkinds);
  print &hash_to_cxx_enum("nsmemtype","NS",%pdbSql::nsmemtype);
  print &hash_to_cxx_enum("linkage","LINK",%pdbSql::linkage);
  print &hash_to_cxx_enum("kind","KIND",%pdbSql::kind);
  print &hash_to_cxx_enum("skind","SK",%pdbSql::skind);
  print &hash_to_cxx_enum("virt","VIRT",%pdbSql::virt);
  print &hash_to_cxx_enum("floatkinds","FK",%pdbSql::floatkinds);
  print &hash_to_cxx_enum("intkinds","IK",%pdbSql::intkinds);
  print &hash_to_cxx_enum("tekinds","TEK",%pdbSql::tekinds);  
  print &hash_to_cxx_enum("macrokinds","MK",%pdbSql::macrokinds);
  print &hash_to_cxx_enum("groupkinds","GK",%pdbSql::groupkinds);
  print &hash_to_cxx_enum("typekind","TK",%pdbSql::typekind);
  print &hash_to_cxx_enum("access","AC",%pdbSql::access);
  print &hash_to_cxx_enum("languages","LA",%pdbSql::languages);
  print "};\n";
}

emitPython;
