/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.PlotFactory;
import edu.uoregon.tau.vis.ScatterPlot;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisCanvas;
import edu.uoregon.tau.vis.VisRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ScatterPlotExample {
    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("ScatterPlotExample");
        jFrame.setDefaultCloseOperation(3);
        float[][] fArray = new float[100][4];
        for (int i = 0; i < 100; ++i) {
            fArray[i][0] = (float)i * (float)Math.sin(i);
            fArray[i][1] = (float)i * (float)Math.cos(i);
            fArray[i][2] = i * i;
            fArray[i][3] = i;
        }
        VisRenderer visRenderer = new VisRenderer();
        VisCanvas visCanvas = new VisCanvas(visRenderer);
        visCanvas.getActualCanvas().setSize(600, 600);
        ColorScale colorScale = new ColorScale();
        ScatterPlot scatterPlot = PlotFactory.createScatterPlot("x axis", "y axis", "z axis", "color axis", fArray, true, colorScale);
        scatterPlot.setSize(10.0f, 10.0f, 10.0f);
        visRenderer.setAim(new Vec(5.0f, 5.0f, 5.0f));
        visRenderer.addShape(scatterPlot);
        visRenderer.addShape(colorScale);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.addTab("ScatterPlot", scatterPlot.getControlPanel(visRenderer));
        jTabbedPane.addTab("Axes", scatterPlot.getAxes().getControlPanel(visRenderer));
        jTabbedPane.addTab("ColorScale", colorScale.getControlPanel(visRenderer));
        jTabbedPane.addTab("Render", visRenderer.getControlPanel());
        jTabbedPane.setMinimumSize(new Dimension(300, 260));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)visCanvas.getActualCanvas(), new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 17, 1, new Insets(5, 5, 5, 5), 1, 1));
        jPanel.add((Component)jTabbedPane, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 13, 2, new Insets(5, 5, 5, 5), 1, 1));
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScatterPlotExample.createAndShowGUI();
            }
        });
    }
}

