/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.trace;

import edu.uoregon.tau.trace.Event;
import edu.uoregon.tau.trace.EventDescr;
import edu.uoregon.tau.trace.TraceFile;
import edu.uoregon.tau.trace.TraceReaderCallbacks;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class TraceReader
extends TraceFile {
    private static final int FORMAT_NATIVE = 0;
    private static final int FORMAT_32 = 1;
    private static final int FORMAT_32_SWAP = 2;
    private static final int FORMAT_64 = 3;
    private static final int FORMAT_64_SWAP = 4;
    private static final int IO_BUFFER_SIZE = 65536;
    private Event currentEvent = new Event();
    private Event spareEvent = new Event();
    private boolean hasBufferedEvent = false;
    boolean ClkInitialized;
    boolean subtractFirstTimestamp;
    boolean nonBlocking;
    boolean definitionsOnly = false;
    boolean done = false;
    int format;
    long totalRecords = 0L;
    long totalRead = 0L;
    char nid_offset = '\u0000';
    ThreadTracker tracker = new ThreadTracker();
    private int cachedNid = Integer.MIN_VALUE;
    private ThreadTracker.NodeState cachedNodeState;
    DataInputStream Fiid;
    private static final int TAU_MESSAGE_SEND_EVENT = -7;
    private static final int TAU_MESSAGE_RECV_EVENT = -8;
    long FirstTimestamp = 0L;

    public TraceReader(String string, String string2, char c) {
        this.nid_offset = c;
        this.initialize(string, string2);
        try {
            this.advance();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.done = true;
        }
    }

    public TraceReader(String string, String string2) {
        this(string, string2, '\u0000');
    }

    private void initialize(String string, String string2) {
        String[] stringArray;
        this.subtractFirstTimestamp = true;
        this.nonBlocking = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            stringArray = new BufferedInputStream(fileInputStream, 65536);
            this.Fiid = new DataInputStream((InputStream)stringArray);
            this.format = TraceReader.determineFormat(this.Fiid);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.totalRecords = TraceReader.getNumRecords(string);
        this.EdfFile = string2;
        this.TrcFile = string;
        stringArray = string.split(".");
        if (stringArray.length == 5) {
            this.node = Integer.parseInt(stringArray[1]) + this.nid_offset;
            this.context = Integer.parseInt(stringArray[2]);
            this.thread = Integer.parseInt(stringArray[3]);
        }
        this.EventIdMap = new HashMap();
        this.GroupIdMap = new HashMap();
        this.ClkInitialized = false;
    }

    private void advance() throws IOException {
        Event event = this.currentEvent;
        this.currentEvent = this.spareEvent;
        this.spareEvent = event;
        this.hasBufferedEvent = this.readInto(this.currentEvent, this.Fiid, this.format);
        if (!this.hasBufferedEvent) {
            this.done = true;
        }
    }

    public static long getNumRecords(String string) {
        File file = new File(string);
        return file.length() / 24L;
    }

    public long getNumRecords() {
        return this.totalRecords;
    }

    public String getTraceFile() {
        return this.TrcFile;
    }

    private static final char charReverseBytes(char c) {
        return (char)(c >> 8 & 0xFF | c << 8 & 0xFF00);
    }

    private static final int intReverseBytes(int n) {
        return TraceReader.charReverseBytes((char)n) << 16 | TraceReader.charReverseBytes((char)(n >>> 16));
    }

    public static long longReverseBytes(long l) {
        l = (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
        return l << 48 | (l & 0xFFFF0000L) << 16 | l >>> 16 & 0xFFFF0000L | l >>> 48;
    }

    static int determineFormat(DataInputStream dataInputStream) throws IOException {
        Event event = new Event();
        dataInputStream.mark(128);
        event.setEventID(dataInputStream.readInt());
        event.setNodeID(dataInputStream.readChar());
        event.setThreadID(dataInputStream.readChar());
        event.setParameter(dataInputStream.readLong());
        event.setTime(dataInputStream.readLong());
        int n = 0;
        if (event.getParameter() == 3L) {
            n = 1;
        } else if (TraceReader.longReverseBytes(event.getParameter()) == 3L) {
            n = 2;
        } else {
            dataInputStream.reset();
            event.setEventID((int)dataInputStream.readLong());
            event.setNodeID(dataInputStream.readChar());
            event.setThreadID(dataInputStream.readChar());
            dataInputStream.readInt();
            event.setParameter(dataInputStream.readLong());
            event.setTime(dataInputStream.readLong());
            if (event.getParameter() == 3L) {
                n = 3;
            } else if (TraceReader.longReverseBytes(event.getParameter()) == 3L) {
                n = 4;
            } else {
                System.out.println("Could not determine trace format, using native.");
            }
        }
        dataInputStream.reset();
        return n;
    }

    private boolean readInto(Event event, DataInputStream dataInputStream, int n) throws IOException {
        if (dataInputStream == null) {
            return false;
        }
        try {
            if (n < 2) {
                event.setEventID(dataInputStream.readInt());
                event.setNodeID(dataInputStream.readChar());
                event.setThreadID(dataInputStream.readChar());
                event.setParameter(dataInputStream.readLong());
                event.setTime(dataInputStream.readLong());
            } else if (n == 2) {
                event.setEventID(TraceReader.intReverseBytes(dataInputStream.readInt()));
                event.setNodeID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                event.setThreadID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                event.setParameter(TraceReader.longReverseBytes(dataInputStream.readLong()));
                event.setTime(TraceReader.longReverseBytes(dataInputStream.readLong()));
            } else if (n == 3) {
                event.setEventID((int)dataInputStream.readLong());
                event.setNodeID(dataInputStream.readChar());
                event.setThreadID(dataInputStream.readChar());
                dataInputStream.readInt();
                event.setParameter(dataInputStream.readLong());
                event.setTime(dataInputStream.readLong());
            } else if (n == 4) {
                event.setEventID((int)TraceReader.longReverseBytes(dataInputStream.readLong()));
                event.setNodeID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                event.setThreadID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                dataInputStream.readInt();
                event.setParameter(TraceReader.longReverseBytes(dataInputStream.readLong()));
                event.setTime(TraceReader.longReverseBytes(dataInputStream.readLong()));
            }
            event.nid_offset = this.nid_offset;
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    private boolean refreshTables(TraceReaderCallbacks traceReaderCallbacks, Object object) {
        boolean bl = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.EdfFile));
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(" ");
            String string2 = stringArray[1];
            int n = Integer.parseInt(stringArray[0]);
            if (string2 != null && string2.equals("dynamic_trace_events")) {
                bl = true;
            }
            for (int i = 0; i < n; ++i) {
                String string3;
                String string4;
                long l;
                String string5;
                string = bufferedReader.readLine();
                if (string == null) {
                    int n2 = i - 1;
                    System.out.println("Warning: Expected " + n + " event definitions. Found " + n2);
                    bufferedReader.close();
                    return false;
                }
                if (string.charAt(0) == '\n' || string.charAt(0) == '#') {
                    --i;
                    continue;
                }
                int n3 = -1;
                if (bl) {
                    stringArray = string.split(" ");
                    n3 = Integer.parseInt(stringArray[0]);
                    string5 = stringArray[1];
                    l = Long.parseLong(stringArray[2]);
                    int n4 = string.indexOf(34);
                    int n5 = string.indexOf(34, n4 + 1);
                    string4 = string.substring(n4, n5 + 1);
                    string3 = string.substring(n5 + 2);
                    if (string4.startsWith("\"") && string4.endsWith("\"")) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    if (!this.EventIdMap.containsKey(n3)) {
                        int n6;
                        EventDescr eventDescr = new EventDescr(n3, new String(string5), new String(string4), l, new String(string3));
                        this.EventIdMap.put(n3, eventDescr);
                        if (!this.GroupIdMap.containsKey(eventDescr.getGroup())) {
                            n6 = this.GroupIdMap.size() + 1;
                            if (eventDescr.getParameter().equals("EntryExit")) {
                                this.GroupIdMap.put(eventDescr.getGroup(), n6);
                                traceReaderCallbacks.defStateGroup(object, n6, eventDescr.getGroup());
                            }
                        } else {
                            n6 = (Integer)this.GroupIdMap.get(eventDescr.getGroup());
                        }
                        if (eventDescr.getParameter().equals("TriggerValue")) {
                            traceReaderCallbacks.defUserEvent(object, n3, eventDescr.getEventName(), (int)eventDescr.getTag());
                        } else if (eventDescr.getParameter().equals("EntryExit")) {
                            traceReaderCallbacks.defState(object, n3, eventDescr.getEventName(), n6);
                        }
                    }
                } else {
                    stringArray = string.split(" ");
                    n3 = Integer.parseInt(stringArray[0]);
                    string5 = stringArray[1];
                    l = Integer.parseInt(stringArray[2]);
                    string4 = stringArray[3];
                    if (string4 != null && string4.startsWith("\"") && string4.endsWith("\"")) {
                        string4 = string4.substring(1, string4.length() - 2);
                    }
                    string3 = stringArray[4];
                }
                if (n3 >= 0 && string4 != null) continue;
                System.out.println("Blurb error?");
                bufferedReader.close();
                return false;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public void setSubtractFirstTimestamp(boolean bl) {
        this.subtractFirstTimestamp = bl;
    }

    public void setNonBlocking(boolean bl) {
        this.nonBlocking = bl;
    }

    public int absSeek(int n) {
        return 0;
    }

    public int relSeek(int n) {
        return 0;
    }

    public void setDefsOnly(boolean bl) {
        this.definitionsOnly = bl;
    }

    public boolean isDone() {
        return this.done;
    }

    public long peekTime() {
        if (!this.hasBufferedEvent || this.done) {
            return -1L;
        }
        return this.currentEvent.getTime();
    }

    public int readNumEvents(TraceReaderCallbacks traceReaderCallbacks, int n, Object object) {
        long l;
        int n2 = 0;
        long l2 = l = n <= 0 ? this.totalRecords - this.totalRead : (long)n;
        if (this.done) {
            return 0;
        }
        if (!this.ClkInitialized) {
            this.refreshTables(traceReaderCallbacks, object);
            traceReaderCallbacks.defClkPeriod(object, 1.0E-6);
            if (this.definitionsOnly) {
                return 0;
            }
            this.ClkInitialized = true;
            this.FirstTimestamp = this.peekTime();
        }
        String string = "";
        int n3 = 0;
        while ((long)n3 < l && this.hasBufferedEvent) {
            EventDescr eventDescr;
            ThreadTracker.NodeState nodeState;
            Event event = this.currentEvent;
            ++n2;
            ++this.totalRead;
            if (event.nid == this.cachedNid && this.cachedNodeState != null) {
                nodeState = this.cachedNodeState;
            } else {
                this.cachedNodeState = nodeState = this.tracker.getNodeState(event.nid);
                this.cachedNid = event.nid;
            }
            boolean bl = nodeState.seen.get(event.tid);
            if (!bl) {
                string = "process " + event.nid + ":" + event.tid;
                traceReaderCallbacks.defThread(object, event.nid, event.tid, string);
                nodeState.seen.set(event.tid);
            }
            if (this.subtractFirstTimestamp) {
                event.time -= this.FirstTimestamp;
            }
            if ((eventDescr = (EventDescr)this.EventIdMap.get(event.evid)) == null) {
                System.out.println("Warning: no event definiton for event ID " + event.evid);
                try {
                    this.advance();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return -1;
                }
            }
            if (eventDescr.getParameter() != null && eventDescr.getParameter().equals("EntryExit")) {
                if (event.parameter == 1L) {
                    traceReaderCallbacks.enterState(object, event.time, event.nid, event.tid, event.evid);
                } else if (event.parameter == -1L) {
                    traceReaderCallbacks.leaveState(object, event.time, event.nid, event.tid, event.evid);
                }
            } else {
                long l3;
                long l4;
                long l5;
                long l6;
                long l7;
                long l8;
                if (eventDescr.getParameter() != null && eventDescr.getParameter().equals("TriggerValue")) {
                    traceReaderCallbacks.eventTrigger(object, event.time, event.nid, event.tid, event.evid, event.parameter);
                }
                if (eventDescr.getTag() == -7L || eventDescr.getEventId() == 60007) {
                    l8 = event.parameter;
                    l7 = l8 >> 16 & 0xFFL | (l8 >> 48 & 0xFFL) << 8;
                    l6 = l8 >> 24 & 0xFFL | (l8 >> 56 & 0xFFL) << 8;
                    l5 = l8 & 0xFFFFL | l8 << 22 >> 54 << 16;
                    l4 = l8 << 16 >> 58;
                    l3 = event.parameter;
                    traceReaderCallbacks.sendMessage(object, event.time, event.nid, event.tid, (int)l6, (int)l3, (int)l5, (int)l7, (int)l4);
                } else if (eventDescr.getTag() == -8L || eventDescr.getEventId() == 60008) {
                    l8 = event.parameter;
                    l7 = l8 >> 16 & 0xFFL | (l8 >> 48 & 0xFFL) << 8;
                    l6 = l8 >> 24 & 0xFFL | (l8 >> 56 & 0xFFL) << 8;
                    l5 = l8 & 0xFFFFL | l8 << 22 >> 54 << 16;
                    l4 = l8 << 16 >> 58;
                    l3 = event.parameter;
                    traceReaderCallbacks.recvMessage(object, event.time, (int)l6, (int)l3, event.nid, event.tid, (int)l5, (int)l7, (int)l4);
                }
            }
            if (event.parameter == 0L && eventDescr.getEventName() != null && (eventDescr.getEventName().equals("\"FLUSH_CLOSE\"") || eventDescr.getEventName().equals("FLUSH_CLOSE"))) {
                nodeState.done.set(event.tid);
            } else if (event.parameter != 1L && event.parameter != -1L && eventDescr.getEventName() != null && (eventDescr.getEventName().equals("\"WALL_CLOCK\"") || eventDescr.getEventName().equals("WALL_CLOCK")) && nodeState.done.get(event.tid)) {
                traceReaderCallbacks.endTrace(object, event.nid, event.tid);
                this.done = true;
                try {
                    this.advance();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return n2;
            }
            try {
                this.advance();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
            ++n3;
        }
        return n2;
    }

    public void closeTrace() {
        try {
            if (this.Fiid != null) {
                this.Fiid.close();
            } else {
                System.out.println("Warning: tried to close null file handle");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class ThreadTracker {
        private final Map<Integer, NodeState> nodeStates = new HashMap<Integer, NodeState>();

        public boolean checkAndMarkSeen(int n, int n2) {
            NodeState nodeState = this.getNodeState(n);
            if (nodeState.seen.get(n2)) {
                return true;
            }
            nodeState.seen.set(n2);
            return false;
        }

        public void markDone(int n, int n2) {
            this.getNodeState((int)n).done.set(n2);
        }

        public boolean isDone(int n, int n2) {
            NodeState nodeState = this.nodeStates.get(n);
            return nodeState != null && nodeState.done.get(n2);
        }

        public NodeState getNodeState(int n) {
            NodeState nodeState = this.nodeStates.get(n);
            if (nodeState == null) {
                nodeState = new NodeState();
                this.nodeStates.put(n, nodeState);
            }
            return nodeState;
        }

        public static class NodeState {
            public final BitSet seen = new BitSet();
            public final BitSet done = new BitSet();
        }
    }
}

