/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static GraphCellEditor cellEditor = new DefaultGraphCellEditor();
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected Rectangle2D groupBounds = DefaultGraphCell.defaultBounds;
    protected AttributeMap attributes = this.createLocalAttributeMap();
    protected AttributeMap allAttributes;

    public AbstractCellView(Object object) {
        this.cell = object;
    }

    public Object getCell() {
        return this.cell;
    }

    public void refresh(GraphModel graphModel, CellMapper cellMapper, boolean bl) {
        Object object;
        this.allAttributes = graphModel.getAttributes(this.cell);
        this.update();
        if (cellMapper != null && graphModel != null) {
            Object object2 = graphModel.getParent(this.cell);
            object = cellMapper.getMapping(object2, bl);
            if (object != this.parent) {
                this.removeFromParent();
            }
            this.parent = object;
        }
        this.childViews.clear();
        for (int i = 0; i < graphModel.getChildCount(this.cell); ++i) {
            object = graphModel.getChild(this.cell, i);
            CellView cellView = cellMapper.getMapping(object, bl);
            if (graphModel.isPort(object) || cellView == null) continue;
            this.childViews.add(cellView);
        }
    }

    public void update() {
        this.updateAllAttributes();
        this.groupBounds = null;
        this.childUpdated();
    }

    protected void updateAllAttributes() {
        this.allAttributes = this.allAttributes != null ? (AttributeMap)this.allAttributes.clone() : this.createLocalAttributeMap();
        this.allAttributes.putAll(this.attributes);
    }

    protected AttributeMap createLocalAttributeMap() {
        return new AttributeMap();
    }

    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
        this.groupBounds = null;
    }

    public CellView getParentView() {
        return this.parent;
    }

    public CellView[] getChildViews() {
        CellView[] cellViewArray = new CellView[this.childViews.size()];
        this.childViews.toArray(cellViewArray);
        return cellViewArray;
    }

    public static CellView[] getDescendantViews(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            stack.add(cellViewArray[i]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (int i = 0; i < cellViewArray3.length; ++i) {
                stack.add(cellViewArray3[i]);
            }
            arrayList.add(cellViewArray2);
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public AttributeMap getAllAttributes() {
        return this.allAttributes;
    }

    public AttributeMap setAttributes(AttributeMap attributeMap) {
        AttributeMap attributeMap2 = this.attributes.applyMap(attributeMap);
        this.update();
        return attributeMap2;
    }

    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return null;
    }

    public static Rectangle2D getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D rectangle2D = null;
            for (int i = 0; i < cellViewArray.length; ++i) {
                Rectangle2D rectangle2D2;
                if (cellViewArray[i] == null || (rectangle2D2 = cellViewArray[i].getBounds()) == null) continue;
                if (rectangle2D == null) {
                    rectangle2D = cellViewArray[i].getAttributes().createRect(rectangle2D2);
                    continue;
                }
                Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            }
            return rectangle2D;
        }
        return null;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 == null) {
            rectangle2D2 = this.getAttributes().createRect();
        }
        Point2D point2D = this.getAttributes().createPoint(rectangle2D2.getX(), rectangle2D2.getY());
        Point2D point2D2 = this.getAttributes().createPoint(rectangle2D.getX(), rectangle2D.getY());
        Rectangle2D rectangle2D3 = this.getAttributes().createRect(rectangle2D);
        if (GraphConstants.isMoveable(this.getAttributes()) && !point2D2.equals(point2D)) {
            this.translate(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        } else {
            rectangle2D3.setFrame(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D.getWidth() - point2D2.getX() + point2D.getX(), rectangle2D.getHeight() - point2D2.getY() + point2D.getY());
        }
        double d = rectangle2D3.getWidth();
        double d2 = rectangle2D3.getHeight();
        double d3 = rectangle2D2.getWidth();
        double d4 = rectangle2D2.getHeight();
        if ((d != d3 || d2 != d4) && d3 > 0.0 && d4 > 0.0) {
            this.scale(d / d3, d2 / d4, point2D2);
        }
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!this.includeInGroupBounds(cellViewArray[i])) continue;
            linkedList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        Rectangle2D rectangle2D = AbstractCellView.getBounds(cellViewArray);
        if (GraphConstants.isOpaque(this.getAllAttributes())) {
            int n = GraphConstants.getGroupBorder(this.getAllAttributes());
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
        }
        this.groupBounds = rectangle2D;
    }

    protected boolean includeInGroupBounds(CellView cellView) {
        EdgeView edgeView;
        if (cellView instanceof EdgeView && (edgeView = (EdgeView)cellView).getCell() instanceof DefaultMutableTreeNode) {
            TreeNode treeNode;
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)edgeView.getCell();
            if (edgeView.getSource() != null && edgeView.getSource().getParentView() != null && (object = edgeView.getSource().getParentView().getCell()) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)object)).isNodeDescendant(defaultMutableTreeNode)) {
                return false;
            }
            if (edgeView.getTarget() != null && edgeView.getTarget().getParentView() != null && (object = edgeView.getTarget().getParentView().getCell()) instanceof TreeNode && ((DefaultMutableTreeNode)(treeNode = (TreeNode)object)).isNodeDescendant(defaultMutableTreeNode)) {
                return false;
            }
        }
        return true;
    }

    protected void translate(double d, double d2) {
        if (this.isLeaf()) {
            this.getAttributes().translate(d, d2);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView)) continue;
                AbstractCellView abstractCellView = (AbstractCellView)e;
                abstractCellView.translate(d, d2);
            }
        }
    }

    protected void scale(double d, double d2, Point2D point2D) {
        if (this.isLeaf()) {
            this.getAttributes().scale(d, d2, point2D);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                AbstractCellView abstractCellView;
                AttributeMap attributeMap;
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView) || !GraphConstants.isSizeable(attributeMap = (abstractCellView = (AbstractCellView)e).getAttributes()) && !GraphConstants.isAutoSize(attributeMap)) continue;
                abstractCellView.scale(d, d2, point2D);
            }
        }
    }

    public boolean intersects(JGraph jGraph, Rectangle2D rectangle2D) {
        if (this.isLeaf() || GraphConstants.isOpaque(this.getAllAttributes())) {
            Rectangle2D rectangle2D2 = this.getBounds();
            if (rectangle2D2 != null) {
                return rectangle2D2.intersects(rectangle2D);
            }
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                if (!((CellView)iterator.next()).intersects(jGraph, rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getRendererComponent(JGraph jGraph, boolean bl, boolean bl2, boolean bl3) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer != null) {
            return cellViewRenderer.getRendererComponent(jGraph, this, bl, bl2, bl3);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    public abstract CellHandle getHandle(GraphContext var1);

    public GraphCellEditor getEditor() {
        return cellEditor;
    }
}

