/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;

public class GraphLayoutCache
extends Observable
implements CellMapper,
Serializable {
    public boolean autoSizeOnValueChange = false;
    public boolean showAllEdgesForVisibleVertices = true;
    public boolean showEdgesOnShow = true;
    public boolean hideEdgesOnHide = true;
    public boolean hideEdgesOnBecomeInvisible = true;
    public boolean rememberCellViews = true;
    protected GraphModel graphModel;
    protected Map mapping;
    protected CellViewFactory factory = null;
    protected transient Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected transient List changed = new LinkedList();
    protected transient Map hiddenSet = new Hashtable();
    protected boolean partial = false;
    protected boolean askLocalAttribute = true;
    protected Set localAttributes = new HashSet();

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory) {
        this(graphModel, cellViewFactory, false);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl) {
        this(graphModel, cellViewFactory, new Hashtable(), bl);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, Map map, boolean bl) {
        this.factory = cellViewFactory;
        this.partial = bl;
        if (map != null) {
            this.mapping = map;
            this.visibleSet.addAll(map.keySet());
        } else {
            this.mapping = new Hashtable();
        }
        this.setModel(graphModel);
    }

    protected void addChanged(CellView cellView) {
        this.changed.add(cellView);
    }

    public CellView[] getChanged() {
        CellView[] cellViewArray = new CellView[this.changed.size()];
        return this.changed.toArray(cellViewArray);
    }

    protected void clearChanged() {
        super.clearChanged();
        this.changed.clear();
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel graphModel) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenSet.clear();
        this.visibleSet.clear();
        this.graphModel = graphModel;
        Object[] objectArray = DefaultGraphModel.getRoots(graphModel);
        if (!this.isPartial()) {
            this.insertViews(this.getMapping(objectArray, true));
        }
        this.setChanged();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.addChanged(this.getMapping(objectArray[i], false));
            }
        }
        this.updatePorts();
        this.notifyObservers(this);
    }

    public synchronized void reload() {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Hashtable hashtable = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CellView cellView = (CellView)hashtable.get(k);
            CellView cellView2 = this.getMapping(k, true);
            cellView2.setAttributes(cellView.getAttributes());
            if (!this.roots.contains(cellView)) continue;
            arrayList.add(cellView2);
        }
        this.hiddenSet.clear();
        this.roots = arrayList;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        this.roots.toArray(cellViewArray);
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle2D rectangle2D) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!cellViewArray[i].getBounds().intersects(rectangle2D)) continue;
            arrayList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        List list = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
        if (list != null) {
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CellView cellView;
                Object e = iterator.next();
                if (!this.graphModel.isPort(e) || (cellView = this.getMapping(e, false)) == null) continue;
                arrayList.add(cellView);
                cellView.refresh(this.getModel(), this, false);
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    public void refresh(CellView[] cellViewArray, boolean bl) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void refresh(CellView cellView, boolean bl) {
        if (cellView != null) {
            cellView.refresh(this.getModel(), this, bl);
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void update(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void update(CellView cellView) {
        if (cellView != null) {
            cellView.update();
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange graphModelChange) {
        CellView[] cellViewArray = graphModelChange.getViews(this);
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                this.mapping.put(cellViewArray[i].getCell(), cellViewArray[i]);
            }
            this.setVisibleImpl(this.getCells(cellViewArray), true);
        }
        Object[] objectArray = graphModelChange.getChanged();
        CellView[] cellViewArray2 = this.getMapping(graphModelChange.getInserted(), true);
        cellViewArray = this.removeCells(graphModelChange.getRemoved());
        graphModelChange.putViews(this, cellViewArray);
        this.insertViews(cellViewArray2);
        if (this.isPartial()) {
            this.showCellsForChange(graphModelChange);
            this.hideCellsForChange(graphModelChange);
        }
        if (objectArray != null && objectArray.length > 0) {
            int n;
            this.roots.clear();
            Object[] objectArray2 = DefaultGraphModel.getRoots(this.graphModel);
            CellView[] cellViewArray3 = this.getMapping(objectArray2, false);
            for (n = 0; n < cellViewArray3.length; ++n) {
                if (cellViewArray3[n] == null) continue;
                this.roots.add(cellViewArray3[n]);
                cellViewArray3[n].refresh(this.getModel(), this, true);
            }
            for (n = 0; n < objectArray.length; ++n) {
                CellView cellView = this.getMapping(objectArray[n], false);
                if (cellView == null) continue;
                cellView.refresh(this.getModel(), this, true);
                this.update(cellView);
            }
        }
        this.refresh(this.getMapping(this.getContext(graphModelChange), false), false);
        this.updatePorts();
    }

    protected Object[] getContext(GraphModelEvent.GraphModelChange graphModelChange) {
        return graphModelChange.getContext();
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = graphModelChange.getRemoved();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i]);
            }
        }
        if (this.hideEdgesOnBecomeInvisible) {
            Object[] objectArray2 = graphModelChange.getChanged();
            for (int i = 0; i < objectArray2.length; ++i) {
                CellView cellView = this.getMapping(objectArray2[i], false);
                if (!(cellView instanceof EdgeView)) continue;
                EdgeView edgeView = (EdgeView)cellView;
                Object object = edgeView.getSource() == null ? null : edgeView.getSource().getCell();
                Object object2 = edgeView.getTarget() == null ? null : edgeView.getTarget().getCell();
                Object object3 = this.graphModel.getSource(objectArray2[i]);
                Object object4 = this.graphModel.getTarget(objectArray2[i]);
                if (!hashSet.contains(object) && !hashSet.contains(object2) && (object3 == null || this.isVisible(object3)) && (object4 == null || this.isVisible(object4))) continue;
                this.setVisibleImpl(new Object[]{objectArray2[i]}, false);
            }
        }
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        if (this.showAllEdgesForVisibleVertices) {
            Object[] objectArray;
            Object object;
            Object[] objectArray2 = graphModelChange.getInserted();
            if (objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (this.isVisible(objectArray2[i]) || !this.showAllEdgesForVisibleVertices) continue;
                    Object object2 = this.graphModel.getSource(objectArray2[i]);
                    object = this.graphModel.getTarget(objectArray2[i]);
                    if (object2 == null && object == null || !this.isVisible(object2) || !this.isVisible(object)) continue;
                    this.setVisible(objectArray2[i], true);
                }
            }
            if ((objectArray = graphModelChange.getChanged()) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isVisible(objectArray[i])) continue;
                    object = this.graphModel.getSource(objectArray[i]);
                    Object object3 = this.graphModel.getTarget(objectArray[i]);
                    if (object == null && object3 == null || !this.isVisible(object) || !this.isVisible(object3)) continue;
                    this.setVisible(objectArray[i], true);
                }
            }
        }
    }

    public void insertViews(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.refresh(cellViewArray, true);
            for (int i = 0; i < cellViewArray.length; ++i) {
                Object object;
                if (cellViewArray[i] == null || this.getMapping(cellViewArray[i].getCell(), false) == null) continue;
                CellView cellView = cellViewArray[i].getParentView();
                Object object2 = object = cellView != null ? cellView.getCell() : null;
                if (cellViewArray[i] instanceof PortView || this.roots.contains(cellViewArray[i]) || object != null) continue;
                this.roots.add(cellViewArray[i]);
            }
        }
    }

    public CellView[] removeCells(Object[] objectArray) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.removeMapping(objectArray[i]);
                if (cellViewArray[i] == null) continue;
                cellViewArray[i].removeFromParent();
                this.roots.remove(cellViewArray[i]);
                this.visibleSet.remove(cellViewArray[i].getCell());
            }
            return cellViewArray;
        }
        return null;
    }

    public Object[] getCells(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Object[] objectArray = new Object[cellViewArray.length];
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                objectArray[i] = cellViewArray[i].getCell();
            }
            return objectArray;
        }
        return null;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object);
        if (cellView == null && bl && this.isVisible(object)) {
            cellView = (CellView)this.hiddenSet.get(object);
            if (cellView != null) {
                this.putMapping(object, cellView);
                this.hiddenSet.remove(object);
            } else {
                cellView = this.factory.createView(this.graphModel, object);
                this.putMapping(object, cellView);
                cellView.refresh(this.getModel(), this, true);
                cellView.update();
            }
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.getMapping(objectArray[i], bl);
            }
            return cellViewArray;
        }
        return null;
    }

    public void putMapping(Object object, CellView cellView) {
        if (object != null && cellView != null) {
            this.mapping.put(object, cellView);
        }
    }

    public Map getMapping() {
        return this.mapping;
    }

    public CellView removeMapping(Object object) {
        if (object != null) {
            CellView cellView = (CellView)this.mapping.remove(object);
            return cellView;
        }
        return null;
    }

    public boolean isVisible(Object object) {
        return !this.isPartial() || this.visibleSet.contains(object) || object == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set set) {
        this.visibleSet = set;
    }

    public void setVisible(Object object, boolean bl) {
        this.setVisible(new Object[]{object}, bl);
    }

    public void setVisible(Object[] objectArray, boolean bl) {
        if (bl) {
            this.setVisible(objectArray, null);
        } else {
            this.setVisible(null, objectArray);
        }
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2) {
        objectArray = this.addVisibleDependencies(objectArray, true);
        objectArray2 = this.addVisibleDependencies(objectArray2, false);
        GraphViewEdit graphViewEdit = new GraphViewEdit(null, objectArray, objectArray2);
        graphViewEdit.end();
        this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewEdit});
    }

    public Object[] addVisibleDependencies(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            if (bl) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(objectArray[i]);
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.addAll(this.getParentPorts(this.graphModel.getSource(objectArray[i])));
                    hashSet.addAll(this.getParentPorts(this.graphModel.getTarget(objectArray[i])));
                }
                if (this.showEdgesOnShow) {
                    Set set = DefaultGraphModel.getEdges(this.getModel(), objectArray);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object object = this.graphModel.getSource(e);
                        Object object2 = this.graphModel.getTarget(e);
                        if (!this.isVisible(object) && !hashSet.contains(object) || !this.isVisible(object2) && !hashSet.contains(object2)) continue;
                        hashSet.add(e);
                    }
                }
                hashSet.removeAll(this.visibleSet);
                return hashSet.toArray();
            }
            if (this.hideEdgesOnHide) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.add(objectArray[i]);
                }
                hashSet.addAll(DefaultGraphModel.getEdges(this.graphModel, objectArray));
                hashSet.retainAll(this.visibleSet);
                return hashSet.toArray();
            }
        }
        return null;
    }

    public boolean setVisibleImpl(Object[] objectArray, boolean bl) {
        if (objectArray != null && this.isPartial()) {
            int n;
            boolean bl2 = false;
            CellView[] cellViewArray = new CellView[objectArray.length];
            if (!bl) {
                cellViewArray = this.removeCells(objectArray);
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == null) continue;
                if (bl) {
                    this.visibleSet.add(objectArray[n]);
                    cellViewArray[n] = this.getMapping(objectArray[n], true);
                    continue;
                }
                if (cellViewArray[n] == null) continue;
                if (this.graphModel.contains(cellViewArray[n].getCell()) && this.rememberCellViews) {
                    this.hiddenSet.put(cellViewArray[n].getCell(), cellViewArray[n]);
                }
                bl2 = true;
            }
            if (bl) {
                for (n = 0; n < cellViewArray.length; ++n) {
                    if (cellViewArray[n] == null) continue;
                    CellView cellView = cellViewArray[n];
                    CellView[] cellViewArray2 = AbstractCellView.getDescendantViews(new CellView[]{cellView});
                    for (int i = 0; i < cellViewArray2.length; ++i) {
                        this.roots.remove(cellViewArray2[i]);
                    }
                    cellView.refresh(this.getModel(), this, false);
                    this.addChanged(cellView);
                    CellView cellView2 = cellView.getParentView();
                    if (cellView2 != null) {
                        cellView2.refresh(this.getModel(), this, true);
                    } else {
                        this.insertViews(new CellView[]{cellView});
                    }
                    bl2 = true;
                }
            }
            this.setChanged();
            this.notifyObservers(this);
            return bl2;
        }
        return false;
    }

    protected Collection getParentPorts(Object object) {
        Object object2 = this.graphModel.getParent(object);
        Collection collection = this.getPorts(object2);
        collection.add(object2);
        return collection;
    }

    protected Collection getPorts(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < this.graphModel.getChildCount(object); ++i) {
            Object object2 = this.graphModel.getChild(object, i);
            if (!this.graphModel.isPort(object2)) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void valueForCellChanged(Object object, Object object2) {
        Map map = null;
        if (this.isAutoSizeOnValueChange()) {
            CellView cellView = this.getMapping(object, false);
            if (cellView != null) {
                AttributeMap attributeMap = cellView.getAllAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
                Rectangle2D rectangle2D2 = attributeMap.createRect(rectangle2D.getX(), rectangle2D.getY(), 0.0, 0.0);
                map = GraphConstants.createAttributes(new Object[]{object}, new Object[]{"resize", "bounds"}, new Object[]{Boolean.TRUE, rectangle2D2});
            }
        } else {
            map = new Hashtable();
            map.put(object, new Hashtable());
        }
        this.augmentNestedMapForValueChange(map, object, object2);
        this.edit(map, null, null, null);
    }

    protected void augmentNestedMapForValueChange(Map map, Object object, Object object2) {
        Map map2 = (Map)map.get(object);
        if (map2 != null) {
            GraphConstants.setValue(map2, object2);
        }
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Object object;
        Object[] objectArray2 = null;
        if (this.isPartial()) {
            object = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
            object.removeAll(this.visibleSet);
            if (!object.isEmpty()) {
                objectArray2 = object.toArray();
            }
        }
        if ((object = this.createLocalEdit(map, objectArray2, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)object);
        }
        this.graphModel.insert(objectArray, map, connectionSet, parentMap, undoableEditArray);
    }

    public void remove(Object[] objectArray) {
        this.graphModel.remove(objectArray);
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Serializable serializable;
        Object[] objectArray = null;
        if (this.isPartial()) {
            serializable = new HashSet(map.keySet());
            serializable.removeAll(this.visibleSet);
            if (!serializable.isEmpty()) {
                objectArray = serializable.toArray();
            }
        }
        if ((serializable = this.createLocalEdit(map, objectArray, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
        }
        this.graphModel.edit(map, connectionSet, parentMap, undoableEditArray);
    }

    protected UndoableEdit[] augment(UndoableEdit[] undoableEditArray, UndoableEdit undoableEdit) {
        if (undoableEdit != null) {
            int n = undoableEditArray != null ? undoableEditArray.length + 1 : 1;
            UndoableEdit[] undoableEditArray2 = new UndoableEdit[n];
            if (undoableEditArray != null) {
                System.arraycopy(undoableEditArray, 0, undoableEditArray2, 0, n - 2);
            }
            undoableEditArray2[n - 1] = undoableEdit;
            return undoableEditArray2;
        }
        return undoableEditArray;
    }

    public void toBack(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toBack(objectArray);
        }
    }

    public void toFront(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toFront(objectArray);
        }
    }

    protected GraphViewEdit createLocalEdit(Map map, Object[] objectArray, Object[] objectArray2) {
        if (map != null && !map.isEmpty() && this.isAskLocalAttribute()) {
            Object object;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Hashtable hashtable3 = new Hashtable();
                object = iterator.next();
                Object k = object.getKey();
                Map map2 = (Map)object.getValue();
                CellView cellView = this.getMapping(k, false);
                if (cellView != null) {
                    map2 = cellView.getAllAttributes().diff(map2);
                }
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k2 = entry.getKey();
                    Object v = entry.getValue();
                    boolean bl = this.isControlAttribute(k, k2, v);
                    if (!this.isLocalAttribute(k, k2, v) && !bl) continue;
                    hashtable3.put(k2, v);
                    if (bl) continue;
                    iterator2.remove();
                }
                if (!hashtable3.isEmpty()) {
                    hashtable2.put(k, hashtable3);
                }
                if (map2.isEmpty()) continue;
                hashtable.put(k, map2);
            }
            map.clear();
            map.putAll(hashtable);
            object = new GraphViewEdit(new Hashtable(hashtable2), objectArray, objectArray2);
            ((CompoundEdit)object).end();
            return object;
        }
        if (objectArray != null || objectArray2 != null) {
            GraphViewEdit graphViewEdit = new GraphViewEdit(null, objectArray, objectArray2);
            graphViewEdit.end();
            return graphViewEdit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object object, Object object2, Object object3) {
        return this.localAttributes.contains(object2);
    }

    protected boolean isControlAttribute(Object object, Object object2, Object object3) {
        return "removeAll".equals(object2) || "removeAttributes".equals(object2);
    }

    protected Map handleAttributes(Map map) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        CellView[] cellViewArray = new CellView[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CellView cellView;
            Map.Entry entry = iterator.next();
            cellViewArray[n] = cellView = this.getMapping(entry.getKey(), false);
            ++n;
            if (cellView == null) continue;
            this.addChanged(cellView);
            Map map2 = (Map)entry.getValue();
            AttributeMap attributeMap = cellView.getAttributes().applyMap(map2);
            cellView.refresh(this.getModel(), this, false);
            hashtable.put(cellView.getCell(), attributeMap);
        }
        this.update(cellViewArray);
        return hashtable;
    }

    public static void translateViews(CellView[] cellViewArray, double d, double d2) {
        cellViewArray = AbstractCellView.getDescendantViews(cellViewArray);
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!cellViewArray[i].isLeaf()) continue;
            cellViewArray[i].getAllAttributes().translate(d, d2);
        }
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (cellViewArray[i] == null) continue;
            stack.add(cellViewArray[i]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            int n;
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (n = 0; n < cellViewArray3.length; ++n) {
                stack.add(cellViewArray3[n]);
            }
            arrayList.add(cellViewArray2);
            for (n = 0; n < this.graphModel.getChildCount(cellViewArray2.getCell()); ++n) {
                CellView cellView;
                Object object = this.graphModel.getChild(cellViewArray2.getCell(), n);
                if (!this.graphModel.isPort(object) || (cellView = this.getMapping(object, false)) == null) continue;
                stack.add(cellView);
            }
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public Map getHiddenSet() {
        return this.hiddenSet;
    }

    public boolean isHideEdgesOnBecomeInvisible() {
        return this.hideEdgesOnBecomeInvisible;
    }

    public boolean isHideEdgesOnHide() {
        return this.hideEdgesOnHide;
    }

    public boolean isRememberCellViews() {
        return this.rememberCellViews;
    }

    public boolean isShowAllEdgesForVisibleVertices() {
        return this.showAllEdgesForVisibleVertices;
    }

    public boolean isShowEdgesOnShow() {
        return this.showEdgesOnShow;
    }

    public void setHiddenSet(Map map) {
        this.hiddenSet = map;
    }

    public void setHideEdgesOnBecomeInvisible(boolean bl) {
        this.hideEdgesOnBecomeInvisible = bl;
    }

    public void setHideEdgesOnHide(boolean bl) {
        this.hideEdgesOnHide = bl;
    }

    public void setRememberCellViews(boolean bl) {
        this.rememberCellViews = bl;
    }

    public void setShowAllEdgesForVisibleVertices(boolean bl) {
        this.showAllEdgesForVisibleVertices = bl;
    }

    public void setShowEdgesOnShow(boolean bl) {
        this.showEdgesOnShow = bl;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set set) {
        this.localAttributes = set;
    }

    public boolean isAskLocalAttribute() {
        return this.askLocalAttribute;
    }

    public void setAskLocalAttribute(boolean bl) {
        this.askLocalAttribute = bl;
    }

    public boolean isAutoSizeOnValueChange() {
        return this.autoSizeOnValueChange;
    }

    public void setAutoSizeOnValueChange(boolean bl) {
        this.autoSizeOnValueChange = bl;
    }

    public class GraphViewEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphViewChange,
    GraphModelEvent.ExecutableGraphChange {
        protected Object[] cells;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Object[] visible;
        protected Object[] invisible;

        public GraphViewEdit(Map map) {
            this(map, null, null);
            this.attributes = map;
        }

        public GraphViewEdit(Map map, Object[] objectArray, Object[] objectArray2) {
            this.attributes = map;
            if (map != null) {
                this.cells = map.keySet().toArray();
                Set set = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), this.cells);
                this.context = GraphLayoutCache.this.getMapping(set.toArray());
            }
            this.visible = objectArray;
            this.invisible = objectArray2;
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return GraphLayoutCache.this;
        }

        public Object[] getChanged() {
            if (this.attributes != null) {
                return this.attributes.keySet().toArray();
            }
            return null;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            int n;
            if (this.hidden != null) {
                for (n = 0; n < this.hidden.length; ++n) {
                    if (this.hidden[n] == null) continue;
                    GraphLayoutCache.this.mapping.put(this.hidden[n].getCell(), this.hidden[n]);
                }
            }
            if (!GraphLayoutCache.this.rememberCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            n = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            Object[] objectArray = this.visible;
            this.visible = this.invisible;
            this.invisible = objectArray;
            if (this.attributes != null) {
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
                GraphLayoutCache.this.setChanged();
            }
            if (n != 0) {
                GraphLayoutCache.this.updatePorts();
            }
            if (this.context != null) {
                for (int i = 0; i < this.context.length; ++i) {
                    if (this.context[i] == null) continue;
                    this.context[i].refresh(GraphLayoutCache.this.getModel(), GraphLayoutCache.this, false);
                }
            }
            GraphLayoutCache.this.notifyObservers(this);
        }
    }
}

