/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.ToolRunner;
import edu.uoregon.tau.common.Utility;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExternalTool {
    private static final String PROPERTIES_LOCATION = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator;
    private static final String PREFIX = "externalTool.";
    private static final String SUFFIX = ".properties";
    private static final String JAVA_LOCATION = System.getProperty("java.home") + File.separator + "bin" + File.separator;
    public static final String TOOL_NAME = "Tool_Name";
    public static final String PROGRAM_NAME = "Program_Name";
    public static final String FILE_TYPE = "File_Type";
    public static final String WORKING_DIRECTORY = "Working_Directory";
    public static final String ENVIRONMENT_VARIABLES = "Environment_Variables";
    public static final String COMMAND = "Command";
    public static final String COMMAND_LABEL = "Command_Label";
    public static final String PARAMETER_NAME = "Parameter_Name";
    public static final String DELIM = ".";
    public static final String FUNCTION_NAME = "function_name";
    public static final String SHORT_FUNCTION_NAME = "short_function_name";
    public static final String METRIC_NAME = "metric_name";
    public static final String METADATA = "metadata_";
    public static final String NODE_ID = "node_ID";
    public static final String THREAD_ID = "thread_ID";
    private static final String HEADER = "Default Properties file for an external tool.";
    private static List<ExternalTool> loadedTools = null;
    private static String currentTrial = null;
    private String propertiesFile = null;
    private Properties properties = null;
    private String toolName = null;
    private String programName = null;
    private String workingDirectory = null;
    private String[] environmentVariables = null;
    private List<Command> commands = new ArrayList<Command>();

    public ExternalTool(String string) {
        this.propertiesFile = string;
        this.properties = new Properties();
        File file = new File(string);
        if (file.exists()) {
            try {
                this.properties.load(new FileInputStream(this.propertiesFile));
                this.processProperties();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            this.toolName = this.properties.getProperty(TOOL_NAME, null);
            this.programName = this.properties.getProperty(PROGRAM_NAME, null);
            this.workingDirectory = this.properties.getProperty(WORKING_DIRECTORY, null);
            String string2 = this.properties.getProperty(ENVIRONMENT_VARIABLES, null);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                this.environmentVariables = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    this.environmentVariables[n++] = stringTokenizer.nextToken();
                }
            }
        }
    }

    private void processProperties() {
        String string;
        int n = 0;
        while ((string = this.properties.getProperty("Command." + n, null)) != null) {
            String string2;
            Command command = new Command(this, string);
            command.label = this.properties.getProperty("Command_Label." + n, string);
            this.commands.add(command);
            int n2 = 0;
            while ((string2 = this.properties.getProperty("Parameter_Name." + n + DELIM + n2, null)) != null) {
                command.parameterNames.add(string2);
                ++n2;
            }
            ++n;
        }
    }

    public static List<ExternalTool> loadAllTools() {
        if (loadedTools == null) {
            loadedTools = new ArrayList<ExternalTool>();
            File file = new File(PROPERTIES_LOCATION);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.getName().startsWith(PREFIX) || !file2.getName().endsWith(SUFFIX)) continue;
                    ExternalTool externalTool = new ExternalTool(file2.getPath());
                    loadedTools.add(externalTool);
                }
            }
        }
        return loadedTools;
    }

    public static List<ExternalTool> loadAllTools(String string) {
        if (currentTrial != null && !currentTrial.equals(string)) {
            loadedTools = null;
        }
        currentTrial = string;
        return ExternalTool.loadAllTools();
    }

    public static List<ExternalTool> reloadTools() {
        loadedTools = null;
        return ExternalTool.loadAllTools();
    }

    public static List<ExternalTool> findMatchingTools(String string) {
        return ExternalTool.findMatchingTools(string, null);
    }

    public static List<ExternalTool> findMatchingTools(String string, String string2) {
        ArrayList<ExternalTool> arrayList = new ArrayList<ExternalTool>();
        ExternalTool.loadAllTools(string2);
        if (loadedTools == null) {
            return arrayList;
        }
        for (ExternalTool externalTool : loadedTools) {
            String string3 = externalTool.properties.getProperty(FILE_TYPE, "None");
            if (!string3.equalsIgnoreCase(string)) continue;
            arrayList.add(externalTool);
        }
        return arrayList;
    }

    public static boolean matchingToolExists(String string, String string2) {
        return !ExternalTool.findMatchingTools(string, string2).isEmpty();
    }

    public static boolean matchingToolExists(String string) {
        return !ExternalTool.findMatchingTools(string).isEmpty();
    }

    public String getProperty(String string) {
        String string2 = this.properties.getProperty(string, "Undefined");
        return string2;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.properties.keySet()) {
            stringBuffer.append("\t" + string + " = " + this.properties.getProperty(string) + "\n");
        }
        return stringBuffer.toString();
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String string) {
        this.propertiesFile = string;
    }

    public static void launch(List<ExternalTool> list, CommandParameters commandParameters, Component component) {
        commandParameters.nodeID = commandParameters.nodeID < 0 ? 0 : commandParameters.nodeID;
        commandParameters.threadID = commandParameters.threadID < 0 ? 0 : commandParameters.threadID;
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (ExternalTool object2 : list) {
            arrayList.addAll(object2.commands);
        }
        Object[] objectArray = arrayList.toArray();
        Object object = JOptionPane.showInputDialog(component, "Select a command for the external tool:", "External Tool Commands", -1, null, objectArray, objectArray[0]);
        if (object == null) {
            return;
        }
        Command command = (Command)object;
        if (command.tool.workingDirectory.equalsIgnoreCase("%PROMPT%")) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose the gnuplot files directory");
            int n = jFileChooser.showOpenDialog(component);
            if (n == 0) {
                command.tool.workingDirectory = jFileChooser.getSelectedFile().getAbsolutePath();
            } else {
                return;
            }
        }
        ExternalTool.launchCommand(command, commandParameters);
    }

    public static void launch(ExternalTool externalTool) {
        Command command = externalTool.commands.get(0);
        CommandParameters commandParameters = new CommandParameters();
        ExternalTool.launchCommand(command, commandParameters);
    }

    public static void launchCommand(Command command, CommandParameters commandParameters) {
        String string = command.tool.programName + " " + command.name;
        for (String string2 : command.parameterNames) {
            String string3;
            String string4;
            if (string2.equals(FUNCTION_NAME)) {
                string4 = ExternalTool.removeCallpath(commandParameters.function);
                string = string.replaceAll(string2, string4);
                continue;
            }
            if (string2.equals(SHORT_FUNCTION_NAME)) {
                string4 = ExternalTool.removeCallpath(commandParameters.function);
                string = string.replaceAll(string2, Utility.shortenFunctionName(string4));
                continue;
            }
            if (string2.equals(METRIC_NAME)) {
                string = string.replaceAll(string2, commandParameters.metric);
                continue;
            }
            if (string2.equals(NODE_ID)) {
                string = string.replaceAll(string2, Integer.toString(commandParameters.nodeID));
                continue;
            }
            if (string2.equals(THREAD_ID)) {
                string = string.replaceAll(string2, Integer.toString(commandParameters.threadID));
                continue;
            }
            if (!string2.startsWith(METADATA) || (string3 = commandParameters.metadata.get(string4 = string2.replaceFirst(METADATA, ""))) == null) continue;
            string = string.replaceAll(string2, string3);
        }
        new ToolRunner(command.tool.workingDirectory, command.tool.environmentVariables, string);
    }

    private static String removeCallpath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=>");
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.indexOf(58) >= 0 || string3.indexOf(File.separatorChar) >= 0) continue;
            string2 = string3;
        }
        return string2.trim();
    }

    public static void createDefaultTool(boolean bl) {
        String string = PROPERTIES_LOCATION + PREFIX + "default" + SUFFIX;
        File file = new File(string);
        if (!file.exists() || bl) {
            ExternalTool externalTool = new ExternalTool(string);
            externalTool.properties.setProperty(TOOL_NAME, "Some Performance Tool");
            externalTool.properties.setProperty(PROGRAM_NAME, "echo");
            externalTool.properties.setProperty(FILE_TYPE, "PPK");
            externalTool.properties.setProperty(WORKING_DIRECTORY, "");
            externalTool.properties.setProperty(ENVIRONMENT_VARIABLES, "");
            externalTool.properties.setProperty("Command.0", "my_command");
            externalTool.properties.setProperty("Command_Label.0", "Echo Parameters");
            externalTool.properties.setProperty("Parameter_Name.0.0", FUNCTION_NAME);
            externalTool.properties.setProperty("Parameter_Name.0.1", METRIC_NAME);
            externalTool.properties.setProperty("Parameter_Name.0.2", NODE_ID);
            externalTool.properties.setProperty("Parameter_Name.0.3", THREAD_ID);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                externalTool.properties.store(fileOutputStream, HEADER);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    public static ExternalTool createWekaConfiguration(boolean bl) {
        ExternalTool externalTool = null;
        String string = PROPERTIES_LOCATION + PREFIX + "weka" + SUFFIX;
        File file = new File(string);
        if (!file.exists() || bl) {
            externalTool = new ExternalTool(string);
            externalTool.properties.setProperty(TOOL_NAME, "Weka");
            externalTool.properties.setProperty(PROGRAM_NAME, JAVA_LOCATION + "java");
            externalTool.properties.setProperty(FILE_TYPE, "Tau profiles");
            externalTool.properties.setProperty(WORKING_DIRECTORY, PROPERTIES_LOCATION);
            externalTool.properties.setProperty("Command.0", "-cp weka-3-6-1.jar weka.gui.explorer.Explorer wekadata.csv");
            externalTool.properties.setProperty("Command_Label.0", "Launch Weka Explorer for this dataset");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                externalTool.properties.store(fileOutputStream, HEADER);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        externalTool = new ExternalTool(string);
        return externalTool;
    }

    public static void main(String[] stringArray) {
        ExternalTool.createDefaultTool(false);
        List<ExternalTool> list = ExternalTool.loadAllTools();
        for (ExternalTool object2 : list) {
            System.out.println("Properties: ");
            System.out.println(object2.dump());
        }
        Iterator<ExternalTool> iterator = null;
        CommandParameters commandParameters = new CommandParameters();
        commandParameters.function = "function";
        commandParameters.metric = "metric";
        commandParameters.nodeID = 0;
        commandParameters.threadID = 0;
        ExternalTool.launch(list, commandParameters, iterator);
    }

    public static class CommandParameters {
        public String function = null;
        public String metric = null;
        public int nodeID = 0;
        public int threadID = 0;
        public MetaDataMap metadata = null;
    }

    class Command {
        public String name = null;
        public String label = null;
        public List<String> parameterNames = new ArrayList<String>();
        public ExternalTool tool = null;

        Command(ExternalTool externalTool2, String string) {
            this.tool = externalTool2;
            this.name = string;
        }

        public String toString() {
            return this.tool.toolName + ": " + this.label;
        }
    }
}

