/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common.tar;

import edu.uoregon.tau.common.tar.TarEntry;
import edu.uoregon.tau.common.tar.TarInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TarEntryEnumerator
implements Enumeration<TarEntry> {
    private TarInputStream tis = null;
    private boolean eof = false;
    private TarEntry readAhead = null;

    public TarEntryEnumerator(TarInputStream tarInputStream) {
        this.tis = tarInputStream;
        this.eof = false;
    }

    @Override
    public TarEntry nextElement() throws NoSuchElementException {
        if (this.eof && this.readAhead == null) {
            throw new NoSuchElementException();
        }
        TarEntry tarEntry = null;
        if (this.readAhead != null) {
            tarEntry = this.readAhead;
            this.readAhead = null;
        } else {
            tarEntry = this.getNext();
        }
        return tarEntry;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.eof) {
            return false;
        }
        boolean bl = false;
        this.readAhead = this.getNext();
        if (this.readAhead != null) {
            bl = true;
        }
        return bl;
    }

    private TarEntry getNext() {
        TarEntry tarEntry = null;
        try {
            tarEntry = this.tis.getNextEntry();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (tarEntry == null) {
            this.eof = true;
        }
        return tarEntry;
    }
}

