/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import viewer.legends.LegendComparators;
import viewer.legends.LegendTableModel;

public class OperationNumberMenu
extends JPopupMenu {
    private static String count_order_icon_path = "/images/checkbox/CountOrder.gif";
    private JTable table_view;
    private LegendTableModel table_model;
    private int cell_column;
    private Comparator cell_comparator;

    public OperationNumberMenu(JTable jTable, int n) {
        this.table_view = jTable;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        this.cell_column = n;
        super.setLabel(this.table_model.getColumnName(this.cell_column));
        super.setToolTipText(this.table_model.getColumnToolTip(this.cell_column));
        switch (this.cell_column) {
            case 4: {
                this.cell_comparator = LegendComparators.COUNT_ORDER;
                break;
            }
            case 5: {
                this.cell_comparator = LegendComparators.INCL_RATIO_ORDER;
                break;
            }
            case 6: {
                this.cell_comparator = LegendComparators.EXCL_RATIO_ORDER;
                break;
            }
            default: {
                this.cell_comparator = LegendComparators.INDEX_ORDER;
            }
        }
        this.addMenuItems();
    }

    private void addMenuItems() {
        URL uRL = null;
        uRL = this.getURL(count_order_icon_path);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        JMenuItem jMenuItem = new JMenuItem("9 ... 1", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationNumberMenu.this.table_model.reverseOrder(OperationNumberMenu.this.cell_comparator);
            }
        });
        super.add(jMenuItem);
        uRL = null;
        uRL = this.getURL(count_order_icon_path);
        imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jMenuItem = new JMenuItem("1 ... 9", imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OperationNumberMenu.this.table_model.arrangeOrder(OperationNumberMenu.this.cell_comparator);
            }
        });
        super.add(jMenuItem);
    }

    private URL getURL(String string) {
        return this.getClass().getResource(string);
    }
}

