/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import com.sun.opengl.impl.windows.WindowsGLDrawableFactory;
import com.sun.opengl.impl.windows.WindowsPbufferGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsPbufferGLDrawable
extends WindowsGLDrawable {
    private int initWidth;
    private int initHeight;
    private WGLExt cachedWGLExt;
    private long buffer;
    private int width;
    private int height;
    private int floatMode;

    public WindowsPbufferGLDrawable(GLCapabilities gLCapabilities, int n, int n2, WindowsGLDrawable windowsGLDrawable, WGLExt wGLExt) {
        super(gLCapabilities, null);
        this.initWidth = n;
        this.initHeight = n2;
        if (this.initWidth <= 0 || this.initHeight <= 0) {
            throw new GLException("Initial width and height of pbuffer must be positive (were (" + this.initWidth + ", " + this.initHeight + "))");
        }
        if (DEBUG) {
            System.out.println("Pbuffer caps on init: " + gLCapabilities + (gLCapabilities.getPbufferRenderToTexture() ? " [rtt]" : "") + (gLCapabilities.getPbufferRenderToTextureRectangle() ? " [rect]" : "") + (gLCapabilities.getPbufferFloatingPointBuffers() ? " [float]" : ""));
        }
        this.createPbuffer(windowsGLDrawable.getHDC(), wGLExt);
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsPbufferGLContext(this, gLContext);
    }

    public void destroy() {
        if (this.hdc != 0L) {
            WGLExt wGLExt = this.cachedWGLExt;
            if (wGLExt.wglReleasePbufferDCARB(this.buffer, this.hdc) == 0) {
                throw new GLException("Error releasing pbuffer device context: error code " + WGL.GetLastError());
            }
            this.hdc = 0L;
            if (!wGLExt.wglDestroyPbufferARB(this.buffer)) {
                throw new GLException("Error destroying pbuffer: error code " + WGL.GetLastError());
            }
            this.buffer = 0L;
        }
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public long getPbuffer() {
        return this.buffer;
    }

    public int getFloatingPointMode() {
        return this.floatMode;
    }

    public void swapBuffers() throws GLException {
    }

    private void createPbuffer(long l, WGLExt wGLExt) {
        int n;
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = new int[512];
        float[] fArray = new float[1];
        int[] nArray4 = new int[1];
        int n2 = 0;
        if (DEBUG) {
            System.out.println("Pbuffer parentHdc = " + WindowsPbufferGLDrawable.toHexString(l));
            System.out.println("Pbuffer caps: " + this.capabilities + (this.capabilities.getPbufferRenderToTexture() ? " [rtt]" : "") + (this.capabilities.getPbufferRenderToTextureRectangle() ? " [rect]" : "") + (this.capabilities.getPbufferFloatingPointBuffers() ? " [float]" : ""));
        }
        if (!WindowsPbufferGLDrawable.glCapabilities2iattributes(this.capabilities, nArray3, wGLExt, true, nArray4)) {
            throw new GLException("Pbuffer-related extensions not supported");
        }
        this.floatMode = nArray4[0];
        boolean bl = this.capabilities.getPbufferRenderToTexture();
        boolean bl2 = this.capabilities.getPbufferRenderToTextureRectangle();
        boolean bl3 = this.capabilities.getPbufferFloatingPointBuffers();
        boolean bl4 = false;
        if (bl3) {
            boolean bl5 = bl4 = this.floatMode == 2;
        }
        if (!wGLExt.wglChoosePixelFormatARB(l, nArray3, 0, fArray, 0, 256, nArray2 = new int[256], 0, nArray = new int[1], 0)) {
            throw new GLException("pbuffer creation error: wglChoosePixelFormatARB() failed");
        }
        int n3 = nArray[0];
        if (n3 <= 0) {
            throw new GLException("pbuffer creation error: Couldn't find a suitable pixel format");
        }
        if (DEBUG) {
            System.err.println("" + n3 + " suitable pixel formats found");
            nArray3[0] = 8213;
            nArray3[1] = 8215;
            nArray3[2] = 8217;
            nArray3[3] = 8219;
            nArray3[4] = 8226;
            nArray3[5] = bl3 ? (bl4 ? 8211 : 8368) : 8213;
            nArray3[6] = 8257;
            nArray3[7] = 8258;
            nArray3[8] = 8237;
            int[] nArray5 = new int[9];
            for (int i = 0; i < n3; ++i) {
                if (!wGLExt.wglGetPixelFormatAttribivARB(l, nArray2[i], 0, 9, nArray3, 0, nArray5, 0)) {
                    throw new GLException("Error while querying pixel format " + nArray2[i] + "'s (index " + i + "'s) capabilities for debugging");
                }
                System.err.print("pixel format " + nArray2[i] + " (index " + i + "): ");
                System.err.print("r: " + nArray5[0]);
                System.err.print(" g: " + nArray5[1]);
                System.err.print(" b: " + nArray5[2]);
                System.err.print(" a: " + nArray5[3]);
                System.err.print(" depth: " + nArray5[4]);
                System.err.print(" multisample: " + nArray5[6]);
                System.err.print(" samples: " + nArray5[7]);
                if (bl3) {
                    if (bl4) {
                        if (nArray5[5] == 8608) {
                            System.err.print(" [ati float]");
                        } else if (nArray5[5] != 8235) {
                            System.err.print(" [unknown pixel type " + nArray5[5] + "]");
                        }
                    } else if (nArray5[5] != 0) {
                        System.err.print(" [float]");
                    }
                }
                if (nArray5[8] != 0) {
                    System.err.print(" [pbuffer]");
                }
                System.err.println();
            }
        }
        long l2 = 0L;
        int n4 = 0;
        do {
            n = nArray2[n4];
            n2 = 0;
            if (bl) {
                nArray3[n2++] = 8306;
                nArray3[n2++] = bl3 ? 8375 : 8310;
                nArray3[n2++] = 8307;
                nArray3[n2++] = bl2 ? 8354 : 8314;
                nArray3[n2++] = 8308;
                nArray3[n2++] = 0;
                nArray3[n2++] = 8243;
                nArray3[n2++] = 0;
            }
            nArray3[n2++] = 0;
        } while ((l2 = wGLExt.wglCreatePbufferARB(l, n, this.initWidth, this.initHeight, nArray3, 0)) == 0L && ++n4 < n3);
        if (l2 == 0L) {
            throw new GLException("pbuffer creation error: wglCreatePbufferARB() failed: tried " + n3 + " pixel formats, last error was: " + WindowsPbufferGLDrawable.wglGetLastError());
        }
        long l3 = wGLExt.wglGetPbufferDCARB(l2);
        if (l3 == 0L) {
            throw new GLException("pbuffer creation error: wglGetPbufferDCARB() failed");
        }
        this.buffer = l2;
        this.hdc = l3;
        this.cachedWGLExt = wGLExt;
        int[] nArray6 = new int[1];
        wGLExt.wglQueryPbufferARB(this.buffer, 8244, nArray6, 0);
        this.width = nArray6[0];
        wGLExt.wglQueryPbufferARB(this.buffer, 8245, nArray6, 0);
        this.height = nArray6[0];
        if (DEBUG) {
            System.err.println("Created pbuffer " + this.width + " x " + this.height);
        }
    }

    private static String wglGetLastError() {
        return WindowsGLDrawableFactory.wglGetLastError();
    }
}

