/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jtar;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xeustechnologies.jtar.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;
    private long currentFileSize = 0L;
    private TarEntry currentEntry;

    public TarOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void close() throws IOException {
        this.closeCurrentEntry();
        this.write(new byte[1024]);
        super.close();
    }

    public void write(int n) throws IOException {
        super.write(n);
        ++this.bytesWritten;
        if (this.currentEntry != null) {
            ++this.currentFileSize;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.currentEntry != null && !this.currentEntry.isDirectory() && this.currentEntry.getSize() < this.currentFileSize + (long)n2) {
            throw new IOException("The current entry[" + this.currentEntry.getName() + "] size[" + this.currentEntry.getSize() + "] is smaller than the bytes[" + (this.currentFileSize + (long)n2) + "] being written.");
        }
        super.write(byArray, n, n2);
    }

    public void putNextEntry(TarEntry tarEntry) throws IOException {
        this.closeCurrentEntry();
        byte[] byArray = new byte[512];
        tarEntry.writeEntryHeader(byArray);
        this.write(byArray);
        this.currentEntry = tarEntry;
    }

    protected void closeCurrentEntry() throws IOException {
        if (this.currentEntry != null) {
            if (this.currentEntry.getSize() > this.currentFileSize) {
                throw new IOException("The current entry[" + this.currentEntry.getName() + "] of size[" + this.currentEntry.getSize() + "] has not been fully written.");
            }
            this.currentEntry = null;
            this.currentFileSize = 0L;
            this.pad();
        }
    }

    protected void pad() throws IOException {
        int n;
        if (this.bytesWritten > 0L && (n = (int)(this.bytesWritten % 512L)) > 0) {
            this.write(new byte[512 - n]);
        }
    }
}

