/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeInt16
extends Value {
    protected short value;

    public CubeInt16() {
        this.value = 0;
    }

    public CubeInt16(short s) {
        this.value = s;
    }

    @Override
    public String getName() {
        return "INT16";
    }

    @Override
    public String toString() {
        return Short.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = endianess.applyOn(s);
        dataOutputStream.writeShort(s2);
    }

    @Override
    public Value clone() {
        return new CubeInt16();
    }

    @Override
    public Value copy() {
        return new CubeInt16(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt16(dataInputStream.readShort());
    }

    @Override
    public void setValue(String string) {
        this.value = Short.parseShort(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public void setValue(int n) {
        this.value = (short)n;
    }

    @Override
    public void setValue(long l) {
        this.value = (short)l;
    }

    @Override
    public void setValue(double d) {
        this.value = (short)d;
    }

    @Override
    public double getDouble() {
        return Short.valueOf(this.value).doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeInt16 cubeInt16 = (CubeInt16)value;
        this.value = (short)(this.value + cubeInt16.value);
    }

    @Override
    public void subtractValue(Value value) {
        CubeInt16 cubeInt16 = (CubeInt16)value;
        this.value = (short)(this.value - cubeInt16.value);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

