/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.CubeMaxDouble;
import scalasca.cubex.cube.datalayout.data.value.CubeMinDouble;
import scalasca.cubex.cube.datalayout.data.value.CubeUint32;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeTauAtomicMetric
extends Value {
    protected CubeUint32 N;
    protected CubeMinDouble Min;
    protected CubeMaxDouble Max;
    protected CubeDouble Sum;
    protected CubeDouble Sum2;
    private double avg;
    private double var;

    public CubeTauAtomicMetric() {
        this.N = new CubeUint32();
        this.Min = new CubeMinDouble();
        this.Max = new CubeMaxDouble();
        this.Sum = new CubeDouble();
        this.Sum2 = new CubeDouble();
        this.calculateValues();
    }

    public CubeTauAtomicMetric(int n, double d, double d2, double d3, double d4) {
        this.N = new CubeUint32(n);
        this.Min = new CubeMinDouble(d);
        this.Max = new CubeMaxDouble(d2);
        this.Sum = new CubeDouble(d3);
        this.Sum2 = new CubeDouble(d4);
        this.calculateValues();
    }

    @Override
    public String getName() {
        return "TAU_ATOMIC";
    }

    @Override
    public String toString() {
        return "(" + this.N.toString() + ", " + this.Min.toString() + ", " + this.Max.toString() + "):" + Double.valueOf(this.avg).toString() + ", " + Double.valueOf(this.var).toString();
    }

    @Override
    public int size() {
        return this.N.size() + this.Min.size() + this.Max.size() + this.Sum.size() + this.Sum2.size();
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        this.N.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.Min.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.Max.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.Sum.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.Sum2.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.calculateValues();
    }

    @Override
    public Value clone() {
        return new CubeTauAtomicMetric();
    }

    @Override
    public Value copy() {
        return new CubeTauAtomicMetric((int)this.N.getDouble(), this.Min.getDouble(), this.Max.getDouble(), this.Sum.getDouble(), this.Sum2.getDouble());
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        double d3 = dataInputStream.readDouble();
        double d4 = dataInputStream.readDouble();
        return new CubeTauAtomicMetric(n, d, d2, d3, d4);
    }

    @Override
    public void setValue(String string) {
    }

    @Override
    public void setValue(byte by) {
    }

    @Override
    public void setValue(short s) {
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public void setValue(long l) {
    }

    @Override
    public void setValue(double d) {
    }

    @Override
    public double getDouble() {
        return this.avg;
    }

    public double getN() {
        return this.N.getDouble();
    }

    public double getMin() {
        return this.Min.getDouble();
    }

    public double getMax() {
        return this.Max.getDouble();
    }

    public double getSum() {
        return this.Sum.getDouble();
    }

    public double getSum2() {
        return this.Sum2.getDouble();
    }

    public double getAvg() {
        return this.avg;
    }

    public double getVar() {
        return this.var;
    }

    @Override
    public void addValue(Value value) {
        CubeTauAtomicMetric cubeTauAtomicMetric = (CubeTauAtomicMetric)value;
        this.N.addValue(cubeTauAtomicMetric.N);
        this.Min.addValue(cubeTauAtomicMetric.Min);
        this.Max.addValue(cubeTauAtomicMetric.Max);
        this.Sum.addValue(cubeTauAtomicMetric.Sum);
        this.Sum2.addValue(cubeTauAtomicMetric.Sum2);
        this.calculateValues();
    }

    @Override
    public void subtractValue(Value value) {
        CubeTauAtomicMetric cubeTauAtomicMetric = (CubeTauAtomicMetric)value;
        this.N.subtractValue(cubeTauAtomicMetric.N);
        this.Min.subtractValue(cubeTauAtomicMetric.Min);
        this.Max.subtractValue(cubeTauAtomicMetric.Max);
        this.Sum.subtractValue(cubeTauAtomicMetric.Sum);
        this.Sum2.subtractValue(cubeTauAtomicMetric.Sum2);
        this.calculateValues();
    }

    private void calculateValues() {
        double d = this.N.getDouble();
        double d2 = this.Sum.getDouble();
        double d3 = this.Sum2.getDouble();
        if (d != 0.0) {
            this.avg = d2 / d;
            this.var = Math.sqrt(1.0 / d * (d3 - d2 * d2 / d));
        }
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

