/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.index;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import scalasca.cubex.cube.datalayout.index.Index;
import scalasca.cubex.cube.datalayout.index.IndexType;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.CIDPairOutOfBoundsException;
import scalasca.cubex.cube.errors.IDOutOfBoundsException;
import scalasca.cubex.cube.errors.MissingRowException;
import scalasca.cubex.cube.errors.TIDPairOutOfBoundsException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class SparseIndex
extends Index {
    protected int[] index = null;
    protected int index_size;

    public SparseIndex(int n, int n2, byte[] byArray, Endianess endianess) throws BadCubeReportLayoutException {
        super(n, n2, endianess);
        this.indexType = IndexType.SPARSE;
        try {
            if (byArray == null) {
                throw new BadCubeReportLayoutException("Got empty sparse index");
            }
            if (byArray.length > 0) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                if (dataInputStream == null) {
                    throw new IOException("Cannot create DataInputStream");
                }
                this.index_size = this.endianess.applyOn(dataInputStream.readInt());
                this.index = new int[this.index_size];
                for (int i = 0; i < this.index_size; ++i) {
                    this.index[i] = this.endianess.applyOn(dataInputStream.readInt());
                }
            } else {
                this.index_size = 0;
                this.index = new int[0];
            }
        }
        catch (IOException iOException) {
            throw new BadCubeReportLayoutException("Cannot create sparse index: " + iOException.getMessage());
        }
    }

    protected void printOwnIndex() {
        System.out.println(" Index size    : " + this.index_size);
        System.out.print(" Index content : ");
        for (int n : this.index) {
            System.out.print(n + " ");
        }
        System.out.println();
    }

    public int getPosition(int n, int n2) throws IDOutOfBoundsException, MissingRowException {
        if (n < 0 || n >= this.number_of_cnodes) {
            throw new CIDPairOutOfBoundsException(n, this.number_of_cnodes);
        }
        if (n2 < 0 || n2 >= this.number_of_cnodes) {
            throw new TIDPairOutOfBoundsException(n2, this.number_of_threads);
        }
        int n3 = Arrays.binarySearch(this.index, n);
        if (n3 < 0) {
            throw new MissingRowException(n);
        }
        return n3 * this.number_of_threads + n2;
    }
}

