/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.services;

import scalasca.cubex.cube.services.ProgressReportInterface;

public class ProgressReportContext {
    private ProgressReportContext previous = null;
    protected double achieved = 0.0;
    protected double step = 0.0;
    protected String progress_message;
    protected Object subActor = null;
    private int level = 0;

    public ProgressReportContext() {
        this.previous = null;
        this.achieved = 0.0;
        this.step = 0.0;
        this.level = 0;
    }

    public ProgressReportContext(ProgressReportContext progressReportContext) {
        this.achieved = 0.0;
        this.step = 0.0;
        this.previous = progressReportContext;
        if (this.previous != null) {
            this.level = this.previous.getLevel() + 1;
        }
    }

    public void setNextStep(double d) {
        this.subActor = null;
        this.step = d;
    }

    public void setAchievedStep() {
        this.subActor = null;
        this.achieved += this.step;
    }

    public ProgressReportContext createSubProgressReport() {
        return new ProgressReportContext(this);
    }

    public int getLevel() {
        return this.level;
    }

    public void setProgressMessage(String string) {
        this.progress_message = string;
    }

    public String getProgressMessageChain() {
        String string = this.progress_message;
        String string2 = "";
        for (int i = 0; i < this.level; ++i) {
            string2 = string2.concat("        ");
        }
        if (this.previous != null) {
            string = this.previous.getProgressMessageChain() + "\n" + string2 + "->" + string;
        }
        return string;
    }

    public String getProgressMessage() {
        if (this.subActor != null && this.subActor instanceof ProgressReportInterface) {
            return ((ProgressReportInterface)this.subActor).getProgressMessage();
        }
        return this.getProgressMessageChain();
    }

    public double getProgress() {
        double d = 0.0;
        if (this.subActor != null && this.subActor instanceof ProgressReportInterface) {
            double d2 = ((ProgressReportInterface)this.subActor).getProgress();
            d = this.achieved + this.step * d2;
            return d;
        }
        return this.achieved;
    }

    public ProgressReportContext getPreviousContext() {
        return this.previous;
    }

    public void setSubActor(Object object) {
        this.subActor = object;
        ((ProgressReportInterface)this.subActor).setActiveProgressReportContext(this.createSubProgressReport());
    }

    public void setNoSubActor() {
        this.subActor = null;
    }
}

