/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.tarviewer;

import java.io.File;
import scalasca.cubex.tarviewer.PaxPair;

public class PaxEntry {
    protected File file = null;
    protected Long size;

    private PaxEntry() {
    }

    public PaxEntry(byte[] byArray) {
        this();
        this.parsePaxHeader(byArray);
    }

    public long getSize() {
        return this.size;
    }

    public void parsePaxHeader(byte[] byArray) {
        int n = 0;
        PaxPair paxPair = new PaxPair();
        while (!paxPair.keyword.equals("size") || n >= byArray.length) {
            n = this.parseChunk(byArray, n, paxPair);
        }
        if (paxPair.keyword.equals("size")) {
            this.size = Long.valueOf(paxPair.value.trim());
        }
    }

    public int parseChunk(byte[] byArray, int n, PaxPair paxPair) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = 0;
        while (byArray[n + n2] != 32) {
            byArray2[n2] = byArray[n + n2];
            ++n2;
        }
        n += n2 + 1;
        int n3 = Integer.parseInt(new String(byArray2).trim());
        byte[] byArray3 = new byte[byArray.length];
        for (n2 = 0; n2 < n3 - n - 1; ++n2) {
            byArray3[n2] = byArray[n + n2];
        }
        String[] stringArray = new String(byArray3).split("[\\s=\n]", 0);
        paxPair.keyword = stringArray[0];
        paxPair.value = stringArray[1];
        return n += n2;
    }
}

