/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.HeatMapWindow;
import java.awt.Toolkit;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CommunicationMatrix {
    private HeatMapData mapData = null;
    private int size = 0;
    private static final String allPaths = "All Paths";
    private static final int COUNT = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private JFrame window = null;

    public JFrame doCommunicationMatrix() {
        Object object;
        CommunicationMatrix communicationMatrix = new CommunicationMatrix();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Map<String, double[][]> map = PerfExplorerConnection.getConnection().getUserEventData(perfExplorerModel);
        Trial trial = (Trial)perfExplorerModel.getCurrentSelection();
        int n = Integer.parseInt(trial.getField("threads_per_context"));
        int n2 = Integer.parseInt(trial.getField("contexts_per_node")) * n;
        this.size = n2 * Integer.parseInt(trial.getField("node_count"));
        long l = System.currentTimeMillis();
        boolean bl = false;
        this.mapData = new HeatMapData(this.size);
        for (String string : map.keySet()) {
            object = map.get(string);
            for (int i = 0; i < this.size; ++i) {
                if (object[i][0] == 0.0) continue;
                if (string.startsWith("Message size") && !string.contains("=>")) {
                    bl = true;
                    this.extractData((double[][])object, i, string, string, allPaths);
                    continue;
                }
                if (!string.startsWith("Message size") || !string.contains("=>")) continue;
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=>");
                String string4 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    this.extractData((double[][])object, i, string, string2, string4);
                }
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "This trial does not have communication matrix data.\nTo collect communication matrix data, set the environment variable TAU_COMM_MATRIX=1 before executing your application.", "No Communication Matrix Data", 0);
            return null;
        }
        this.mapData.massageData();
        float f = System.currentTimeMillis() - l;
        float f2 = f / 1000.0f;
        object = new DecimalFormat("0.000");
        System.out.println("Total time to process data: " + ((NumberFormat)object).format(f2) + " seconds");
        this.window = new HeatMapWindow("Message Size Heat Maps", this.mapData);
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.window.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        this.window.setVisible(true);
        return communicationMatrix.getWindow();
    }

    private void addHeatMapData(double[][] dArray, int n, int n2, String string) {
        double d = 0.0;
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray3 = this.mapData.get(n, n2, string);
        if (dArray3 == null) {
            dArray3 = dArray2;
        }
        double d2 = dArray[n][0];
        dArray3[0] = dArray3[0] + d2;
        double d3 = dArray[n][1];
        dArray3[1] = Math.max(d3, dArray3[1]);
        double d4 = dArray[n][2];
        dArray3[2] = dArray3[2] > 0.0 ? Math.min(dArray3[2], d4) : d4;
        double d5 = dArray[n][3];
        dArray3[3] = dArray3[3] + d5;
        double d6 = dArray[n][4];
        dArray3[4] = dArray3[4] + d6;
        d = d2 * d5;
        dArray3[5] = dArray3[5] + d;
        this.mapData.put(n, n2, string, dArray3);
    }

    private void extractData(double[][] dArray, Integer n, String string, String string2, String string3) {
        if (string2.contains("all nodes")) {
            return;
        }
        Scanner scanner = new Scanner(string2);
        int n2 = -1;
        while (scanner.hasNext()) {
            if (!scanner.hasNextInt()) {
                scanner.next();
                continue;
            }
            n2 = scanner.nextInt();
        }
        if (string2.contains("sent")) {
            int n3 = n2;
            int n4 = n;
            this.addHeatMapData(dArray, n4, n3, string3);
        } else if (string2.contains("received")) {
            int n5 = n2;
            int n6 = n;
            this.addHeatMapData(dArray, n5, n6, string3);
        }
    }

    public JFrame getWindow() {
        return this.window;
    }
}

