/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.PythonInterpreterFactory;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.ParsingException;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerExpression;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTree;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeriveMetricsPane
extends JScrollPane
implements ActionListener {
    private static final long serialVersionUID = -8971827392560223964L;
    private static DeriveMetricsPane thePane = null;
    private JPanel mainPanel = null;
    private static Application selectApp = null;
    private static Experiment selectExp = null;
    private static Trial selectTrial = null;
    private JButton derive = new JButton("Apply");
    private JLabel trialsSelected = new JLabel("<html><p>No Trials Selected<br/ <br/ <br/ </p> ");
    private JTextArea addExpression = new JTextArea(4, 10);
    private JButton leftParen = new JButton("(");
    private JButton rightParen = new JButton(")");
    private JButton plus = new JButton("+");
    private JButton minus = new JButton("-");
    private JButton times = new JButton("*");
    private JButton divide = new JButton("/");
    private JButton clear = new JButton("Clear");
    private JButton apply = new JButton("Apply");
    private JButton equals = new JButton("=");
    private JButton insert = new JButton("Add to List");
    private DefaultListModel expressionList = new DefaultListModel();
    private JButton edit = new JButton("Edit");
    private JButton remove = new JButton("Remove");
    private JButton selectAll = new JButton("Select All");
    private JButton deselect = new JButton("Deselect All");
    private JButton validate = new JButton("Validate");
    JList expression = new JList(this.expressionList){
        private static final long serialVersionUID = 6244520599949851468L;

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (-1 < n) {
                String string = DeriveMetricsPane.this.expressionList.get(n).toString();
                String string2 = "<html>";
                String string3 = "<html>";
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    string3 = string2 = string2 + cArray[i];
                    if (i % 80 != 0 || i == 0) continue;
                    string2 = string2 + "<br>";
                }
                return string3.trim();
            }
            return null;
        }
    };

    public static DeriveMetricsPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 5));
            thePane = new DeriveMetricsPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private DeriveMetricsPane(JPanel jPanel) {
        super(jPanel);
        PerfExplorerConnection.getConnection();
        this.mainPanel = jPanel;
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        JPanel jPanel3 = this.createCreateExpressionMenu();
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = this.createExpressionListMenu();
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = this.createApplyExpression();
        jPanel5.setAlignmentX(0.0f);
        jPanel2.add(jPanel5);
        this.mainPanel.add((Component)jPanel2, "East");
        this.resetChartSettings();
    }

    private JPanel createApplyExpression() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Apply Derived Metric Expressions");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.trialsSelected.setAlignmentX(0.0f);
        this.trialsSelected.setMaximumSize(new Dimension(1000, 100));
        this.derive.setAlignmentX(0.0f);
        jPanel.add(this.trialsSelected);
        jPanel.add(this.derive);
        this.derive.addActionListener(this);
        return jPanel;
    }

    private JPanel createExpressionListMenu() {
        this.expression = new JList(this.expressionList){
            private static final long serialVersionUID = -8046524611330812275L;

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (-1 < n) {
                    String string = DeriveMetricsPane.this.expressionList.get(n).toString();
                    String string2 = "<html>";
                    String string3 = "<html>";
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        string3 = string2 = string2 + cArray[i];
                        if (i % 80 != 0 || i == 0) continue;
                        string2 = string2 + "<br>";
                    }
                    return string3.trim();
                }
                return null;
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.expression);
        jScrollPane.setPreferredSize(new Dimension(400, 350));
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select Derived Metric  Expressions");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = this.createSelectionOptionsPanel();
        jScrollPane.setAlignmentY(0.0f);
        jPanel.add(jScrollPane);
        jPanel2.setAlignmentY(0.0f);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createSelectionOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Dimension dimension = new Dimension(150, 30);
        this.selectAll.setMaximumSize(dimension);
        this.deselect.setMaximumSize(dimension);
        this.edit.setMaximumSize(dimension);
        this.validate.setMaximumSize(dimension);
        this.remove.setMaximumSize(dimension);
        this.selectAll.setAlignmentX(0.0f);
        this.deselect.setAlignmentX(0.0f);
        this.edit.setAlignmentX(0.0f);
        this.validate.setAlignmentX(0.0f);
        this.remove.setAlignmentX(0.0f);
        this.selectAll.setAlignmentY(0.0f);
        this.deselect.setAlignmentY(0.0f);
        this.edit.setAlignmentY(0.0f);
        this.validate.setAlignmentY(0.0f);
        this.remove.setAlignmentY(0.0f);
        this.selectAll.addActionListener(this);
        this.deselect.addActionListener(this);
        this.edit.addActionListener(this);
        this.validate.addActionListener(this);
        this.remove.addActionListener(this);
        jPanel.add(this.selectAll);
        jPanel.add(this.deselect);
        jPanel.add(this.edit);
        jPanel.add(this.validate);
        jPanel.add(this.remove);
        return jPanel;
    }

    private JPanel createCreateExpressionMenu() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Create Derived Metric Expression");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = this.createAddOptions();
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        JPanel jPanel3 = this.createOperPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createAddOptions() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.addExpression.setAlignmentY(0.0f);
        JScrollPane jScrollPane = new JScrollPane(this.addExpression);
        jScrollPane.setAlignmentY(0.0f);
        this.addExpression.setLineWrap(true);
        jPanel.add(jScrollPane);
        this.clear.setAlignmentY(0.0f);
        jPanel.add(this.clear);
        this.clear.addActionListener(this);
        return jPanel;
    }

    private JPanel createOperPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Dimension dimension = new Dimension(60, 5);
        this.plus.setPreferredSize(dimension);
        this.minus.setPreferredSize(dimension);
        this.divide.setPreferredSize(dimension);
        this.times.setPreferredSize(dimension);
        this.rightParen.setPreferredSize(dimension);
        this.leftParen.setPreferredSize(dimension);
        this.equals.setPreferredSize(dimension);
        this.plus.setAlignmentY(0.0f);
        this.minus.setAlignmentY(0.0f);
        this.divide.setAlignmentY(0.0f);
        this.times.setAlignmentY(0.0f);
        this.rightParen.setAlignmentY(0.0f);
        this.leftParen.setAlignmentY(0.0f);
        this.equals.setAlignmentY(0.0f);
        this.insert.setAlignmentY(0.0f);
        this.apply.setAlignmentY(0.0f);
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.divide.addActionListener(this);
        this.times.addActionListener(this);
        this.rightParen.addActionListener(this);
        this.leftParen.addActionListener(this);
        this.equals.addActionListener(this);
        this.insert.addActionListener(this);
        this.apply.addActionListener(this);
        jPanel.add(this.plus);
        jPanel.add(this.minus);
        jPanel.add(this.divide);
        jPanel.add(this.times);
        jPanel.add(this.equals);
        jPanel.add(this.leftParen);
        jPanel.add(this.rightParen);
        jPanel.add(this.insert);
        jPanel.add(this.apply);
        return jPanel;
    }

    private void resetChartSettings() {
        this.refreshDynamicControls(true, true, false);
    }

    public void metricClick(Metric metric) {
        this.insertText(metric.getName());
    }

    private void insertText(String string) {
        this.addExpression.replaceSelection(string);
        this.requestFocusInWindow();
        int n = this.addExpression.getSelectionStart();
        this.addExpression.setCaretPosition(n);
        if (this.addExpression.getText().length() == n) {
            this.addExpression.setText(this.addExpression.getText() + " ");
            this.addExpression.setCaretPosition(n);
        }
    }

    public void refreshDynamicControls(boolean bl, boolean bl2, boolean bl3) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (object instanceof Application) {
            selectApp = (Application)object;
            this.trialsSelected.setText("<html><p>The selected expressions will be applied to \n <br/ all the trials in the all of the experiment <br/ in the \"" + selectApp.getName() + "\" application.</p>");
            selectExp = null;
            selectTrial = null;
        } else if (object instanceof Experiment) {
            selectExp = (Experiment)object;
            ListIterator<Application> listIterator = perfExplorerConnection.getApplicationList();
            while (listIterator.hasNext() && (selectApp = listIterator.next()).getID() != selectExp.getApplicationID()) {
            }
            selectTrial = null;
            this.trialsSelected.setText("<html> <p> The selected expressions will be applied to \n <br/all the trials in the \"" + selectExp.getName() + "\" experiment \n<br/in the \"" + selectApp.getName() + "\" application. \n </p> ");
        } else if (object instanceof Trial) {
            selectTrial = (Trial)object;
            ListIterator<Application> listIterator = perfExplorerConnection.getApplicationList();
            while (listIterator.hasNext() && (selectApp = listIterator.next()).getID() != selectTrial.getApplicationID()) {
            }
            ListIterator<Experiment> listIterator2 = perfExplorerConnection.getExperimentList(selectTrial.getApplicationID());
            while (listIterator2.hasNext() && (selectExp = listIterator2.next()).getID() != selectTrial.getExperimentID()) {
            }
            this.trialsSelected.setText("<html> <p> The selected expressions will be applied to the \"" + selectTrial.getName() + "\" trial \n <br/from the \"" + selectExp.getName() + "\" experiment\n <br/ from the \"" + selectApp.getName() + "\" application.\n</p>");
        }
        if (selectTrial != null || selectExp != null || selectApp != null) {
            // empty if block
        }
        if (object instanceof Metric) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.selectAll)) {
            int[] nArray = new int[this.expressionList.getSize()];
            for (int i = 0; i < this.expressionList.getSize(); ++i) {
                nArray[i] = i;
            }
            this.expression.setSelectedIndices(nArray);
        } else if (object.equals(this.insert)) {
            String string = this.addExpression.getText();
            if (string == null) {
                JOptionPane.showMessageDialog(this, "You cannot add a blank expression.", "Warning", 2);
            } else if (string.trim().equals("")) {
                JOptionPane.showMessageDialog(this, "You cannot add a blank expression.", "Warning", 2);
            } else {
                boolean bl = this.validate(string);
                if (bl) {
                    this.expressionList.addElement(string.trim());
                }
            }
        } else if (object.equals(this.deselect)) {
            this.expression.getSelectionModel().clearSelection();
        } else if (object.equals(this.apply)) {
            if (this.addExpression.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
            } else {
                this.deriveMetric(this.addExpression.getText().trim());
            }
        } else if (object.equals(this.derive)) {
            if (this.expression.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
            } else {
                this.deriveMetric();
            }
        } else if (object.equals(this.edit)) {
            if (this.expression.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
            } else {
                this.edit(this.expression.getSelectedValue().toString());
            }
        } else if (object.equals(this.remove)) {
            this.remove();
        } else if (object.equals(this.validate)) {
            String string = this.expression.getSelectedValue().toString();
            boolean bl = this.validate(string);
            if (bl) {
                JOptionPane.showMessageDialog(this, "This expression is correct.", "Correct", 1);
            }
        } else if (object.equals(this.plus)) {
            this.insertText("+");
        } else if (object.equals(this.minus)) {
            this.insertText("-");
        } else if (object.equals(this.times)) {
            this.insertText("*");
        } else if (object.equals(this.divide)) {
            this.insertText("/");
        } else if (object.equals(this.leftParen)) {
            this.insertText("(");
        } else if (object.equals(this.rightParen)) {
            this.insertText(")");
        } else if (object.equals(this.equals)) {
            this.insertText("=");
        } else if (object.equals(this.clear)) {
            this.addExpression.setText("");
            this.addExpression.requestFocusInWindow();
        }
    }

    private void remove() {
        if (this.expression.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
        } else {
            while (!this.expression.isSelectionEmpty()) {
                this.expressionList.removeElementAt(this.expression.getSelectedIndex());
            }
        }
    }

    private void edit(String string) {
        String string2 = (String)JOptionPane.showInputDialog(this, "Edit Expression:\n", "Edit", -1, null, null, string);
        if (string2 != null) {
            boolean bl = this.validate(string2);
            if (bl) {
                int n = this.expression.getSelectedIndex();
                this.expressionList.removeElementAt(n);
                this.expressionList.add(n, string2);
            } else {
                this.edit(string2);
            }
        }
    }

    private boolean validate(String string) {
        boolean bl = PerfExplorerExpression.validate(string);
        if (!bl) {
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "The expression you entered is not valid.", "Invalid Expression", 0);
        }
        return bl;
    }

    private void deriveMetric() {
        Object[] objectArray = this.expression.getSelectedValues();
        String string = "";
        for (Object object : objectArray) {
            string = string + object + "\n";
        }
        this.deriveMetric(string);
    }

    private void deriveMetric(String string) {
        String string2 = "Are you sure you want to apply the selected expressions to \n";
        if (selectTrial != null) {
            string2 = string2 + "the \"" + selectTrial.getName() + "\" trial from the \"" + selectExp.getName() + "\" experiment from the \"" + selectApp.getName() + "\" application?";
        } else if (selectExp != null) {
            string2 = string2 + "all the trials in the \"" + selectExp.getName() + "\" experiment in the \"" + selectApp.getName() + "\" application?";
        } else if (selectApp != null) {
            string2 = string2 + "all the trials in the all of the exepriments in the \"" + selectApp.getName() + "\" application?";
        } else {
            JOptionPane.showMessageDialog(this, "Please select a trial, exerpriment, or application.", "Warning", 2);
            return;
        }
        int n = JOptionPane.showOptionDialog(this, string2, "Confirm Trials", 0, 2, null, null, null);
        if (n == 1) {
            return;
        }
        try {
            PerfExplorerExpression perfExplorerExpression = new PerfExplorerExpression();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (selectApp != null) {
                string3 = selectApp.getName();
            }
            if (selectExp != null) {
                string4 = selectExp.getName();
            }
            if (selectTrial != null) {
                string5 = selectTrial.getName();
            }
            String string6 = perfExplorerExpression.getScriptFromExpressions(string3, string4, string5, string);
            PythonInterpreterFactory.defaultfactory.getPythonInterpreter().exec(string6);
            PerfExplorerJTree perfExplorerJTree = PerfExplorerJTree.getTree();
            TreePath treePath = perfExplorerJTree.getSelectionPath();
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (((PerfExplorerTreeNode)treeNode.getParent()).getUserObject() instanceof Experiment) {
                perfExplorerJTree.collapsePath(treePath);
                perfExplorerJTree.collapsePath(treePath.getParentPath());
                this.expandExp(treePath.getParentPath(), ((Trial)((PerfExplorerTreeNode)treeNode).getUserObject()).getName());
            } else {
                perfExplorerJTree.expandToMetricsAll(treePath);
            }
        }
        catch (ParsingException parsingException) {
            JOptionPane.showMessageDialog(this, "The expression did not parse correctly.\n" + parsingException.getMessage(), "Parse Error", 0);
        }
    }

    private void expandExp(TreePath treePath, String string) {
        PerfExplorerJTree perfExplorerJTree = PerfExplorerJTree.getTree();
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (((PerfExplorerTreeNode)treeNode).getUserObject() instanceof Metric) {
            return;
        }
        if (((PerfExplorerTreeNode)treeNode).getUserObject() instanceof Experiment) {
            // empty if block
        }
        perfExplorerJTree.expandPath(treePath);
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                Trial trial;
                TreeNode treeNode2 = enumeration.nextElement();
                if (!(((PerfExplorerTreeNode)treeNode2).getUserObject() instanceof Trial) || !(trial = (Trial)((PerfExplorerTreeNode)treeNode2).getUserObject()).getName().equals(string)) continue;
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                perfExplorerJTree.expandToMetricsAll(treePath2);
            }
        }
    }
}

