/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChartWindow;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.RMIChartData;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfExplorerBoxChart
extends PerfExplorerChartWindow {
    private static final long serialVersionUID = 5123404083269413029L;

    public PerfExplorerBoxChart(JFreeChart jFreeChart, String string) {
        super(jFreeChart, string);
    }

    public static void doIQRBoxChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.IQR_DATA);
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = PerfExplorerBoxChart.createDataset(rMIChartData);
        JFreeChart jFreeChart = PerfExplorerBoxChart.createChart(boxAndWhiskerCategoryDataset);
        PerfExplorerBoxChart perfExplorerBoxChart = new PerfExplorerBoxChart(jFreeChart, "Distributions of Significant Events");
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            perfExplorerBoxChart.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
    }

    private static BoxAndWhiskerCategoryDataset createDataset(RMIChartData rMIChartData) {
        int n = rMIChartData.getRows();
        int n2 = 1;
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = new DefaultBoxAndWhiskerCategoryDataset();
        List<String> list = rMIChartData.getRowLabels();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                List<Double> list2 = PerfExplorerBoxChart.createValueList(rMIChartData.getRowData(i));
                defaultBoxAndWhiskerCategoryDataset.add(list2, (Comparable)((Object)list.get(i)), (Comparable)((Object)""));
            }
        }
        return defaultBoxAndWhiskerCategoryDataset;
    }

    private static List<Double> createValueList(List<double[]> list) {
        double d;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d2 = d = list.get(0)[1];
        for (int i = 1; i < list.size(); ++i) {
            if (d > list.get(i)[1]) {
                d = list.get(i)[1];
            }
            if (!(d2 < list.get(i)[1])) continue;
            d2 = list.get(i)[1];
        }
        double d3 = d2 - d;
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new Double((list.get(i)[1] - d) / d3));
        }
        return arrayList;
    }

    private static JFreeChart createChart(BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset) {
        CategoryAxis categoryAxis = new CategoryAxis(null);
        NumberAxis numberAxis = new NumberAxis("Value");
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = new BoxAndWhiskerRenderer();
        boxAndWhiskerRenderer.setBaseToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
                BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
                return "<html>Min Outlier: " + boxAndWhiskerCategoryDataset.getMinOutlier(n, n2) + "<BR>Min Regular Value: " + boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2) + "<BR>Q1 Value: " + boxAndWhiskerCategoryDataset.getQ1Value(n, n2) + "<BR>Mean Value: " + boxAndWhiskerCategoryDataset.getMeanValue(n, n2) + "<BR>Q3 Value: " + boxAndWhiskerCategoryDataset.getQ3Value(n, n2) + "<BR>Max Regular Value: " + boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2) + "<BR>Max Outlier: " + boxAndWhiskerCategoryDataset.getMaxOutlier(n, n2) + "</html>";
            }
        });
        CategoryPlot categoryPlot = new CategoryPlot((CategoryDataset)boxAndWhiskerCategoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)boxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart("Significant (>2.0% of runtime) Event IQR Boxplot with Outliers", (Plot)categoryPlot);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setDomainGridlinePaint((Paint)Color.white);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)Color.white);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }
}

