/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDataSource;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTabbedPane;
import edu.uoregon.tau.perfexplorer.client.SAXTreeViewer;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.awt.Component;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PerfExplorerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8929532025416520825L;
    private Application application = null;
    private Experiment experiment = null;
    private Trial trial = null;
    private Metric metric = null;
    private RMISortableIntervalEvent event = null;
    private FunctionProfile ilp = null;
    private View view = null;
    private int type = -1;
    private String[] columnNames = new String[]{"Field", "Value"};
    private int currentTrial = 0;
    private int dividerLocation = 200;

    public PerfExplorerTableModel(Object object) {
        if (object != null) {
            this.updateObject(object);
        }
    }

    public void updateObject(Object object) {
        JSplitPane jSplitPane = (JSplitPane)PerfExplorerJTabbedPane.getPane().getTab(0);
        if (jSplitPane.getBottomComponent() != null) {
            this.dividerLocation = jSplitPane.getDividerLocation();
        }
        jSplitPane.setBottomComponent(null);
        this.currentTrial = 0;
        if (object instanceof Application) {
            this.application = (Application)object;
            this.type = 0;
        } else if (object instanceof Experiment) {
            this.experiment = (Experiment)object;
            this.type = 1;
        } else if (object instanceof TAUdbTrial) {
            this.trial = (Trial)object;
            TAUdbTrial tAUdbTrial = (TAUdbTrial)this.trial;
            DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession();
            try {
                databaseAPI.setTrial(this.trial.getID(), true);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            TAUdbDataSource tAUdbDataSource = new TAUdbDataSource(databaseAPI);
            tAUdbTrial.setDataSource((DataSource)tAUdbDataSource);
            if (!tAUdbTrial.hasMetadata()) {
                tAUdbTrial.loadMetadata(PerfExplorerServer.getServer().getDB());
            }
            this.type = 2;
        } else if (object instanceof Trial) {
            this.trial = (Trial)object;
            if (!this.trial.isXmlMetaDataLoaded()) {
                try {
                    this.trial.loadXMLMetadata(PerfExplorerServer.getServer().getDB());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.type = 2;
        } else if (object instanceof Metric) {
            this.metric = (Metric)object;
            this.type = 3;
        } else if (object instanceof RMISortableIntervalEvent) {
            this.event = (RMISortableIntervalEvent)object;
            this.ilp = this.event.getMeanSummary();
            this.type = 4;
        } else if (object instanceof View) {
            this.view = (View)object;
            this.type = 5;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        switch (this.type) {
            case 0: {
                return this.application.getNumFields() + 2;
            }
            case 1: {
                return this.experiment.getNumFields() + 2;
            }
            case 2: {
                return this.trial.getNumFields() + 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return View.getFieldCount();
            }
        }
        return 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValueAt(int n, int n2) {
        switch (this.type) {
            case 0: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                    }
                    if (this.application.getFieldName(n - 2) == null) return "";
                    return this.application.getFieldName(n - 2);
                }
                switch (n) {
                    case 0: {
                        return this.application.getName();
                    }
                    case 1: {
                        return new Integer(this.application.getID());
                    }
                }
                if (this.application.getField(n - 2) == null) return "";
                return this.application.getField(n - 2);
            }
            case 1: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Experiment ID";
                        }
                    }
                    if (this.experiment.getFieldName(n - 2) == null) return "";
                    return this.experiment.getFieldName(n - 2);
                }
                switch (n) {
                    case 0: {
                        return this.experiment.getName();
                    }
                    case 1: {
                        return new Integer(this.experiment.getID());
                    }
                }
                if (this.experiment.getField(n - 2) == null) return "";
                return this.experiment.getField(n - 2);
            }
            case 2: {
                Object object;
                if (this.trial instanceof TAUdbTrial && this.trial.getID() != this.currentTrial) {
                    Object object22;
                    MetaDataMap metaDataMap;
                    object = (TAUdbTrial)this.trial;
                    int n3 = 0;
                    MetaDataMap metaDataMap2 = object.getMetaData();
                    if (metaDataMap2 != null) {
                        n3 += metaDataMap2.size();
                    }
                    if ((metaDataMap = object.getUncommonMetaData()) != null) {
                        n3 += metaDataMap.size();
                    }
                    Object[][] objectArray = new String[n3][2];
                    Object[] objectArray2 = new String[]{"Name", "Value"};
                    int n4 = 0;
                    if (metaDataMap2 != null) {
                        for (Object object22 : metaDataMap2.entrySet()) {
                            objectArray[n4][0] = ((MetaDataMap.MetaDataKey)object22.getKey()).toString();
                            objectArray[n4][1] = ((MetaDataMap.MetaDataValue)object22.getValue()).toString();
                            ++n4;
                        }
                    }
                    if (metaDataMap != null) {
                        for (Object object22 : metaDataMap.entrySet()) {
                            objectArray[n4][0] = ((MetaDataMap.MetaDataKey)object22.getKey()).toString();
                            objectArray[n4][1] = ((MetaDataMap.MetaDataValue)object22.getValue()).toString();
                            ++n4;
                        }
                    }
                    JTable jTable = new JTable(objectArray, objectArray2);
                    object22 = new JScrollPane(jTable);
                    this.setupMetadataTable((JScrollPane)object22);
                }
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Trial ID";
                        }
                    }
                    if (this.trial.getFieldName(n - 2) == null) return "";
                    return this.trial.getFieldName(n - 2);
                }
                switch (n) {
                    case 0: {
                        return this.trial.getName();
                    }
                    case 1: {
                        return new Integer(this.trial.getID());
                    }
                }
                if (this.trial.getField(n - 2) == null) return "ted";
                if (!this.trial.getFieldName(n - 2).equalsIgnoreCase("XML_METADATA") || this.trial.getID() == this.currentTrial) return this.trial.getField(n - 2);
                try {
                    object = new SAXTreeViewer();
                    JScrollPane jScrollPane = new JScrollPane((Component)((SAXTreeViewer)object).getTreeTable(this.trial.getField(n - 2)));
                    this.setupMetadataTable(jScrollPane);
                    return this.trial.getFieldName(n - 2);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
            case 3: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Metric ID";
                        }
                        case 2: {
                            return "Trial ID";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.metric.getName();
                    }
                    case 1: {
                        return new Integer(this.metric.getID());
                    }
                    case 2: {
                        return new Integer(this.metric.getTrialID());
                    }
                }
                return "";
            }
            case 4: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Interval Event ID";
                        }
                        case 2: {
                            return "Group Name";
                        }
                        case 3: {
                            return "Trial ID";
                        }
                        case 4: {
                            return "Number of Calls";
                        }
                        case 5: {
                            return "Number of Subroutines";
                        }
                        case 6: {
                            return "Exclusive";
                        }
                        case 7: {
                            return "Inclusive";
                        }
                        case 8: {
                            return "Inclusive Per Call";
                        }
                    }
                    return "";
                }
                DecimalFormat decimalFormat = new DecimalFormat("#,##0");
                DecimalFormat decimalFormat2 = new DecimalFormat("#,##0.00");
                FieldPosition fieldPosition = new FieldPosition(0);
                StringBuffer stringBuffer = new StringBuffer();
                switch (n) {
                    case 0: {
                        return this.event.getFunction().getName();
                    }
                    case 1: {
                        return new Integer(this.event.getFunction().getID());
                    }
                    case 2: {
                        return this.event.getFunction().getGroupString();
                    }
                    case 3: {
                        return new Integer(this.event.getTrialID());
                    }
                    case 4: {
                        decimalFormat.format(this.ilp.getNumCalls(), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 5: {
                        decimalFormat.format(this.ilp.getNumSubr(), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 6: {
                        decimalFormat2.format(this.ilp.getExclusive(this.event.metricIndex), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 7: {
                        decimalFormat2.format(this.ilp.getInclusive(this.event.metricIndex), stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                    case 8: {
                        double d = this.ilp.getInclusive(this.event.metricIndex);
                        double d2 = this.ilp.getNumCalls();
                        decimalFormat2.format(d / d2, stringBuffer, fieldPosition);
                        return stringBuffer.toString();
                    }
                }
                return "";
            }
            case 5: {
                if (n2 == 0) {
                    if (View.getFieldName((int)n) == null) return "";
                    return View.getFieldName((int)n);
                }
                if (this.view.getField(n) == null) return "";
                return this.view.getField(n);
            }
        }
        return "";
    }

    private void setupMetadataTable(JScrollPane jScrollPane) {
        JSplitPane jSplitPane = (JSplitPane)PerfExplorerJTabbedPane.getPane().getTab(0);
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        jSplitPane.setBottomComponent(jScrollPane);
        jSplitPane.setDividerLocation(this.dividerLocation);
        this.currentTrial = this.trial.getID();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

