/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.AnalysisManagementPane;
import edu.uoregon.tau.perfexplorer.client.ChartGUI;
import edu.uoregon.tau.perfexplorer.client.ChartPane;
import edu.uoregon.tau.perfexplorer.client.DeriveMetricsPane;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTabbedPane;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTree;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTableModel;
import edu.uoregon.tau.perfexplorer.client.PerformanceExplorerPane;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PerfExplorerTreeSelectionListener
implements TreeSelectionListener {
    private JTree tree;
    private TreePath[] oldPaths = null;

    public PerfExplorerTreeSelectionListener(JTree jTree) {
        this.tree = jTree;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        if (treePathArray.length == 1) {
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
            final Object object = defaultMutableTreeNode.getUserObject();
            Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
            PerfExplorerModel.getModel().setCurrentSelection(objectArray);
            this.oldPaths = treePathArray;
            if (object instanceof Trial) {
                defaultMutableTreeNode.setUserObject(new String("Loading data, please wait..."));
                PerfExplorerJTree.nodeChanged(defaultMutableTreeNode);
                Thread thread = new Thread(){

                    public void run() {
                        PerfExplorerTreeSelectionListener.this.threadWork(defaultMutableTreeNode, object);
                    }
                };
                thread.start();
            } else {
                this.updateRightPanel(object);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            for (int i = 0; i < treePathArray.length; ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                arrayList.add(defaultMutableTreeNode.getUserObject());
                hashSet.add(new Integer(PerfExplorerJTree.getConnectionIndex(defaultMutableTreeNode)));
            }
            if (hashSet.size() > 1) {
                JOptionPane.showMessageDialog(null, "Please select only one type (Application, Experiment, Trial, Metric, Event) of level from one database.", "Selection Error", 0);
                this.tree.clearSelection();
                if (this.oldPaths != null) {
                    this.tree.setSelectionPaths(this.oldPaths);
                }
            } else if (!PerfExplorerModel.getModel().setMultiSelection(arrayList)) {
                JOptionPane.showMessageDialog(null, "Please select only one type (Application, Experiment, Trial, Metric, Event) of level.", "Selection Error", 0);
                this.tree.clearSelection();
                if (this.oldPaths != null) {
                    this.tree.setSelectionPaths(this.oldPaths);
                }
            } else {
                PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
                this.oldPaths = treePathArray;
            }
        }
    }

    private void threadWork(final DefaultMutableTreeNode defaultMutableTreeNode, final Object object) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PerfExplorerTreeSelectionListener.this.updateRightPanel(object);
                defaultMutableTreeNode.setUserObject(object);
                PerfExplorerJTree.nodeChanged(defaultMutableTreeNode);
            }
        });
    }

    public void updateRightPanel(Object object) {
        Serializable serializable;
        PerfExplorerJTabbedPane perfExplorerJTabbedPane = PerfExplorerJTabbedPane.getPane();
        int n = perfExplorerJTabbedPane.getSelectedIndex();
        if (n == 0) {
            serializable = (PerfExplorerTableModel)AnalysisManagementPane.getPane().getTable().getModel();
            ((PerfExplorerTableModel)serializable).updateObject(object);
        } else if (n == 3) {
            ChartPane.getPane().refreshDynamicControls(true, true, true);
            ChartPane.getPane().drawChart();
        } else if (n == 4) {
            DeriveMetricsPane.getPane().refreshDynamicControls(true, true, true);
        } else {
            PerformanceExplorerPane.getPane().updateImagePanel();
        }
        serializable = ChartGUI.getInstance(false);
        if (serializable != null) {
            ((ChartGUI)serializable).refresh();
        }
        perfExplorerJTabbedPane.update();
    }
}

