/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfexplorer.client.StatUtil;
import edu.uoregon.tau.perfexplorer.common.RMIChartData;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

public class ProbabilityPlotDataset
extends AbstractXYDataset
implements XYDataset {
    private static final long serialVersionUID = -6688676122111354782L;
    private List<String> seriesNames = null;
    private List<List<Point>> dataset = null;
    private List<Metric> metrics = null;
    private List<Metric> normalizedMetrics = null;

    public ProbabilityPlotDataset(RMIChartData rMIChartData) {
        Object object;
        Object object2;
        this.seriesNames = rMIChartData.getRowLabels();
        this.dataset = new ArrayList<List<Point>>();
        this.metrics = new ArrayList<Metric>();
        this.normalizedMetrics = new ArrayList<Metric>();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            Object object3;
            int n;
            Object object4;
            object2 = rMIChartData.getRowData(i);
            object = new ArrayList();
            double d = 0.0;
            double d2 = 0.0;
            double[] dArray = (double[])object2.get(0);
            d2 = dArray[1];
            d = dArray[1];
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int j = 0; j < object2.size(); ++j) {
                double[] dArray2 = (double[])object2.get(j);
                object4 = new Point(dArray2[0], dArray2[1]);
                object.add(object4);
                if (d2 > dArray2[1]) {
                    d2 = dArray2[1];
                }
                if (!(d < dArray2[1])) continue;
                d = dArray2[1];
            }
            double d7 = d - d2;
            for (n = 0; n < object.size(); ++n) {
                object3 = (Point)object.get(n);
                ((Point)object3).n = (((Point)object3).y - d2) / d7;
                d3 += ((Point)object3).y;
                d4 += ((Point)object3).n;
            }
            d3 /= (double)object.size();
            d4 /= (double)object.size();
            for (n = 0; n < object.size(); ++n) {
                object3 = (Point)object.get(n);
                ((Point)object3).rn = ((Point)object3).n - d4;
                ((Point)object3).r = ((Point)object3).y - d3;
                d6 += ((Point)object3).r * ((Point)object3).r;
                d5 += ((Point)object3).r * ((Point)object3).r;
            }
            d5 /= (double)(object.size() - 1);
            d5 = Math.sqrt(d5);
            d6 /= (double)(object.size() - 1);
            d6 = Math.sqrt(d6);
            for (n = 0; n < object.size(); ++n) {
                object3 = (Point)object.get(n);
                ((Point)object3).z = ((Point)object3).r / d5;
            }
            object4 = new Metric(d2, d, d3, d5);
            this.metrics.add((Metric)object4);
            object3 = new Metric(0.0, 1.0, d4, d6);
            this.normalizedMetrics.add((Metric)object3);
            Collections.sort(object);
            double d8 = 0.0;
            for (int j = 0; j < object.size(); ++j) {
                d8 = ((double)j + 0.5) / (double)object.size();
                Point point = (Point)object.get(j);
                point.p = d8;
                point.y = StatUtil.getInvCDF(d8, false);
            }
            this.dataset.add((List<Point>)object);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object2 = new Point(-3.0, -3.0);
        arrayList.add(object2);
        object = new Point(3.0, 3.0);
        arrayList.add(object);
        this.dataset.add(arrayList);
    }

    public int getSeriesCount() {
        return this.dataset.size();
    }

    public String getSeriesKey(int n) {
        if (n == this.dataset.size() - 1) {
            return new String("Ideal normal");
        }
        String string = this.seriesNames.get(n);
        return string;
    }

    public int getItemCount(int n) {
        List<Point> list = this.dataset.get(n);
        return list.size();
    }

    public Number getX(int n, int n2) {
        List<Point> list = this.dataset.get(n);
        Point point = list.get(n2);
        return new Double(point.y);
    }

    public String getTooltip(int n, int n2) {
        List<Point> list = this.dataset.get(n);
        Point point = list.get(n2);
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<html>process rank: ");
        decimalFormat.format(point.x, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>measured value: ");
        decimalFormat.format(point.m, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>expected percentile: ");
        decimalFormat.format(point.p, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>expected z-score: ");
        decimalFormat.format(point.y, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>z-score: ");
        decimalFormat.format(point.z, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>normalized value: ");
        decimalFormat.format(point.n, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>residual: ");
        decimalFormat.format(point.r, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer2.append("<BR>normalized residual: ");
        decimalFormat.format(point.rn, stringBuffer, fieldPosition);
        stringBuffer2.append(stringBuffer.toString());
        if (n < this.dataset.size() - 1) {
            Metric metric = this.metrics.get(n);
            stringBuffer = new StringBuffer();
            stringBuffer2.append("<BR>min: ");
            decimalFormat.format(metric.min, stringBuffer, fieldPosition);
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer2.append("<BR>max: ");
            decimalFormat.format(metric.max, stringBuffer, fieldPosition);
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer2.append("<BR>avg: ");
            decimalFormat.format(metric.avg, stringBuffer, fieldPosition);
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer2.append("<BR>stDev: ");
            decimalFormat.format(metric.stDev, stringBuffer, fieldPosition);
            stringBuffer2.append(stringBuffer.toString());
        }
        stringBuffer2.append("</html>");
        return stringBuffer2.toString();
    }

    public Number getY(int n, int n2) {
        List<Point> list = this.dataset.get(n);
        Point point = list.get(n2);
        return new Double(point.z);
    }

    public String getCorrelation(int n) {
        Object object;
        double d = 0.0;
        List<Point> list = this.dataset.get(n);
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            d += ((Point)object).z * ((Point)object).y;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        object = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        decimalFormat.format(new Double(d /= (double)(list.size() - 1)), stringBuffer, (FieldPosition)object);
        return stringBuffer.toString();
    }

    static class Metric {
        private double min = 0.0;
        private double max = 0.0;
        private double avg = 0.0;
        private double stDev = 0.0;

        public Metric(double d, double d2, double d3, double d4) {
            this.min = d;
            this.max = d2;
            this.avg = d3;
            this.stDev = d4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Point
    implements Comparable<Point> {
        public double x = 0.0;
        public double m = 0.0;
        public double y = 0.0;
        public double p = 0.0;
        public double n = 0.0;
        public double r = 0.0;
        public double rn = 0.0;
        public double z = 0.0;

        public Point(double d, double d2) {
            this.x = d;
            this.z = d;
            this.y = d2;
            this.m = d2;
        }

        @Override
        public int compareTo(Point point) {
            Point point2 = point;
            if (this.y < point2.y) {
                return -1;
            }
            if (this.y > point2.y) {
                return 1;
            }
            return 0;
        }
    }
}

