/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.AnalysisType;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.common.RMIVarianceData;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFacade {
    private final PerfExplorerConnection connection;
    private final PerfExplorerModel model;

    public ScriptFacade() {
        this.connection = PerfExplorerConnection.getConnection();
        this.model = PerfExplorerModel.getModel();
    }

    public ScriptFacade(String string) {
        PerfExplorerOutput.setQuiet(false);
        PerfExplorerConnection.setStandalone(true);
        PerfExplorerConnection.setConfigFile(string);
        this.connection = PerfExplorerConnection.getConnection();
        this.model = PerfExplorerModel.getModel();
    }

    public void doSomething() {
        PerfExplorerOutput.println("Testing Script Facade");
    }

    public void exit() {
        System.exit(0);
    }

    public Application setApplication(String string) {
        Application application = null;
        if (string == null) {
            throw new IllegalArgumentException("Application name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Application name cannot be an empty string.");
        }
        boolean bl = false;
        ListIterator<Application> listIterator = this.connection.getApplicationList();
        while (listIterator.hasNext() && !bl) {
            application = listIterator.next();
            if (!application.getName().equals(string)) continue;
            this.model.setCurrentSelection(application);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Application '" + string + "' not found.");
        }
        return application;
    }

    public Experiment setExperiment(String string) {
        Experiment experiment = null;
        if (string == null) {
            throw new IllegalArgumentException("Experiment name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Experiment name cannot be an empty string.");
        }
        Application application = this.model.getApplication();
        if (application == null) {
            throw new NullPointerException("Application selection is null. Please select an Application before setting the Experiment.");
        }
        boolean bl = false;
        ListIterator<Experiment> listIterator = this.connection.getExperimentList(application.getID());
        while (listIterator.hasNext() && !bl) {
            experiment = listIterator.next();
            if (!experiment.getName().equals(string)) continue;
            this.model.setCurrentSelection(experiment);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Experiment '" + string + "' not found.");
        }
        return experiment;
    }

    public Trial setTrial(String string) {
        Trial trial = null;
        if (string == null) {
            throw new IllegalArgumentException("Trial name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Trial name cannot be an empty string.");
        }
        Experiment experiment = this.model.getExperiment();
        if (experiment == null) {
            throw new NullPointerException("Experiment selection is null.  Please select an Experiment before setting the Trial.");
        }
        boolean bl = false;
        ListIterator<Trial> listIterator = this.connection.getTrialList(experiment.getID(), false);
        while (listIterator.hasNext() && !bl) {
            trial = listIterator.next();
            if (!trial.getName().equals(string)) continue;
            this.model.setCurrentSelection(trial);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Trial '" + string + "' not found.");
        }
        return trial;
    }

    public void setMetric(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Metric name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Metric name cannot be an empty string.");
        }
        Trial trial = this.model.getTrial();
        if (trial == null) {
            throw new NullPointerException("Trial selection is null.  Please select a Trial before setting the Metric.");
        }
        boolean bl = false;
        List list = trial.getMetrics();
        int n = list.size();
        for (int i = 0; i < n && !bl; ++i) {
            Metric metric = (Metric)list.get(i);
            if (!metric.getName().equals(string)) continue;
            this.model.setCurrentSelection(metric);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Metric '" + string + "' not found.");
        }
    }

    public void setDimensionReduction(TransformationType transformationType, String string) {
        if (transformationType == null) {
            throw new IllegalArgumentException("TransformationType type cannot be null.");
        }
        this.model.setDimensionReduction(transformationType);
        if (transformationType == TransformationType.OVER_X_PERCENT) {
            if (string == null) {
                throw new IllegalArgumentException("Object parameter cannot be null.");
            }
            this.model.setXPercent(string);
        }
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.model.setClusterMethod(analysisType);
    }

    public String requestAnalysis() {
        return this.connection.requestAnalysis(this.model, true);
    }

    public void doANOVA() {
        PerfExplorerOutput.println("Doing ANOVA");
    }

    public void do3DCorrelationCube() {
    }

    public void setMaximumNumberOfClusters(int n) {
    }

    public void createBoxChart() {
    }

    public void createHistograms() {
    }

    public void createNormalProbabilityChart() {
    }

    public void setChartSeriesXML(boolean bl) {
        this.model.setChartSeriesXML(bl);
    }

    public void setCategoricalXAxis(boolean bl) {
        this.model.setCategoricalXAxis(bl);
    }

    public boolean isCategoricalXAxis() {
        return this.model.isCategoricalXAxis();
    }

    public void showDataSummary() {
        RMIVarianceData rMIVarianceData = this.connection.requestVariationAnalysis(this.model);
        PerfExplorerOutput.print(UtilFncs.pad((String)rMIVarianceData.getValueName(0), (int)25).toUpperCase() + " ");
        for (int i = 1; i < rMIVarianceData.getValueCount(); ++i) {
            PerfExplorerOutput.print(UtilFncs.lpad((String)rMIVarianceData.getValueName(i), (int)11).toUpperCase() + " ");
        }
        PerfExplorerOutput.println("\n--------------------------------------------------------------------------------------------------------------------------------");
        Object[][] objectArray = rMIVarianceData.getDataMatrix();
        int n = 25;
        for (int i = 0; i < rMIVarianceData.getEventCount(); ++i) {
            Double d;
            if (this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT && (d = (Double)objectArray[i][2]) < this.model.getXPercent()) continue;
            for (int j = 0; j < rMIVarianceData.getValueCount(); ++j) {
                Object object;
                if (objectArray[i][j] instanceof String) {
                    object = (String)objectArray[i][j];
                    object = ((String)object).length() > n ? ((String)object).substring(0, n) : object;
                    PerfExplorerOutput.print(UtilFncs.pad((String)object, (int)n).toUpperCase() + " ");
                    continue;
                }
                if (!(objectArray[i][j] instanceof Double)) continue;
                object = (Double)objectArray[i][j];
                PerfExplorerOutput.print(UtilFncs.lpad((String)UtilFncs.formatDouble((double)((Double)object), (int)10, (boolean)true), (int)11) + " ");
            }
            PerfExplorerOutput.print("\n");
        }
        PerfExplorerOutput.print("\n");
    }

    public Object[] getTrialList(String string, boolean bl) {
        return this.connection.getTrialList(string, bl).toArray();
    }

    public void doGeneralChart() {
        PerfExplorerChart.doGeneralChart();
    }

    public void addApplication(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Application name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Application name cannot be an empty string.");
        }
        boolean bl = false;
        ListIterator<Application> listIterator = this.connection.getApplicationList();
        while (listIterator.hasNext() && !bl) {
            Application application = listIterator.next();
            if (!application.getName().equals(string)) continue;
            this.model.addSelection(application);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Application '" + string + "' not found.");
        }
    }

    public void addExperiment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Experiment name cannot be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Experiment name cannot be an empty string.");
        }
        Application application = this.model.getApplication();
        if (application == null) {
            throw new NullPointerException("Application selection is null. Please select an Application before setting the Experiment.");
        }
        boolean bl = false;
        ListIterator<Experiment> listIterator = this.connection.getExperimentList(application.getID());
        while (listIterator.hasNext() && !bl) {
            Experiment experiment = listIterator.next();
            if (!experiment.getName().equals(string)) continue;
            this.model.addSelection(experiment);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException("Experiment '" + string + "' not found.");
        }
    }

    public void setEventName(String string) {
        this.model.setEventName(string);
    }

    public void addEventName(String string) {
        this.model.addEventName(string);
    }

    public void setGroupName(String string) {
        this.model.setGroupName(string);
    }

    public void addGroupName(String string) {
        this.model.addGroupName(string);
    }

    public void setMetricName(String string) {
        this.model.setMetricName(string);
    }

    public void setChartMetadataFieldName(String string) {
        this.model.setChartMetadataFieldName(string);
    }

    public void setChartMetadataFieldValue(String string) {
        this.model.setChartMetadataFieldValue(string);
    }

    public void setChartSeriesName(String string) {
        this.model.setChartSeriesName(string);
    }

    public void setChartXAxisName(String string, String string2) {
        this.model.setChartXAxisName(string, string2);
    }

    public void setChartYAxisName(String string, String string2) {
        this.model.setChartYAxisName(string, string2);
    }

    public void setChartTitle(String string) {
        this.model.setChartTitle(string);
    }

    public void setChartUnits(String string) {
        this.model.setChartUnits(string);
    }

    public void setChartMainEventOnly(int n) {
        if (n == 0) {
            this.model.setMainEventOnly(false);
        } else {
            this.model.setMainEventOnly(true);
        }
    }

    public void setChartEventNoCallPath(int n) {
        if (n == 0) {
            this.model.setEventNoCallpath(false);
        } else {
            this.model.setEventNoCallpath(true);
        }
    }

    public void setChartEventExclusive100(int n) {
        if (n == 0) {
            this.model.setEventExclusive100(false);
        } else {
            this.model.setEventExclusive100(true);
        }
    }

    public void setChartLogYAxis(int n) {
        if (n == 0) {
            this.model.setChartLogYAxis(false);
        } else {
            this.model.setChartLogYAxis(true);
        }
    }

    public void setChartLogXAxis(int n) {
        this.model.setChartLogXAxis(n != 0);
    }

    public void setChartScalability(int n) {
        if (n == 0) {
            this.model.setChartScalability(false);
        } else {
            this.model.setChartScalability(true);
        }
    }

    public void setChartEfficiency(int n) {
        if (n == 0) {
            this.model.setChartEfficiency(false);
        } else {
            this.model.setChartEfficiency(true);
        }
    }

    public void setChartConstantProblem(int n) {
        if (n == 0) {
            this.model.setConstantProblem(false);
        } else {
            this.model.setConstantProblem(true);
        }
    }

    public void setChartHorizontal(int n) {
        if (n == 0) {
            this.model.setChartHorizontal(false);
        } else {
            this.model.setChartHorizontal(true);
        }
    }

    public void resetChartDefaults() {
        this.model.setGroupName(null);
        this.model.setMetricName(null);
        this.model.setEventName(null);
        this.setDimensionReduction(TransformationType.NONE, null);
        this.setChartMetadataFieldName(null);
        this.setChartMetadataFieldValue(null);
        this.setChartSeriesName(null);
        this.setChartXAxisName(null, null);
        this.setChartYAxisName(null, null);
        this.setChartTitle(null);
        this.setChartMainEventOnly(0);
        this.setChartEventNoCallPath(0);
        this.setChartEventExclusive100(0);
        this.setChartLogYAxis(0);
        this.setChartScalability(0);
        this.setChartEfficiency(0);
        this.setChartConstantProblem(0);
        this.setChartHorizontal(0);
    }

    public ListIterator<Application> getApplicationList() {
        return this.connection.getApplicationList();
    }

    public ListIterator<Experiment> getExperimentList() {
        return this.connection.getExperimentList(this.model.getApplication().getID());
    }

    public ListIterator<Trial> getTrialList(boolean bl) {
        return this.connection.getTrialList(this.model.getExperiment().getID(), false);
    }

    public ListIterator<RMISortableIntervalEvent> getEventList(Trial trial, int n) {
        return this.connection.getEventList(trial.getID(), n);
    }

    public void runComparisonRules(Trial trial, Trial trial2) {
    }

    public void setShowZero(int n) {
        if (n == 0) {
            this.model.setShowZero(false);
        } else {
            this.model.setShowZero(true);
        }
    }
}

