/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    protected boolean clockwise;
    private static Rectangle paintIconR;
    private static Rectangle paintTextR;
    private static Rectangle paintViewR;
    private static Insets paintViewInsets;

    public VerticalLabelUI(boolean bl) {
        this.clockwise = bl;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.height, dimension.width);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        paintViewInsets = jComponent.getInsets(paintViewInsets);
        VerticalLabelUI.paintViewR.x = VerticalLabelUI.paintViewInsets.left;
        VerticalLabelUI.paintViewR.y = VerticalLabelUI.paintViewInsets.top;
        VerticalLabelUI.paintViewR.height = jComponent.getWidth() - (VerticalLabelUI.paintViewInsets.left + VerticalLabelUI.paintViewInsets.right);
        VerticalLabelUI.paintViewR.width = jComponent.getHeight() - (VerticalLabelUI.paintViewInsets.top + VerticalLabelUI.paintViewInsets.bottom);
        VerticalLabelUI.paintIconR.height = 0;
        VerticalLabelUI.paintIconR.width = 0;
        VerticalLabelUI.paintIconR.y = 0;
        VerticalLabelUI.paintIconR.x = 0;
        VerticalLabelUI.paintTextR.height = 0;
        VerticalLabelUI.paintTextR.width = 0;
        VerticalLabelUI.paintTextR.y = 0;
        VerticalLabelUI.paintTextR.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.clockwise) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -jComponent.getWidth());
        } else {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-jComponent.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, VerticalLabelUI.paintIconR.x, VerticalLabelUI.paintIconR.y);
        }
        if (string != null) {
            int n = VerticalLabelUI.paintTextR.x;
            int n2 = VerticalLabelUI.paintTextR.y + fontMetrics.getAscent();
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string2, n, n2);
            } else {
                this.paintDisabledText(jLabel, graphics, string2, n, n2);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    static {
        labelUI = new VerticalLabelUI(false);
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
    }
}

