/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering;

import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;

public class DistanceMatrix {
    protected int dimension = 0;
    protected double[][] distances = null;
    protected double[] weights = null;

    public DistanceMatrix(int n) {
        this.dimension = n;
        this.distances = new double[n][n];
        this.weights = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                this.distances[i][j] = 0.0;
            }
            this.weights[i] = 1.0;
        }
    }

    public DistanceMatrix(DistanceMatrix distanceMatrix) {
        this.dimension = distanceMatrix.dimension;
        this.distances = new double[this.dimension][this.dimension];
        this.weights = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                this.distances[i][j] = distanceMatrix.distances[i][j];
            }
            this.weights[i] = distanceMatrix.weights[i];
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public double elementAt(int n, int n2) {
        return this.distances[n][n2];
    }

    public void solveManhattanDistances(RawDataInterface rawDataInterface) {
        System.out.println("Using Manhattan distances...");
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = rawDataInterface.getManhattanDistance(i, j);
                this.distances[j][i] = d;
                this.distances[i][j] = d;
            }
        }
    }

    public void solveCartesianDistances(RawDataInterface rawDataInterface) {
        System.out.println("Using Cartesian distances...");
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = rawDataInterface.getCartesianDistance(i, j);
                this.distances[j][i] = d;
                this.distances[i][j] = d;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                stringBuilder.append(this.distances[i][j] + " ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void mergeDistances(int n, int n2) {
        for (int i = 0; i < this.dimension; ++i) {
            double d = this.weights[n];
            double d2 = this.weights[n2];
            double d3 = d + d2;
            this.distances[n][i] = (this.distances[n][i] * d + this.distances[n2][i] * d) / d3;
            this.weights[n] = d3;
        }
    }
}

