/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.ClusterDescription;
import edu.uoregon.tau.perfexplorer.clustering.ClusterException;
import edu.uoregon.tau.perfexplorer.clustering.DBScanClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.DistanceMatrix;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaAbstractCluster;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaRawData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.clusterers.DBScan;
import weka.core.Instance;
import weka.core.Instances;

public class WekaDBScanCluster
extends WekaAbstractCluster
implements DBScanClusterInterface {
    private double e = 0.0;
    private DBScan dbscan = null;
    private int[] clusterSizes = null;
    private List<Integer>[] clusterIndexes = null;
    private int minPoints = 4;

    WekaDBScanCluster() {
        this.reset();
    }

    public void reset() {
        this.clusterCentroids = null;
        this.clusterMaximums = null;
        this.clusterMinimums = null;
        this.clusterStandardDeviations = null;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.instances = (Instances)rawDataInterface.getData();
        this.inputData = rawDataInterface;
    }

    public void findClusters() throws ClusterException {
        try {
            this.dbscan = new DBScan();
            this.dbscan.setMinPoints(this.minPoints);
            this.dbscan.setEpsilon(this.e);
            Instances instances = null;
            instances = this.instances;
            this.dbscan.buildClusterer(instances);
            this.generateStats();
            this.evaluateCluster();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public int guessEpsilonIndex() {
        int n;
        double[] dArray = this.getKDistances();
        for (int i = n = dArray.length - 2; i > 1; --i) {
            double d = (dArray[i - 1] + dArray[i] + dArray[i + 1]) / 3.0;
            if (!(d < dArray[i])) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public double guessEpsilon() {
        double[] dArray = this.getKDistances();
        return dArray[this.guessEpsilonIndex()];
    }

    public double[] getKDistances() {
        RawDataInterface rawDataInterface = this.inputData;
        DistanceMatrix distanceMatrix = new DistanceMatrix(rawDataInterface.numVectors());
        distanceMatrix.solveCartesianDistances(rawDataInterface);
        double[] dArray = new double[rawDataInterface.numVectors()];
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            double[] dArray2 = new double[rawDataInterface.numVectors()];
            for (int j = 0; j < rawDataInterface.numVectors(); ++j) {
                dArray2[j] = distanceMatrix.elementAt(i, j);
            }
            Arrays.sort(dArray2);
            dArray[i] = dArray2[this.minPoints];
        }
        Arrays.sort(dArray);
        return dArray;
    }

    private void generateStats() throws Exception {
        int n;
        int n2;
        if (this.instances == null) {
            this.instances = (Instances)this.inputData.getData();
        }
        this.clusterCentroids = new Instances(this.instances, this.dbscan.numberOfClusters());
        this.clusterMaximums = new Instances(this.instances, this.dbscan.numberOfClusters());
        this.clusterMinimums = new Instances(this.instances, this.dbscan.numberOfClusters());
        this.clusterStandardDeviations = new Instances(this.instances, this.dbscan.numberOfClusters());
        this.clusterIndexes = new List[this.dbscan.numberOfClusters()];
        for (n2 = 0; n2 < this.dbscan.numberOfClusters(); ++n2) {
            this.clusterIndexes[n2] = new ArrayList<Integer>();
        }
        for (n2 = 0; n2 < this.instances.numInstances(); ++n2) {
            try {
                n = this.dbscan.clusterInstance(this.instances.instance(n2));
                this.clusterIndexes[n].add(new Integer(n2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clusterSizes = new int[this.dbscan.numberOfClusters()];
        for (n2 = 0; n2 < this.dbscan.numberOfClusters(); ++n2) {
            this.clusterSizes[n2] = this.clusterIndexes[n2].size();
        }
        for (n2 = 0; n2 < this.dbscan.numberOfClusters(); ++n2) {
            double d;
            int n3;
            Instance instance;
            n = this.instances.firstInstance().numAttributes();
            double[] dArray = new double[n];
            Instance instance2 = new Instance(1.0, dArray);
            Instance instance3 = new Instance(1.0, dArray);
            Instance instance4 = new Instance(1.0, dArray);
            Instance instance5 = new Instance(1.0, dArray);
            Instance instance6 = new Instance(1.0, dArray);
            boolean bl = true;
            for (Integer n4 : this.clusterIndexes[n2]) {
                instance = this.instances.instance(n4.intValue());
                for (n3 = 0; n3 < n; ++n3) {
                    d = instance.value(n3);
                    instance2.setValue(n3, instance2.value(n3) + d);
                    instance4.setValue(n3, Math.max(instance4.value(n3), d));
                    if (bl) {
                        instance3.setValue(n3, d);
                        continue;
                    }
                    instance3.setValue(n3, Math.min(instance3.value(n3), d));
                }
                bl = false;
            }
            for (int i = 0; i < n; ++i) {
                instance5.setValue(i, instance2.value(i) / (double)this.clusterSizes[n2]);
            }
            this.clusterCentroids.add(instance5);
            this.clusterMaximums.add(instance4);
            this.clusterMinimums.add(instance3);
            for (Integer n4 : this.clusterIndexes[n2]) {
                instance = this.instances.instance(n4.intValue());
                for (n3 = 0; n3 < n; ++n3) {
                    d = instance.value(n3);
                    instance6.setValue(n3, instance6.value(n3) + Math.pow(instance5.value(n3) - d, 2.0));
                }
            }
            for (int i = 0; i < n; ++i) {
                instance6.setValue(i, Math.sqrt(instance6.value(i)));
            }
            this.clusterStandardDeviations.add(instance6);
        }
    }

    public ClusterDescription getClusterDescription(int n) throws ClusterException {
        return null;
    }

    public void setError(double d) {
        this.e = d;
    }

    public double getError() {
        return this.e;
    }

    public void setMinPoints(int n) {
        this.minPoints = n;
    }

    public int getMinPoints() {
        return this.minPoints;
    }

    public void setInitialCenters(int[] nArray) {
    }

    public RawDataInterface getClusterCentroids() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterCentroids);
        return wekaRawData;
    }

    public RawDataInterface getClusterMaximums() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterMaximums);
        return wekaRawData;
    }

    public RawDataInterface getClusterMinimums() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterMinimums);
        return wekaRawData;
    }

    public RawDataInterface getClusterStandardDeviations() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterStandardDeviations);
        return wekaRawData;
    }

    public int[] getClusterSizes() {
        return this.clusterSizes;
    }

    public int clusterInstance(int n) {
        int n2 = 0;
        try {
            n2 = this.dbscan.clusterInstance(this.instances.instance(n));
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    public int clusterInstance(Instance instance) throws Exception {
        int n = 0;
        try {
            n = this.dbscan.clusterInstance(instance);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public int getNumInstances() {
        return this.instances.numInstances();
    }

    protected void evaluateCluster() {
    }

    protected double getSquaredError() {
        return 0.0;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 2;
        int n3 = 2;
        int n4 = 10 * n3;
        ArrayList<String> arrayList = new ArrayList<String>(n4);
        arrayList.add("x");
        arrayList.add("y");
        WekaRawData wekaRawData = new WekaRawData("test", arrayList, n4, n2, null);
        for (int i = 0; i < n4; ++i) {
            int n5 = i % n3;
            System.out.print("modval: " + n5);
            for (int j = 0; j < n2; ++j) {
                double d = 0.5 + Math.random() / 10.0 + (double)n5;
                System.out.print(" val[" + j + "]: " + d);
                wekaRawData.addValue(i, j, d);
            }
            System.out.println("");
        }
        DBScanClusterInterface dBScanClusterInterface = AnalysisFactory.createDBScanEngine();
        dBScanClusterInterface.setInputData(wekaRawData);
        double d = dBScanClusterInterface.guessEpsilon();
        dBScanClusterInterface.setError(d);
        System.out.println("Using Epsilon: " + d);
        try {
            dBScanClusterInterface.findClusters();
        }
        catch (ClusterException clusterException) {
            clusterException.printStackTrace();
        }
        int[] nArray = dBScanClusterInterface.clusterInstances();
        for (n = 0; n < n4; ++n) {
            System.out.println("Instance " + n + " is in cluster: " + nArray[n]);
        }
        nArray = dBScanClusterInterface.getClusterSizes();
        for (n = 0; n < nArray.length; ++n) {
            System.out.println("Cluster " + n + " has " + nArray[n] + " members.");
        }
        System.out.println("Total clusters: " + dBScanClusterInterface.getClusterCentroids().numVectors());
    }
}

