/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.DataNormalizer;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaRawData;
import java.util.List;

public class WekaDataNormalizer
implements DataNormalizer {
    private RawDataInterface _normalizedData = null;

    private WekaDataNormalizer() {
    }

    public WekaDataNormalizer(RawDataInterface rawDataInterface) {
        int n = rawDataInterface.numDimensions();
        int n2 = rawDataInterface.numVectors();
        List<String> list = rawDataInterface.getEventNames();
        String string = rawDataInterface.getName();
        double[][] dArray = new double[n][2];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = rawDataInterface.getValue(0, i);
            dArray[i][1] = rawDataInterface.getValue(0, i);
            for (int j = 0; j < n2; ++j) {
                if (dArray[i][0] > rawDataInterface.getValue(j, i)) {
                    dArray[i][0] = rawDataInterface.getValue(j, i);
                }
                if (!(dArray[i][1] < rawDataInterface.getValue(j, i))) continue;
                dArray[i][1] = rawDataInterface.getValue(j, i);
            }
            dArray[i][1] = dArray[i][1] - dArray[i][0];
        }
        this._normalizedData = new WekaRawData(string, list, n2, n, null);
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                d = rawDataInterface.getValue(i, j);
                d -= dArray[j][0];
                this._normalizedData.addValue(i, j, d /= dArray[j][1]);
            }
        }
    }

    public RawDataInterface getNormalizedData() {
        return this._normalizedData;
    }
}

