/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.cqos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.functions.PaceRegression;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.converters.CSVLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaClassifierWrapper
implements Serializable {
    private static final long serialVersionUID = -3288768059845773266L;
    public static final String SUPPORT_VECTOR_MACHINE = "weka.classifiers.functions.SMO";
    public static final String SUPPORT_VECTOR_MACHINE2 = "weka.classifiers.functions.SMOreg";
    public static final String NAIVE_BAYES = "weka.classifiers.bayes.NaiveBayes";
    public static final String MULTILAYER_PERCEPTRON = "weka.classifiers.functions.MultilayerPerceptron";
    public static final String LINEAR_REGRESSION = "weka.classifiers.functions.LinearRegression";
    public static final String J48 = "weka.classifiers.trees.J48";
    public static final String AODE = "weka.classifiers.bayes.AODE";
    public static final String ALTERNATING_DECISION_TREE = "weka.classifiers.trees.ADTree";
    public static final String RANDOM_TREE = "weka.classifiers.trees.RandomTree";
    private String classifierType = "weka.classifiers.functions.MultilayerPerceptron";
    private String[] metadataFields = null;
    private List<Map<String, String>> trainingData = null;
    private int fieldCount = 0;
    private String classLabel = null;
    private Classifier cls = null;
    private Attribute classAttr = null;
    private FastVector attributes = new FastVector();
    private Attribute[] attArray = null;
    private double confidence = 0.0;
    private String className = null;
    private Set<String>[] nominalAttributes = null;
    private Instances train = null;
    private String csvFile = null;

    public WekaClassifierWrapper(List<Map<String, String>> list, String string) throws Exception {
        this.trainingData = list;
        this.classLabel = string;
        Map<String, String> map = list.get(0);
        if (map instanceof HashMap) {
            HashMap hashMap = (HashMap)map;
            this.metadataFields = new String[hashMap.keySet().size()];
            this.metadataFields[this.fieldCount++] = string;
            for (String string2 : hashMap.keySet()) {
                if (string2.equals(string)) continue;
                this.metadataFields[this.fieldCount++] = string2;
            }
        } else {
            throw new Exception("WekaClassifierWrapper only supports a training data in the form:\n\tList<Map<String,String>> ");
        }
    }

    public WekaClassifierWrapper(String string, String string2) throws Exception {
        this.csvFile = string;
        this.classLabel = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void buildClassifier() {
        if (this.csvFile != null) {
            try {
                CSVLoader cSVLoader = new CSVLoader();
                cSVLoader.setSource(new File(this.csvFile));
                this.train = cSVLoader.getDataSet();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                return;
            }
            int n = 0;
            Enumeration enumeration = this.train.enumerateAttributes();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute.name().equals(this.classLabel)) {
                    this.train.setClassIndex(n);
                    break;
                }
                ++n;
            }
        } else {
            String string;
            this.checkForNominalAttributes();
            this.attArray = new Attribute[this.fieldCount];
            for (int i = 0; i < this.fieldCount; ++i) {
                void object;
                Object var2_10 = null;
                string = this.metadataFields[i];
                if (this.nominalAttributes[i] != null) {
                    FastVector fastVector = new FastVector();
                    for (String string2 : this.nominalAttributes[i]) {
                        if (string2 == null) continue;
                        fastVector.addElement((Object)string2);
                    }
                    Attribute attribute = new Attribute(string, fastVector);
                } else {
                    Attribute attribute = new Attribute(string);
                }
                if (string.equals(this.classLabel)) {
                    this.classAttr = object;
                }
                this.attArray[i] = object;
                this.attributes.addElement((Object)object);
            }
            this.train = new Instances("train", this.attributes, this.trainingData.size());
            this.train.setClass(this.classAttr);
            for (Map<String, String> map : this.trainingData) {
                string = new Instance(this.fieldCount);
                for (int i = 0; i < this.attArray.length; ++i) {
                    String string3 = map.get(this.attArray[i].name());
                    try {
                        string.setValue(this.attArray[i], Double.parseDouble(string3));
                        continue;
                    }
                    catch (Exception exception) {
                        if (string3 == null) continue;
                        string.setValue(this.attArray[i], string3);
                    }
                }
                this.train.add((Instance)string);
            }
        }
        try {
            if (this.classifierType == LINEAR_REGRESSION) {
                LinearRegression linearRegression = new LinearRegression();
                linearRegression.turnChecksOff();
                linearRegression.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
                linearRegression.setEliminateColinearAttributes(false);
                this.cls = linearRegression;
            } else {
                this.cls = Classifier.forName((String)this.classifierType, null);
            }
            this.cls.buildClassifier(this.train);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void checkForNominalAttributes() {
        int n;
        this.nominalAttributes = new Set[this.fieldCount];
        for (Map<String, String> map : this.trainingData) {
            for (n = 0; n < this.metadataFields.length; ++n) {
                String string = map.get(this.metadataFields[n]);
                try {
                    Double.parseDouble(string);
                    continue;
                }
                catch (Exception exception) {
                    this.nominalAttributes[n] = new HashSet<String>();
                }
            }
        }
        for (Map<String, String> map : this.trainingData) {
            for (n = 0; n < this.metadataFields.length; ++n) {
                if (this.nominalAttributes[n] == null) continue;
                this.nominalAttributes[n].add(map.get(this.metadataFields[n]));
            }
        }
    }

    public String getClass(Map<String, String> map) {
        Instances instances = new Instances("test", this.attributes, 1);
        Instance instance = new Instance(this.attArray.length);
        int n = 0;
        for (int i = 0; i < this.attArray.length; ++i) {
            String string = map.get(this.attArray[i].name());
            if (string != null) {
                try {
                    if (this.attArray[i].isNumeric()) {
                        instance.setValue(this.attArray[i], Double.parseDouble(string));
                    } else {
                        instance.setValue(this.attArray[i], string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!this.attArray[i].name().equals(this.classLabel)) continue;
            n = i;
        }
        instances.add(instance);
        instances.setClassIndex(n);
        instance = instances.firstInstance();
        try {
            double[] dArray = this.cls.distributionForInstance(instance);
            int n2 = 0;
            for (int i = 1; i < dArray.length; ++i) {
                if (!(dArray[i] > dArray[n2])) continue;
                n2 = i;
            }
            this.confidence = dArray[n2];
            this.className = this.classAttr.value(n2);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return this.className;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getClassName() {
        return this.className;
    }

    public static void writeClassifier(String string, WekaClassifierWrapper wekaClassifierWrapper) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(wekaClassifierWrapper);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static WekaClassifierWrapper readClassifier(String string) {
        WekaClassifierWrapper wekaClassifierWrapper = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            wekaClassifierWrapper = (WekaClassifierWrapper)object;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return wekaClassifierWrapper;
    }

    public String getClassifierType() {
        return this.classifierType;
    }

    public double[] getCoefficients() {
        double[] dArray = null;
        if (this.cls instanceof PaceRegression) {
            PaceRegression paceRegression = (PaceRegression)this.cls;
            dArray = paceRegression.coefficients();
        }
        return dArray;
    }

    public double classifyInstance(Map<String, String> map) {
        Instances instances = new Instances("test", this.attributes, 1);
        Instance instance = new Instance(this.attArray.length);
        int n = 0;
        for (int i = 0; i < this.attArray.length; ++i) {
            String string = map.get(this.attArray[i].name());
            if (string != null) {
                try {
                    if (this.attArray[i].isNumeric()) {
                        instance.setValue(this.attArray[i], Double.parseDouble(string));
                    } else {
                        instance.setValue(this.attArray[i], string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!this.attArray[i].name().equals(this.classLabel)) continue;
            n = i;
        }
        instances.add(instance);
        instances.setClassIndex(n);
        instance = instances.firstInstance();
        double d = 0.0;
        try {
            d = this.cls.classifyInstance(instance);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return d;
    }

    public void setClassifierType(String string) {
        this.classifierType = string;
        System.out.println("Set classifier type to: " + string);
    }

    public String crossValidateModel(int n) {
        String string = null;
        try {
            Evaluation evaluation = new Evaluation(this.train);
            evaluation.crossValidateModel(this.cls, this.train, n, new Random(123L), new Object[0]);
            string = evaluation.toMatrixString();
            string = string + evaluation.toSummaryString();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return string;
    }

    public List<String> testClassifier(String string) {
        Object object;
        Object object2;
        Enumeration enumeration;
        ArrayList<String> arrayList = new ArrayList<String>();
        Instances instances = new Instances(this.train, 0);
        Instances instances2 = null;
        try {
            CSVLoader cSVLoader = new CSVLoader();
            cSVLoader.setSource(new File(string));
            instances2 = cSVLoader.getDataSet();
            int n = 0;
            enumeration = instances2.enumerateAttributes();
            while (enumeration.hasMoreElements()) {
                object2 = (Attribute)enumeration.nextElement();
                if (object2.name().equals(this.classLabel)) {
                    instances2.setClassIndex(n);
                    break;
                }
                ++n;
            }
            enumeration = instances2.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                object2 = (Instance)enumeration.nextElement();
                Instance instance = new Instance(this.train.numAttributes());
                instance.setDataset(instances);
                object = instances.enumerateAttributes();
                while (object.hasMoreElements()) {
                    Attribute attribute = (Attribute)object.nextElement();
                    instance.setValue(instances.attribute(attribute.name()).index(), object2.value(instances2.attribute(attribute.name())));
                }
                instance.setValue(instances.classAttribute().index(), object2.value(instances2.classAttribute()));
                instances.add(instance);
            }
        }
        catch (Exception exception) {
            Attribute attribute;
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            System.out.println("Expected attributes:");
            Enumeration enumeration2 = this.train.enumerateAttributes();
            while (enumeration2.hasMoreElements()) {
                attribute = (Attribute)enumeration2.nextElement();
                System.out.print(attribute.name() + ", ");
            }
            System.out.println("\nFound attributes:");
            enumeration2 = instances2.enumerateAttributes();
            while (enumeration2.hasMoreElements()) {
                attribute = (Attribute)enumeration2.nextElement();
                System.out.print(attribute.name() + ", ");
            }
            System.out.println("\n");
            return arrayList;
        }
        try {
            int n = 0;
            Enumeration enumeration3 = instances.enumerateInstances();
            while (enumeration3.hasMoreElements()) {
                enumeration = (Instance)enumeration3.nextElement();
                object2 = this.cls.distributionForInstance((Instance)enumeration);
                int n2 = 0;
                object = new int[]{0, 0, 0, 0, 0};
                for (int i = 1; i < ((Attribute)object2).length; ++i) {
                    if (object2[i] > object2[n2]) {
                        n2 = i;
                    }
                    Object object3 = i;
                    for (int j = 0; j < 5; ++j) {
                        if (!(object2[object3] > object2[object[j]])) continue;
                        Object object4 = object[j];
                        object[j] = object3;
                        object3 = object4;
                    }
                }
                this.confidence = (double)object2[n2];
                this.className = this.train.classAttribute().value(n2);
                System.out.println(enumeration.stringValue(instances2.instance(n).classAttribute()) + "\t" + this.className + "\t" + this.confidence);
                arrayList.add(this.className);
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        WekaClassifierWrapper wekaClassifierWrapper = null;
        String string = "/tmp/pleasework";
        boolean bl = true;
        boolean bl2 = true;
        try {
            if (stringArray.length >= 1) {
                if (stringArray[0].equals("write")) {
                    bl = false;
                } else if (stringArray[0].equals("read")) {
                    bl2 = false;
                } else {
                    throw new Exception("bad first argument");
                }
                if (stringArray.length == 2) {
                    string = stringArray[1];
                    System.out.println(string);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.err.println("usage: cqos.WekaClassifierWrapper [read [filename] | write [filename]]");
            System.exit(0);
        }
        if (bl2) {
            HashMap<String, String> hashMap;
            int n;
            System.out.println("Writing...");
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
            object = "method name";
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("method name", "method 1");
            hashMap2.put("sleep value", "0");
            hashMap2.put("bogus", "A");
            hashMap2.put("noise", "A");
            hashMap2.put("more noise", "24.562");
            arrayList.add(hashMap2);
            hashMap2 = new HashMap();
            hashMap2.put("method name", "method 1");
            hashMap2.put("sleep value", "1");
            hashMap2.put("bogus", "A");
            hashMap2.put("noise", "A");
            hashMap2.put("more noise", "24.562");
            arrayList.add(hashMap2);
            hashMap2 = new HashMap();
            hashMap2.put("method name", "method 1");
            hashMap2.put("sleep value", "2");
            hashMap2.put("bogus", "B");
            hashMap2.put("noise", "A");
            hashMap2.put("more noise", "24.562");
            arrayList.add(hashMap2);
            hashMap2 = new HashMap();
            hashMap2.put("method name", "method 2");
            hashMap2.put("sleep value", "3");
            hashMap2.put("bogus", "B");
            hashMap2.put("noise", "A");
            hashMap2.put("more noise", "24.562");
            arrayList.add(hashMap2);
            hashMap2 = new HashMap();
            hashMap2.put("method name", "method 2");
            hashMap2.put("sleep value", "4");
            hashMap2.put("bogus", "B");
            hashMap2.put("noise", "A");
            hashMap2.put("more noise", "24.562");
            arrayList.add(hashMap2);
            System.out.println(arrayList);
            wekaClassifierWrapper = new WekaClassifierWrapper(arrayList, (String)object);
            wekaClassifierWrapper.setClassifierType(SUPPORT_VECTOR_MACHINE);
            wekaClassifierWrapper.buildClassifier();
            System.out.println("\n" + wekaClassifierWrapper.getClassifierType());
            for (n = 0; n < 5; ++n) {
                hashMap = new HashMap<String, String>();
                hashMap.put("sleep value", Integer.toString(n));
                hashMap.put("bogus", n < 2 ? "A" : "B");
                System.out.println(hashMap + ", " + wekaClassifierWrapper.getClass(hashMap) + ", confidence: " + wekaClassifierWrapper.getConfidence());
            }
            wekaClassifierWrapper = new WekaClassifierWrapper(arrayList, (String)object);
            wekaClassifierWrapper.setClassifierType(NAIVE_BAYES);
            wekaClassifierWrapper.buildClassifier();
            System.out.println("\n" + wekaClassifierWrapper.getClassifierType());
            for (n = 0; n < 5; ++n) {
                hashMap = new HashMap();
                hashMap.put("sleep value", Integer.toString(n));
                hashMap.put("bogus", n < 2 ? "A" : "B");
                hashMap.put("noise", "A");
                hashMap.put("more noise", "0.0");
                System.out.println(hashMap + ", " + wekaClassifierWrapper.getClass(hashMap) + ", confidence: " + wekaClassifierWrapper.getConfidence());
            }
            wekaClassifierWrapper = new WekaClassifierWrapper(arrayList, (String)object);
            wekaClassifierWrapper.setClassifierType(MULTILAYER_PERCEPTRON);
            wekaClassifierWrapper.buildClassifier();
            System.out.println("\n" + wekaClassifierWrapper.getClassifierType());
            for (n = 0; n < 5; ++n) {
                hashMap = new HashMap();
                hashMap.put("sleep value", Integer.toString(n));
                hashMap.put("bogus", n < 2 ? "A" : "B");
                hashMap.put("noise", "A");
                hashMap.put("more noise", "0.0");
                System.out.println(hashMap + ", " + wekaClassifierWrapper.getClass(hashMap) + ", confidence: " + wekaClassifierWrapper.getConfidence());
            }
            WekaClassifierWrapper.writeClassifier(string, wekaClassifierWrapper);
        }
        if (bl) {
            System.out.println("Reading...");
            wekaClassifierWrapper = WekaClassifierWrapper.readClassifier(string);
            System.out.println("\n" + wekaClassifierWrapper.getClassifierType());
            for (int i = 0; i < 5; ++i) {
                object = new HashMap();
                object.put("sleep value", Integer.toString(i));
                object.put("bogus", i < 2 ? "A" : (i < 4 ? "B" : "C"));
                object.put("noise", i == 0 ? "A" : (i == 1 ? "B" : (i == 2 ? "C" : (i == 3 ? "D" : "E"))));
                object.put("more noise", "0.0");
                System.out.println(object + ", " + wekaClassifierWrapper.getClass((Map<String, String>)object) + ", confidence: " + wekaClassifierWrapper.getConfidence());
            }
        }
    }
}

