/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.VectorExport;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.MyCategoryAxis;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialMetadata;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawGraph
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -5587605162968129610L;
    protected Set<String> _events = null;
    protected Set<String> _metrics = null;
    protected Set<Integer> _threads = null;
    public static final int TRIALNAME = 0;
    public static final int EVENTNAME = 1;
    public static final int METRICNAME = 2;
    public static final int THREADNAME = 3;
    public static final int USEREVENTNAME = 4;
    public static final int PROCESSORCOUNT = 5;
    public static final int METADATA = 6;
    public static final int MICROSECONDS = 1;
    public static final int MILLISECONDS = 1000;
    public static final int THOUSANDS = 1000;
    public static final int SECONDS = 1000000;
    public static final int MILLIONS = 1000000;
    public static final int MINUTES = 60000000;
    public static final int BILLIONS = 1000000000;
    public static final int LINECHART = 1;
    public static final int STACKEDAREACHART = 2;
    public static final int STACKEDBARCHART = 3;
    protected int units = 1;
    protected int seriesType = 2;
    protected int categoryType = 3;
    protected int valueType = 1;
    protected boolean logYAxis = false;
    protected boolean showZero = false;
    protected int categoryNameLength = 0;
    protected String title = "My Chart";
    protected String yAxisLabel = "value";
    protected String xAxisLabel = "category";
    protected boolean userEvents = false;
    protected String metadataField = "";
    protected PerfExplorerChart chartWindow = null;
    protected boolean shortenNames = false;
    protected int chartType = 1;
    protected boolean autoDisplayWindow = true;
    protected JFreeChart chart = null;
    protected boolean showLegend = true;
    String seriesMetadata = null;
    String categoryMetadata = null;

    public void setLegendVisible(boolean bl) {
        this.showLegend = bl;
    }

    public boolean isLegendVisible() {
        return this.showLegend;
    }

    public DrawGraph(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DrawGraph(Trial trial) {
        super(trial);
    }

    public DrawGraph(List<PerformanceResult> list) {
        super(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<PerformanceResult> processData() {
        DefaultTableXYDataset defaultTableXYDataset;
        Object object;
        Object object222;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Object object222 : this.inputs) {
            void set;
            Object i = null;
            object = null;
            Set<Integer> set2 = null;
            if (this._events == null) {
                if (this.userEvents) {
                    Set<String> logarithmicAxis = object222.getUserEvents();
                } else {
                    Set<String> set3 = object222.getEvents();
                }
            } else {
                Set<String> numberAxis = this._events;
            }
            object = this._metrics == null ? object222.getMetrics() : this._metrics;
            set2 = this._threads == null ? object222.getThreads() : this._threads;
            String string6 = "";
            String string2 = "";
            if (this.userEvents) {
                for (String string3 : set) {
                    for (Integer n : set2) {
                        if (this.seriesType == 0) {
                            string6 = object222.getTrial().getName();
                        } else if (this.seriesType == 4) {
                            string6 = string3;
                        } else if (this.seriesType == 3) {
                            string6 = n.toString();
                        }
                        if (this.categoryType == 0) {
                            string2 = object222.getTrial().getName();
                        } else if (this.categoryType == 4) {
                            string2 = string3;
                        } else if (this.categoryType == 3) {
                            string2 = n.toString();
                        } else if (this.categoryType == 5) {
                            string2 = Integer.toString(object222.getOriginalThreads());
                        }
                        defaultCategoryDataset.addValue(object222.getDataPoint(n, string3, null, this.valueType) / (double)this.units, (Comparable)((Object)string6), (Comparable)((Object)string2));
                        hashSet.add(string2);
                        hashSet2.add(string6);
                        this.categoryNameLength = this.categoryNameLength += string2.length();
                    }
                }
                continue;
            }
            for (String string3 : set) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    for (Integer n : set2) {
                        String string5;
                        TrialMetadata trialMetadata;
                        switch (this.seriesType) {
                            case 0: {
                                string6 = object222.getTrial().getName();
                                break;
                            }
                            case 1: {
                                if (this.shortenNames) {
                                    string6 = this.shortName(string3);
                                    break;
                                }
                                string6 = string3;
                                break;
                            }
                            case 2: {
                                string6 = string4;
                                break;
                            }
                            case 3: {
                                string6 = n.toString();
                                break;
                            }
                            case 6: {
                                trialMetadata = new TrialMetadata(object222.getTrial());
                                string5 = this.metadataField;
                                if (this.seriesMetadata != null) {
                                    string5 = this.seriesMetadata;
                                }
                                string6 = trialMetadata.getCommonAttributes().get(string5);
                            }
                        }
                        switch (this.categoryType) {
                            case 0: {
                                string2 = object222.getName();
                                break;
                            }
                            case 1: {
                                if (this.shortenNames) {
                                    string2 = this.shortName(string3);
                                    break;
                                }
                                string2 = string3;
                                break;
                            }
                            case 2: {
                                string2 = string4;
                                break;
                            }
                            case 3: {
                                string2 = n.toString();
                                break;
                            }
                            case 5: {
                                string2 = Integer.toString(object222.getOriginalThreads());
                                break;
                            }
                            case 6: {
                                trialMetadata = new TrialMetadata(object222.getTrial());
                                string5 = this.metadataField;
                                if (this.categoryMetadata != null) {
                                    string5 = this.categoryMetadata;
                                }
                                string2 = trialMetadata.getCommonAttributes().get(string5);
                            }
                        }
                        defaultCategoryDataset.addValue(object222.getDataPoint(n, string3, string4, this.valueType) / (double)this.units, (Comparable)((Object)string6), (Comparable)((Object)string2));
                        hashSet.add(string2);
                        hashSet2.add(string6);
                        this.categoryNameLength = this.categoryNameLength += string2.length();
                    }
                }
            }
        }
        this.chart = null;
        if (this.chartType == 2) {
            defaultTableXYDataset = new DefaultTableXYDataset();
            for (String string : hashSet2) {
                object = new XYSeries((Comparable)((Object)string), true, false);
                for (String string6 : hashSet) {
                    object.add(Double.parseDouble(string6), defaultCategoryDataset.getValue((Comparable)((Object)string), (Comparable)((Object)string6)));
                }
                defaultTableXYDataset.addSeries((XYSeries)object);
            }
            this.chart = ChartFactory.createStackedXYAreaChart((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (TableXYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)this.chart);
            if (!this.showLegend) {
                this.chart.removeLegend();
            }
        } else if (this.chartType == 3) {
            this.chart = ChartFactory.createStackedBarChart3D((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)this.chart);
            if (!this.showLegend) {
                this.chart.removeLegend();
            }
            defaultTableXYDataset = (CategoryPlot)this.chart.getPlot();
            object222 = defaultTableXYDataset.getRenderer();
            PerfExplorerChart.customizeColors((CategoryItemRenderer)object222);
        } else {
            void var6_14;
            this.chart = ChartFactory.createLineChart((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            Utility.applyDefaultChartTheme((JFreeChart)this.chart);
            if (!this.showLegend) {
                this.chart.removeLegend();
            }
            defaultTableXYDataset = (CategoryPlot)this.chart.getPlot();
            object222 = (LineAndShapeRenderer)defaultTableXYDataset.getRenderer();
            object222.setBaseShapesFilled(true);
            object222.setBaseShapesVisible(true);
            object222.setDrawOutlines(true);
            object222.setBaseItemLabelsVisible(true);
            boolean bl = false;
            while (var6_14 < defaultCategoryDataset.getRowCount()) {
                object222.setSeriesStroke((int)var6_14, (Stroke)new BasicStroke(2.0f));
                ++var6_14;
            }
            if (this.logYAxis) {
                LogarithmicAxis logarithmicAxis = new LogarithmicAxis(this.yAxisLabel);
                logarithmicAxis.setAutoRangeIncludesZero(true);
                logarithmicAxis.setAllowNegativesFlag(true);
                logarithmicAxis.setLog10TickLabelsFlag(true);
                defaultTableXYDataset.setRangeAxis(0, (ValueAxis)logarithmicAxis);
            }
            NumberAxis numberAxis = (NumberAxis)defaultTableXYDataset.getRangeAxis();
            numberAxis.setAutoRangeIncludesZero(this.showZero);
            object = null;
            object = new MyCategoryAxis(this.xAxisLabel);
            if (hashSet.size() > 40) {
                ((MyCategoryAxis)((Object)object)).setTickLabelSkip(hashSet.size() / 20);
                ((MyCategoryAxis)((Object)object)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else if (hashSet.size() > 20) {
                ((MyCategoryAxis)((Object)object)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else if (hashSet.size() > 0 && this.categoryNameLength / hashSet.size() > 10) {
                ((MyCategoryAxis)((Object)object)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            }
            defaultTableXYDataset.setDomainAxis((CategoryAxis)object);
        }
        if (this.autoDisplayWindow) {
            this.chartWindow = new PerfExplorerChart(this.chart, "General Chart");
        }
        return null;
    }

    public void setAutoDisplayWindow(boolean bl) {
        this.autoDisplayWindow = bl;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setEvents(Set<String> set) {
        this._events = set;
    }

    public void setMetrics(Set<String> set) {
        this._metrics = set;
    }

    public void setThreads(Set<Integer> set) {
        this._threads = set;
    }

    public void setCategoryType(int n) {
        this.categoryType = n;
    }

    public void setLogYAxis(boolean bl) {
        this.logYAxis = bl;
    }

    public void setSeriesType(int n) {
        this.seriesType = n;
    }

    public void setSeriesMetadata(String string) {
        this.seriesType = 6;
        this.seriesMetadata = string;
    }

    public void setCategoryMetadata(String string) {
        this.categoryType = 6;
        this.categoryMetadata = string;
    }

    public void setChartType(int n) {
        this.chartType = n;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setValueType(int n) {
        this.valueType = n;
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
    }

    public void setUserEvents(boolean bl) {
        this.userEvents = bl;
    }

    public void setShowZero(boolean bl) {
        this.showZero = bl;
    }

    public void setMetadataField(String string) {
        this.metadataField = string;
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public void drawChartToFile(String string) {
        try {
            if (this.chartWindow == null && this.chart != null) {
                this.chartWindow = new PerfExplorerChart(this.chart, "General Chart");
            }
            VectorExport.export((ImageExport)this.chartWindow, (File)new File(string), (boolean)true, (String)"PerfExplorer", (boolean)true, (boolean)true);
        }
        catch (Exception exception) {
            System.err.println("Could not write graph to file:");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String shortName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        string = string2;
        stringTokenizer = new StringTokenizer(string, "[{");
        string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2;
    }

    public void setShortenNames(boolean bl) {
        this.shortenNames = bl;
    }
}

