/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerActionListener;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChartWindow;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DrawGraph;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawMultiGraph
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -3530762753159608317L;
    private List<GraphTab> tabData;
    private String name;

    public DrawMultiGraph(String string, List<GraphTab> list) {
        this.tabData = list;
        this.name = string;
    }

    @Override
    public List<PerformanceResult> processData() {
        new MultiGraphWindow(this.name, this.tabData);
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "A REGION!!!";
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Foo", "Bar");
        linkedHashMap.put("fish", "stew");
        List<DrawGraph> list = null;
        GraphTabRegion graphTabRegion = new GraphTabRegion(string, list, linkedHashMap);
        String string2 = "B REGION!!!";
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        linkedHashMap2.put("Foob", "Barb");
        linkedHashMap2.put("fishb", "stewb");
        GraphTabRegion graphTabRegion2 = new GraphTabRegion(string2, list, linkedHashMap2);
        ArrayList<GraphTabRegion> arrayList = new ArrayList<GraphTabRegion>();
        arrayList.add(graphTabRegion);
        arrayList.add(graphTabRegion2);
        String string3 = "A TAB!!!";
        GraphTab graphTab = new GraphTab(string3, arrayList);
        ArrayList<GraphTab> arrayList2 = new ArrayList<GraphTab>();
        arrayList2.add(graphTab);
        arrayList2.add(new GraphTab("B TAB!!!", arrayList));
        new MultiGraphWindow("TESTING!!!", arrayList2);
    }

    public static class PerfExplorerMultiGraphJMenuBar
    extends JMenuBar {
        private static final long serialVersionUID = -6359699047764668001L;

        public PerfExplorerMultiGraphJMenuBar(ActionListener actionListener) {
            this.createFileMenu(actionListener);
            this.createHelpMenu(actionListener);
        }

        private void createFileMenu(ActionListener actionListener) {
            JMenu jMenu = new JMenu("File");
            jMenu.setMnemonic(70);
            JMenuItem jMenuItem = new JMenuItem("Close Window");
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
            this.add(jMenu);
        }

        private void createHelpMenu(ActionListener actionListener) {
            JMenu jMenu = new JMenu("Help");
            jMenu.setMnemonic(72);
            JMenuItem jMenuItem = new JMenuItem("About PerfExplorer", 65);
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Search For Help On...", 72);
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(72, 8));
            jMenuItem2.addActionListener(actionListener);
            jMenu.add(jMenuItem2);
            this.add(jMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GraphTabRegion
    implements Serializable {
        private static final long serialVersionUID = -1219370845965690129L;
        private String name;
        private List<ChartPanel> charts;
        private TableModel mapModel;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public GraphTabRegion(String string, List<DrawGraph> list, Map<String, String> map) {
            this.name = string;
            this.mapModel = new MapTableModel(map);
            this.charts = new ArrayList<ChartPanel>();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    list.get(i).setAutoDisplayWindow(false);
                    list.get(i).processData();
                    ChartPanel chartPanel = new ChartPanel(list.get(i).getChart());
                    chartPanel.setDisplayToolTips(true);
                    chartPanel.setMinimumSize(chartPanel.getPreferredSize());
                    this.charts.add(chartPanel);
                }
            }
        }

        public TableModel getMapModel() {
            return this.mapModel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GraphTab
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -933317318947126719L;
        private String name;
        private List<GraphTabRegion> regions;
        private JSplitPane tab = null;
        private JComboBox regionBox = null;
        private JTable table = null;
        private JPanel graphPanel = null;
        private JScrollPane graphScroll = null;

        public GraphTab(String string, List<GraphTabRegion> list) {
            this.name = string;
            this.regions = list;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public List<GraphTabRegion> getRegions() {
            return this.regions;
        }

        public void setRegions(List<GraphTabRegion> list) {
            this.regions = list;
        }

        public List<String> getRegionNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.regions != null) {
                for (int i = 0; i < this.regions.size(); ++i) {
                    arrayList.add(this.regions.get(i).getName());
                }
            }
            return arrayList;
        }

        public JComponent getTab() {
            if (this.tab != null) {
                return this.tab;
            }
            this.tab = this.createTab(this);
            return this.tab;
        }

        private JSplitPane createTab(GraphTab graphTab) {
            JComponent jComponent = this.createTablePane(graphTab.getRegions().get(0).getMapModel(), graphTab.getRegionNames());
            JComponent jComponent2 = this.createGraphPane(graphTab.getRegions().get(0).charts);
            JSplitPane jSplitPane = new JSplitPane(1, jComponent, jComponent2);
            return jSplitPane;
        }

        private JComponent createTablePane(TableModel tableModel, List<String> list) {
            this.table = new JTable(tableModel);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            if (list != null && list.size() > 0) {
                this.regionBox = new JComboBox<Object>(list.toArray());
                this.regionBox.addActionListener(this);
                Dimension dimension = new Dimension();
                dimension.setSize(100000, this.regionBox.getPreferredSize().height);
                this.regionBox.setMaximumSize(dimension);
                jPanel.add(this.regionBox);
            }
            jPanel.add(jScrollPane);
            return jPanel;
        }

        private JComponent createGraphPane(List<ChartPanel> list) {
            this.graphPanel = new JPanel();
            if (list != null) {
                this.graphPanel.setLayout(new BoxLayout(this.graphPanel, 3));
                for (int i = 0; i < list.size(); ++i) {
                    this.graphPanel.add((Component)list.get(i));
                }
            }
            this.graphScroll = new JScrollPane(this.graphPanel);
            return this.graphScroll;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.regionBox)) {
                GraphTabRegion graphTabRegion = this.regions.get(this.regionBox.getSelectedIndex());
                this.table.setModel(graphTabRegion.getMapModel());
                this.graphPanel.removeAll();
                for (int i = 0; i < graphTabRegion.charts.size(); ++i) {
                    this.graphPanel.add((Component)graphTabRegion.charts.get(i));
                }
                this.graphPanel.validate();
                this.graphPanel.repaint();
                this.graphScroll.revalidate();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiGraphWindow
    extends JFrame
    implements ActionListener {
        private static final long serialVersionUID = 5842078287780393184L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = actionEvent.getSource();
                if (object instanceof JMenuItem) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("About PerfExplorer")) {
                        this.createAboutWindow();
                    } else if (string.equals("Search For Help On...")) {
                        this.createHelpWindow();
                    } else if (string.equals("Close Window")) {
                        this.dispose();
                    } else {
                        System.out.println("unknown event! " + string);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("actionPerformed Exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }

        public void createAboutWindow() {
            long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
            String string = new String("PerfExplorer 1.0\n" + PerfExplorerActionListener.getVersionString() + "\nJVM Heap Size: " + l + "kb\n");
            JOptionPane.showMessageDialog(this, string, "About PerfExplorer", -1);
        }

        public void createHelpWindow() {
            JOptionPane.showMessageDialog(this, "Help not implemented.\nFor the most up-to-date documentation, please see\n<html><a href='http://www.cs.uoregon.edu/research/tau/'>http://www.cs.uoregon.edu/research/tau/</a></html>", "PerfExplorer Help", -1);
        }

        public MultiGraphWindow(String string, List<GraphTab> list) {
            super("TAU/PerfExplorer: " + string);
            Serializable serializable;
            JTabbedPane jTabbedPane = new JTabbedPane();
            for (int i = 0; i < list.size(); ++i) {
                serializable = list.get(i).getTab();
                jTabbedPane.addTab(list.get(i).getName(), (Component)serializable);
            }
            this.add(jTabbedPane);
            MultiGraphWindow multiGraphWindow = this;
            this.setJMenuBar(new PerfExplorerMultiGraphJMenuBar(multiGraphWindow));
            serializable = Utility.getResource((String)"tau32x32.gif");
            if (serializable != null) {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage((URL)serializable));
            }
            PerfExplorerChartWindow.centerFrame(this);
            this.pack();
            this.setVisible(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2404657420216796650L;
        Object[] tableData = null;
        private static final String colA = "Field";
        private static final String colB = "Value";

        public MapTableModel(Map<String, String> map) {
            this.tableData = map.entrySet().toArray();
        }

        @Override
        public int getRowCount() {
            if (this.tableData != null) {
                return this.tableData.length;
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            if (this.tableData != null) {
                return 2;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return colA;
            }
            if (n == 1) {
                return colB;
            }
            return "-";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.tableData == null || this.tableData.length < n) {
                return null;
            }
            Map.Entry entry = (Map.Entry)this.tableData[n];
            if (n2 == 0) {
                return entry.getKey();
            }
            if (n2 == 1) {
                return entry.getValue();
            }
            return null;
        }
    }
}

