/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.rules.RuleHarness;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;

public class MeanEventFact {
    public static final int NONE = 0;
    public static final int BETTER = 1;
    public static final int WORSE = 2;
    public static final int HIGHER = 3;
    public static final int LOWER = 4;
    private int betterWorse = 1;
    private String metric = null;
    private String meaningfulMetricName = null;
    private double mainValue = 0.0;
    private double eventValue = 0.0;
    private double severity = 0.0;
    private String eventName = null;
    private String factType = null;

    private MeanEventFact(String string, int n, String string2, String string3, double d, double d2, String string4, double d3) {
        this.factType = string;
        this.betterWorse = n;
        this.metric = string2;
        this.meaningfulMetricName = string3;
        this.mainValue = d;
        this.eventValue = d2;
        this.eventName = string4;
        this.severity = d3;
    }

    public static void compareEventToMain(PerformanceResult performanceResult, String string, PerformanceResult performanceResult2, String string2) {
        MeanEventFact.compareEventToMain(performanceResult, string, performanceResult2, string2, performanceResult.getTimeMetric());
    }

    public static void compareEventToMain(PerformanceResult performanceResult, String string, PerformanceResult performanceResult2, String string2, String string3) {
        if (string.equals(string2)) {
            return;
        }
        double d = performanceResult.getInclusive(0, string, string3);
        double d2 = performanceResult.getExclusive(0, string2, string3);
        double d3 = performanceResult.getInclusive(0, string2, string3);
        double d4 = d2 / d;
        double d5 = d3 / d;
        for (String string4 : performanceResult.getMetrics()) {
            double d6 = performanceResult.getInclusive(0, string, string4);
            double d7 = performanceResult2.getExclusive(0, string2, string4);
            double d8 = performanceResult2.getInclusive(0, string2, string4);
            if (string4.equals("((PAPI_L1_TCA-PAPI_L1_TCM)/PAPI_L1_TCA)")) {
                if (!(d6 > d7)) continue;
                RuleHarness.assertObject(new MeanEventFact("Compared to Main", 2, string4, "L1 cache hit rate", d6, d7, string2, d4));
                continue;
            }
            if (string4.equals("((PAPI_L1_TCM-PAPI_L2_TCM)/PAPI_L1_TCM)")) {
                if (!(d6 > d7)) continue;
                RuleHarness.assertObject(new MeanEventFact("Compared to Main", 2, string4, "L2 cache hit rate", d6, d7, string2, d4));
                continue;
            }
            if (string4.equals("(PAPI_FP_INS/P_WALL_CLOCK_TIME)")) {
                if (!(d6 < d7)) continue;
                RuleHarness.assertObject(new MeanEventFact("Compared to Main", 1, string4, "MFLOP/s", d6, d7, string2, d4));
                continue;
            }
            if (string4.equals("(PAPI_L1_TCA-PAPI_L1_TCM)")) continue;
            if (string4.equals("(PAPI_L1_TCA/P_WALL_CLOCK_TIME)")) {
                if (!(d6 > d7)) continue;
                RuleHarness.assertObject(new MeanEventFact("Compared to Main", 2, string4, "L1 cache access rate", d6, d7, string2, d4));
                continue;
            }
            if (string4.equals("(PAPI_L1_TCM-PAPI_L2_TCM)") || string4.equals("(PAPI_L1_TCM/P_WALL_CLOCK_TIME)") || string4.equals("(PAPI_TOT_INS/P_WALL_CLOCK_TIME)")) continue;
            if (d6 < d7) {
                RuleHarness.assertObject(new MeanEventFact("Compared to Main", 3, string4, string4, d6, d7, string2, d4));
            } else {
                RuleHarness.assertObject(new MeanEventFact("Compared to Main", 4, string4, string4, d6, d7, string2, d4));
            }
            if (d6 < d8) {
                RuleHarness.assertObject(new MeanEventFact("Inclusive compared to Main", 3, string4, string4, d6, d8, string2, d5));
                continue;
            }
            RuleHarness.assertObject(new MeanEventFact("Inclusive compared to Main", 4, string4, string4, d6, d8, string2, d5));
        }
    }

    public static void evaluateLoadBalance(PerformanceResult performanceResult, PerformanceResult performanceResult2, String string) {
        MeanEventFact.evaluateLoadBalance(performanceResult, performanceResult2, string, null, 1);
    }

    public static void evaluateLoadBalance(PerformanceResult performanceResult, PerformanceResult performanceResult2, String string, String string2) {
        MeanEventFact.evaluateLoadBalance(performanceResult, performanceResult2, string, string2, 1);
    }

    public static void evaluateLoadBalance(PerformanceResult performanceResult, PerformanceResult performanceResult2, String string, String string2, int n) {
        String string3 = performanceResult.getMainEvent();
        if (string3.equals(string)) {
            return;
        }
        String string4 = performanceResult.getTimeMetric();
        if (string4 == null || string4.equals("")) {
            string4 = string2;
        }
        double d = performanceResult.getInclusive(0, string3, string4);
        double d2 = performanceResult.getExclusive(0, string, string4);
        double d3 = d2 / d;
        Set<Object> set = new HashSet<String>();
        if (string2 != null) {
            set.add(string2);
        } else {
            set = performanceResult2.getMetrics();
        }
        for (String string5 : set) {
            double d4 = performanceResult2.getDataPoint(0, string, string5, n);
            double d5 = performanceResult.getDataPoint(0, string, string5, n);
            double d6 = performanceResult2.getDataPoint(0, string3, string5, n);
            if (d6 < d4) {
                RuleHarness.assertObject(new MeanEventFact("Load Imbalance", 3, string5, string5, d4, d5, string, d3));
                continue;
            }
            if (d6 < d4) {
                RuleHarness.assertObject(new MeanEventFact("Load Imbalance", 4, string5, string5, d4, d5, string, d3));
                continue;
            }
            RuleHarness.assertObject(new MeanEventFact("Load Imbalance", 0, string5, string5, d4, d5, string, d3));
        }
    }

    public static void evaluateMetric(PerformanceResult performanceResult, String string, String string2) {
        String string3 = performanceResult.getMainEvent();
        if (string3.equals(string)) {
            return;
        }
        String string4 = performanceResult.getTimeMetric();
        if (string4 == null || string4.equals("")) {
            string4 = string2;
        }
        double d = performanceResult.getInclusive(0, string3, string4);
        double d2 = performanceResult.getExclusive(0, string, string4);
        double d3 = d2 / d;
        Set<Object> set = new HashSet<String>();
        if (string2 != null) {
            set.add(string2);
        } else {
            set = performanceResult.getMetrics();
        }
        for (String string5 : set) {
            double d4 = performanceResult.getExclusive(0, string, string5);
            RuleHarness.assertObject(new MeanEventFact("Metric", 0, string5, string5, 0.0, d4, string, d3));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.betterWorse == 1) {
            stringBuilder.append("Better ");
        } else if (this.betterWorse == 2) {
            stringBuilder.append("Worse ");
        } else if (this.betterWorse == 3) {
            stringBuilder.append("Higher ");
        } else {
            stringBuilder.append("Lower ");
        }
        stringBuilder.append(this.mainValue + " ");
        stringBuilder.append(this.eventValue + " ");
        stringBuilder.append(this.eventName + " ");
        stringBuilder.append(this.metric + " ");
        stringBuilder.append(this.severity + " ");
        return stringBuilder.toString();
    }

    public int isBetterWorse() {
        return this.betterWorse;
    }

    public void setBetterWorse(int n) {
        this.betterWorse = n;
    }

    public double getEventValue() {
        return this.eventValue;
    }

    public void setEventValue(double d) {
        this.eventValue = d;
    }

    public double getMainValue() {
        return this.mainValue;
    }

    public void setMainValue(double d) {
        this.mainValue = d;
    }

    public String getMeaningfulMetricName() {
        return this.meaningfulMetricName;
    }

    public void setMeaningfulMetricName(String string) {
        this.meaningfulMetricName = string;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String string) {
        this.metric = string;
    }

    public double getSeverity() {
        return this.severity;
    }

    public void setSeverity(double d) {
        this.severity = d;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String string) {
        this.eventName = string;
    }

    public String getPercentage(Double d) {
        DecimalFormat decimalFormat = new DecimalFormat("00.00%");
        String string = decimalFormat.format(d);
        return string;
    }

    public String getPercentage() {
        return this.getPercentage(this.severity);
    }

    public String getFactType() {
        return this.factType;
    }

    public void setFactType(String string) {
        this.factType = string;
    }
}

