/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfexplorer.glue.PerformanceAnalysisOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Provenance {
    private static Provenance current = null;
    private static boolean enabled = false;
    private Long id = null;
    private Date date = null;
    private List<PerformanceAnalysisOperation> operations = null;

    private Provenance(boolean bl) {
        if (!bl) {
            this.date = new Date();
            this.operations = new ArrayList<PerformanceAnalysisOperation>();
            current = this;
        }
    }

    public static Provenance getCurrent() {
        if (current == null) {
            current = new Provenance(false);
        }
        return current;
    }

    static void addOperation(PerformanceAnalysisOperation performanceAnalysisOperation) {
        Provenance provenance = Provenance.getCurrent();
        if (!provenance.operations.contains(performanceAnalysisOperation) && enabled) {
            provenance.operations.add(performanceAnalysisOperation);
        }
    }

    public Long getId() {
        return this.id;
    }

    public List<PerformanceAnalysisOperation> getOperations() {
        return this.operations;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public void setOperations(List<PerformanceAnalysisOperation> list) {
        this.operations = list;
    }

    public static void save() {
    }

    public static void listAll() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.id == null) {
            stringBuilder.append(this.date.toString());
        } else {
            stringBuilder.append(this.date.toString() + " " + this.id.toString());
        }
        for (PerformanceAnalysisOperation performanceAnalysisOperation : this.operations) {
            stringBuilder.append("\n\toperation: " + ((Object)performanceAnalysisOperation).toString());
            for (PerformanceResult performanceResult : performanceAnalysisOperation.getInputs()) {
                stringBuilder.append("\n\t\tinput: " + ((Object)performanceResult).toString());
            }
            for (PerformanceResult performanceResult : performanceAnalysisOperation.getOutputs()) {
                stringBuilder.append("\n\t\toutput: " + ((Object)performanceResult).toString());
            }
        }
        return stringBuilder.toString();
    }

    public static PerformanceAnalysisOperation getLastOperation() {
        PerformanceAnalysisOperation performanceAnalysisOperation = null;
        Provenance provenance = Provenance.getCurrent();
        int n = provenance.getOperations().size();
        if (n > 0) {
            performanceAnalysisOperation = provenance.getOperations().get(n - 1);
        }
        return performanceAnalysisOperation;
    }

    public static List<PerformanceResult> getLastOutput() {
        List<PerformanceResult> list = null;
        PerformanceAnalysisOperation performanceAnalysisOperation = Provenance.getLastOperation();
        if (performanceAnalysisOperation != null) {
            list = performanceAnalysisOperation.getOutputs();
        }
        return list;
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }
}

