/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue.psl;

import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummary;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummaryIterator;

public abstract class Statistics {
    protected RegionSummaryIterator iterator = null;
    protected double min = Double.MAX_VALUE;
    protected double max = Double.MIN_VALUE;
    protected double avg = 0.0;
    protected double variance = 0.0;
    protected double stdDev = 0.0;
    protected double sum = 0.0;
    protected double squareSum = 0.0;
    protected int groupSize = 0;

    public Statistics(RegionSummaryIterator regionSummaryIterator) {
        this.iterator = regionSummaryIterator;
        this.buildStats();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSquareSum() {
        return this.squareSum;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    protected abstract double getValue(RegionSummary var1);

    private void buildStats() {
        RegionSummary regionSummary;
        while (this.iterator.hasNext()) {
            regionSummary = this.iterator.next();
            double d = this.getValue(regionSummary);
            ++this.groupSize;
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
            this.sum += d;
            this.squareSum += Math.pow(d, 2.0);
        }
        this.avg = this.sum / (double)this.groupSize;
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            regionSummary = this.iterator.next();
            this.variance += Math.pow(this.avg - this.getValue(regionSummary), 2.0);
        }
        this.variance /= (double)(this.groupSize - 1);
        this.stdDev = Math.sqrt(this.variance);
    }
}

