/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.common.Gzip;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import edu.uoregon.tau.perfexplorer.server.GeneralChartData;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import edu.uoregon.tau.perfexplorer.server.TauNamespaceContext;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbGeneralChartData
extends GeneralChartData {
    private static final long serialVersionUID = -6775990055590146350L;
    private RMIPerfExplorerModel model;
    private StringBuilder buf = null;

    public TAUdbGeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        super(chartDataType);
        this.model = rMIPerfExplorerModel;
        this.doQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() {
        Object object = null;
        DB dB = null;
        try {
            boolean bl;
            dB = PerfExplorerServer.getServer().getDB();
            String string = this.getListOfTrials();
            String string2 = this.getListOfMetrics();
            String string3 = this.model.getChartSeriesName();
            if (string3.equals("interval_event.name")) {
                string3 = "timer.name";
            }
            boolean bl2 = this.model.isChartSeriesXML();
            String string4 = this.model.getChartXAxisName();
            String string5 = this.model.getChartYAxisName();
            int n = string5.indexOf("(");
            int n2 = string5.indexOf(".");
            String string6 = string5.substring(0, n);
            String string7 = string5.substring(n2 + 1, string5.length() - 1);
            if (string5.contains("total")) {
                string6 = "sum";
            }
            if (string7.equals("inclusive")) {
                string7 = "inclusive_value";
            }
            if (string7.equals("exclusive")) {
                string7 = "exclusive_value";
            }
            if (string7.equalsIgnoreCase("INCLUSIVE_PERCENTAGE")) {
                string7 = "inclusive_percent";
            }
            if (string7.equalsIgnoreCase("EXCLUSIVE_PERCENTAGE")) {
                string7 = "exclusive_percent";
            }
            String string8 = "timer_value";
            this.buf = new StringBuilder();
            String string9 = null;
            if (string4.equals("primary_metadata.value")) {
                string9 = this.model.getChartMetadataFieldName();
            }
            boolean bl3 = bl = this.model.getDimensionReduction() != null && this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT;
            if (this.model.getMainEventOnly()) {
                this.buf.append(this.getMainOnlyQuery(dB, string, string2, this.getDervivedThreadRank(string6), string9, string3, bl2, string4, string8, string6, string7));
            } else if (this.model.getEventNames() == null && this.model.getEventNoCallpath()) {
                this.buf.append(this.getAllEventsNoCallpathMetadata(dB, string, string2, this.getDervivedThreadRank(string6), string9, string3, bl2, string4, string8, string6, string7));
            } else if (this.model.getEventNames() == null && !this.model.getEventNoCallpath()) {
                this.buf.append(this.getAllEventsCallpathMetadata(dB, string, string2, this.getDervivedThreadRank(string6), string9, string3, bl2, string4, string8, string6, string7));
            } else if (this.model.getEventNoCallpath()) {
                this.buf.append(this.getSomeEventsNoCallpathMetadata(dB, string, string2, this.getDervivedThreadRank(string6), string9, string3, bl2, string4, string8, string6, string7));
            } else if (!this.model.getEventNoCallpath()) {
                this.buf.append(this.getSomeEventsCallpathMetadata(dB, string, string2, this.getDervivedThreadRank(string6), string9, string3, bl2, string4, string8, string6, string7));
            }
            if (!this.model.getMainEventOnly() && bl && string7.contains("inclusive")) {
                this.buf.append(" where timer_value.inclusive_percent > " + this.model.getXPercent());
            } else if (!this.model.getMainEventOnly() && bl) {
                this.buf.append(" where timer_value.exclusive_percent > " + this.model.getXPercent());
            }
            this.buf.append(" group by series_name, xaxis_value ");
            this.buf.append("order by 1, 2 ");
            object = dB.prepareStatement(this.buf.toString());
            ResultSet resultSet = object.executeQuery();
            while (resultSet.next()) {
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (string3.startsWith("trial.node_count")) {
                        this.addRow(Integer.toString(resultSet.getInt(1) * resultSet.getInt(2) * resultSet.getInt(3)), resultSet.getString(4), resultSet.getDouble(5));
                        continue;
                    }
                    if (string4.startsWith("trial.node_count")) {
                        this.addRow(resultSet.getString(1), Integer.toString(resultSet.getInt(2) * resultSet.getInt(3) * resultSet.getInt(4)), resultSet.getDouble(5));
                        continue;
                    }
                    this.addRow(resultSet.getString(1), resultSet.getString(2), resultSet.getDouble(3));
                    continue;
                }
                this.addRow(resultSet.getString(1), resultSet.getString(2), resultSet.getDouble(3));
            }
            resultSet.close();
            object.close();
        }
        catch (Exception exception) {
            if (object != null) {
                PerfExplorerOutput.println(object.toString());
            } else {
                PerfExplorerOutput.println(this.buf.toString());
            }
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            try {
                dB.setAutoCommit(true);
                TAUdbGeneralChartData.dropTable(dB, "temp_event");
                if (!this.model.getChartSeriesName().equals("atomic_event.name")) {
                    TAUdbGeneralChartData.dropTable(dB, "temp_metric");
                }
                TAUdbGeneralChartData.dropTable(dB, "temp_xml_metadata");
                TAUdbGeneralChartData.dropTable(dB, "temp_trial");
            }
            catch (Exception exception) {}
        }
    }

    private int getDervivedThreadRank(String string) {
        if (string.equals("mean")) {
            return -1;
        }
        if (string.equals("total") || string.equals("sum")) {
            return -2;
        }
        if (string.equals("min")) {
            return -4;
        }
        if (string.equals("max")) {
            return -5;
        }
        if (string.equals("avg")) {
            return -6;
        }
        return 0;
    }

    private String getListOfMetrics() {
        String string = "( ";
        List<String> list = this.model.getMetricNames();
        for (String string2 : list) {
            string = string + "'" + string2 + "',";
        }
        string = string.substring(0, string.length() - 1);
        string = string + " )";
        return string;
    }

    private String getListOfTrials() {
        String string = "";
        List<Object> list = this.model.getMultiSelection();
        if (list == null) {
            Object object = this.model.getCurrentSelection();
            if (object instanceof Trial) {
                string = "( " + this.model.getTrial().getID() + " )";
            } else if (object instanceof View) {
                View view = (View)object;
                string = view.getTrialID();
            }
        } else {
            string = "( ";
            for (Object object : list) {
                if (object instanceof Trial) {
                    string = string + ((Trial)object).getID() + " , ";
                    continue;
                }
                System.err.println("We don't support mutli select of Views (yet?)");
            }
            string = string.substring(0, string.length() - 3);
            string = string + " )";
        }
        return string;
    }

    private String getMainOnlyQuery(DB dB, String string, String string2, int n, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8) throws SQLException {
        if (string7.equals("mean")) {
            string7 = "avg";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("select series_metadata.value as series_name, ");
        } else {
            stringBuffer.append("select " + string4 + " as series_name, ");
        }
        stringBuffer.append(string5 + " as xaxis_value, ");
        stringBuffer.append(string7 + "(" + string6 + "." + string8 + ") as yaxis_value from  ");
        stringBuffer.append(" (select trial.id,  max(timer_value.inclusive_value) as maxinc ");
        stringBuffer.append(" from  timer_value");
        stringBuffer.append(" inner join metric on metric.name in " + string2 + " and timer_value.metric=metric.id ");
        stringBuffer.append(" inner join thread on thread.thread_rank = " + n);
        stringBuffer.append(" inner join trial on thread.trial=trial.id and thread.trial in " + string);
        stringBuffer.append(" inner join timer_call_data on timer_call_data.thread = thread.id   and  timer_call_data.id = timer_value.timer_call_data ");
        stringBuffer.append(" inner join timer_callpath on timer_callpath.id=timer_call_data.timer_callpath ");
        stringBuffer.append(" inner join timer on timer_callpath.timer = timer.id       ");
        stringBuffer.append(" group by trial.id) as getmax");
        stringBuffer.append(" ,timer_value");
        stringBuffer.append(" inner join metric on metric.name in " + string2 + " and timer_value.metric=metric.id ");
        stringBuffer.append(" inner join thread on thread.thread_rank = " + n);
        stringBuffer.append(" inner join trial on thread.trial=trial.id and thread.trial in " + string);
        stringBuffer.append(" inner join timer_call_data on timer_call_data.thread = thread.id   and  timer_call_data.id = timer_value.timer_call_data ");
        stringBuffer.append(" inner join timer_callpath on timer_callpath.id=timer_call_data.timer_callpath ");
        stringBuffer.append(" inner join timer on timer_callpath.timer = timer.id   ");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("  inner join primary_metadata on primary_metadata.trial=trial.id and primary_metadata.name = '" + string3 + '\'');
        }
        if (bl) {
            stringBuffer.append("  inner join primary_metadata as series_metadata on series_metadata.trial=trial.id and series_metadata.name = '" + string4 + '\'');
        }
        stringBuffer.append(" where timer_value.inclusive_value = maxinc ");
        return stringBuffer.toString();
    }

    private String getAllEventsCallpathMetadata(DB dB, String string, String string2, int n, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8) throws SQLException {
        if (string7.equals("mean")) {
            string7 = "avg";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("select series_metadata.value as series_name, ");
        } else {
            stringBuffer.append("select " + string4 + " as series_name, ");
        }
        stringBuffer.append(string5 + " as xaxis_value, ");
        stringBuffer.append(string7 + "(" + string6 + "." + string8 + ") as yaxis_value from  ");
        stringBuffer.append(" timer_value");
        stringBuffer.append(" inner join metric on metric.name in " + string2 + " and timer_value.metric=metric.id ");
        stringBuffer.append(" inner join thread on thread.thread_rank = " + n);
        stringBuffer.append(" inner join trial on thread.trial=trial.id and thread.trial in " + string);
        stringBuffer.append(" inner join timer_call_data on timer_call_data.thread = thread.id   and  timer_call_data.id = timer_value.timer_call_data ");
        stringBuffer.append(" inner join timer_callpath on timer_callpath.id=timer_call_data.timer_callpath ");
        stringBuffer.append(" inner join timer on timer_callpath.timer = timer.id   ");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("  inner join primary_metadata on primary_metadata.trial=trial.id and primary_metadata.name = '" + string3 + '\'');
        }
        if (bl) {
            stringBuffer.append("  inner join primary_metadata as series_metadata on series_metadata.trial=trial.id and series_metadata.name = '" + string4 + '\'');
        }
        return stringBuffer.toString();
    }

    private String getAllEventsNoCallpathMetadata(DB dB, String string, String string2, int n, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8) throws SQLException {
        if (string7.equals("mean")) {
            string7 = "avg";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("select series_metadata.value as series_name, ");
        } else {
            stringBuffer.append("select " + string4 + " as series_name, ");
        }
        stringBuffer.append(string5 + " as xaxis_value, ");
        stringBuffer.append(string7 + "(" + string6 + "." + string8 + ") as yaxis_value from  ");
        stringBuffer.append(" timer_value");
        stringBuffer.append(" inner join metric on metric.name in " + string2 + " and timer_value.metric=metric.id ");
        stringBuffer.append(" inner join thread on thread.thread_rank = " + n);
        stringBuffer.append(" inner join trial on thread.trial=trial.id and thread.trial in " + string);
        stringBuffer.append(" inner join timer_call_data on timer_call_data.thread = thread.id   and  timer_call_data.id = timer_value.timer_call_data ");
        stringBuffer.append(" inner join timer_callpath on timer_callpath.id=timer_call_data.timer_callpath and timer_callpath.parent is null");
        stringBuffer.append(" inner join timer on timer_callpath.timer = timer.id   ");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("  inner join primary_metadata on primary_metadata.trial=trial.id and primary_metadata.name = '" + string3 + '\'');
        }
        if (bl) {
            stringBuffer.append("  inner join primary_metadata as series_metadata on series_metadata.trial=trial.id and series_metadata.name = '" + string4 + '\'');
        }
        return stringBuffer.toString();
    }

    private String getSomeEventsCallpathMetadata(DB dB, String string, String string2, int n, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8) throws SQLException {
        if (string7.equals("mean")) {
            string7 = "avg";
        }
        if (string4.equals("timer.name")) {
            string4 = "callpath.name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ");
        for (String string9 : this.model.getEventNames()) {
            stringBuilder.append("'" + string9 + "',");
        }
        String string10 = stringBuilder.substring(0, stringBuilder.length() - 1) + ") ";
        stringBuffer.append(" with recursive callpath (id, parent, timer, name) as (  ");
        stringBuffer.append(" SELECT tc.id, tc.parent, tc.timer, timer.name  ");
        stringBuffer.append(" FROM  timer_callpath tc inner join timer on tc.timer = timer.id where timer.trial in " + string + " and tc.parent is null ");
        stringBuffer.append(" UNION ALL ");
        stringBuffer.append(" SELECT d.id, d.parent, d.timer,  concat(callpath.name, ' => ', dt.name)  ");
        stringBuffer.append(" FROM timer_callpath AS d JOIN callpath ON (d.parent = callpath.id) join timer dt on d.timer = dt.id where dt.trial in " + string + " ) ");
        if (bl) {
            stringBuffer.append("select series_metadata.value as series_name, ");
        } else {
            stringBuffer.append("select " + string4 + " as series_name, ");
        }
        stringBuffer.append(string5 + " as xaxis_value, ");
        stringBuffer.append(string7 + "(" + string6 + "." + string8 + ") as yaxis_value from  ");
        stringBuffer.append(" timer_value ");
        stringBuffer.append(" inner join metric on metric.name in " + string2 + " and timer_value.metric=metric.id   ");
        stringBuffer.append(" inner join thread on thread.thread_rank = " + n);
        stringBuffer.append(" inner join trial on thread.trial=trial.id and thread.trial in " + string);
        stringBuffer.append(" inner join timer_call_data on timer_call_data.thread = thread.id   and  timer_call_data.id = timer_value.timer_call_data   ");
        stringBuffer.append(" inner join timer_callpath on timer_callpath.id=timer_call_data.timer_callpath  ");
        stringBuffer.append(" inner join callpath on  callpath.id = timer_callpath.id and callpath.name in " + (String)string10 + "   ");
        stringBuffer.append(" inner join timer on timer_callpath.timer = timer.id  ");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("  inner join primary_metadata on primary_metadata.trial=trial.id and primary_metadata.name = '" + string3 + '\'');
        }
        if (bl) {
            stringBuffer.append("  inner join primary_metadata as series_metadata on series_metadata.trial=trial.id and series_metadata.name = '" + string4 + '\'');
        }
        return stringBuffer.toString();
    }

    private String getSomeEventsNoCallpathMetadata(DB dB, String string, String string2, int n, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8) throws SQLException {
        if (string7.equals("mean")) {
            string7 = "avg";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ");
        for (String string9 : this.model.getEventNames()) {
            stringBuilder.append("'" + string9 + "',");
        }
        String string10 = stringBuilder.substring(0, stringBuilder.length() - 1) + ") ";
        if (bl) {
            stringBuffer.append("select series_metadata.value as series_name, ");
        } else {
            stringBuffer.append("select " + string4 + " as series_name, ");
        }
        stringBuffer.append(string5 + " as xaxis_value, ");
        stringBuffer.append(string7 + "(" + string6 + "." + string8 + ") as yaxis_value from  ");
        stringBuffer.append(" timer_value");
        stringBuffer.append(" inner join metric on metric.name in " + string2 + " and timer_value.metric=metric.id ");
        stringBuffer.append(" inner join thread on thread.thread_rank = " + n);
        stringBuffer.append(" inner join trial on thread.trial=trial.id and thread.trial in " + string);
        stringBuffer.append(" inner join timer_call_data on timer_call_data.thread = thread.id   and  timer_call_data.id = timer_value.timer_call_data ");
        stringBuffer.append(" inner join timer_callpath on timer_callpath.id=timer_call_data.timer_callpath and timer_callpath.parent is null");
        stringBuffer.append(" inner join timer on timer.name in " + (String)string10 + " and timer_callpath.timer = timer.id   ");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("  inner join primary_metadata on primary_metadata.trial=trial.id and primary_metadata.name = '" + string3 + '\'');
        }
        if (bl) {
            stringBuffer.append("  inner join primary_metadata as series_metadata on series_metadata.trial=trial.id and series_metadata.name = '" + string4 + '\'');
        }
        return stringBuffer.toString();
    }

    private static StringBuilder buildCreateTableStatement(String string, String string2, DB dB, boolean bl, boolean bl2) {
        TAUdbGeneralChartData.dropTable(dB, string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            stringBuilder.append("create global temporary table ");
        } else if (dB.getDBType().equalsIgnoreCase("derby") || dB.getDBType().equalsIgnoreCase("db2")) {
            stringBuilder.append("create table ");
        } else {
            stringBuilder.append("create temporary table ");
        }
        stringBuilder.append(string2 + " ");
        if (bl) {
            if (dB.getDBType().equalsIgnoreCase("derby")) {
                String[] stringArray = null;
                String[] stringArray2 = null;
                if (string.equalsIgnoreCase("trial")) {
                    Trial.getMetaData((DB)dB, (boolean)true);
                    stringArray = dB.getDatabase().getTrialFieldNames();
                    stringArray2 = dB.getDatabase().getTrialFieldTypeNames();
                    Trial.getMetaData((DB)dB, (boolean)false);
                } else if (string.equalsIgnoreCase("metric")) {
                    Metric.getMetaData((DB)dB);
                    stringArray = dB.getDatabase().getMetricFieldNames();
                    stringArray2 = dB.getDatabase().getMetricFieldTypeNames();
                } else if (string.equalsIgnoreCase("event")) {
                    if (bl2) {
                        AtomicEvent.getMetaData((DB)dB);
                        stringArray = dB.getDatabase().getAtomicEventFieldNames();
                        stringArray2 = dB.getDatabase().getAtomicEventFieldTypeNames();
                    } else {
                        IntervalEvent.getMetaData((DB)dB);
                        stringArray = dB.getDatabase().getIntervalEventFieldNames();
                        stringArray2 = dB.getDatabase().getIntervalEventFieldTypeNames();
                    }
                }
                stringBuilder.append(" (");
                for (int i = 0; i < Array.getLength(stringArray); ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(stringArray[i] + " " + stringArray2[i]);
                }
                stringBuilder.append(") ");
                try {
                    PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
                    preparedStatement.execute();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    System.err.println(stringBuilder.toString());
                    System.err.println(sQLException.getMessage());
                    sQLException.printStackTrace(System.err);
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append(" insert into " + string2 + " ");
            } else {
                stringBuilder.append("as ");
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getXMLFields(RMIPerfExplorerModel rMIPerfExplorerModel) {
        Object object;
        StringBuilder stringBuilder = null;
        Statement statement = null;
        HashSet<String> hashSet = new HashSet<String>();
        DB dB = null;
        try {
            Object object2;
            dB = PerfExplorerServer.getServer().getDB();
            Trial.getMetaData((DB)dB, (boolean)true);
            object = dB.getDatabase().getTrialFieldNames();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (object[i].equalsIgnoreCase("XML_METADATA")) {
                    bl = true;
                    continue;
                }
                if (!object[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                bl2 = true;
            }
            if (!bl) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            stringBuilder = TAUdbGeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true, false);
            stringBuilder.append("(select trial.* from trial ");
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append("inner join experiment ");
                stringBuilder.append("on trial.experiment = experiment.id ");
                stringBuilder.append("inner join application ");
                stringBuilder.append("on experiment.application = application.id ");
            }
            stringBuilder.append("where ");
            List<Object> list = rMIPerfExplorerModel.getMultiSelection();
            if (list == null) {
                Object object3 = rMIPerfExplorerModel.getCurrentSelection();
                if (object3 instanceof Application) {
                    stringBuilder.append("application.id = " + rMIPerfExplorerModel.getApplication().getID());
                } else if (object3 instanceof Experiment) {
                    stringBuilder.append("experiment.id = " + rMIPerfExplorerModel.getExperiment().getID());
                } else if (object3 instanceof Trial) {
                    stringBuilder.append("trial.id = " + rMIPerfExplorerModel.getTrial().getID());
                }
            } else {
                int n;
                int n2;
                boolean bl3 = false;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!(list.get(n2) instanceof Application)) continue;
                    Application application = (Application)list.get(n2);
                    if (!bl3) {
                        stringBuilder.append("application.id in (");
                        bl3 = true;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(application.getID());
                }
                if (bl3) {
                    stringBuilder.append(") ");
                }
                n2 = 0;
                for (n = 0; n < list.size(); ++n) {
                    if (!(list.get(n) instanceof Experiment)) continue;
                    Experiment experiment = (Experiment)list.get(n);
                    if (n2 == 0) {
                        if (bl3) {
                            stringBuilder.append(" and ");
                        }
                        stringBuilder.append("experiment.id in (");
                        n2 = 1;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(experiment.getID());
                }
                if (n2 != 0) {
                    stringBuilder.append(") ");
                }
                n = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof Trial)) continue;
                    object2 = (Trial)list.get(i);
                    if (n == 0) {
                        if (bl3 || n2 != 0) {
                            stringBuilder.append(" and ");
                        }
                        stringBuilder.append("trial.id in (");
                        n = 1;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(object2.getID());
                }
                if (n != 0) {
                    stringBuilder.append(") ");
                }
            }
            stringBuilder.append(") ");
            statement = dB.prepareStatement(stringBuilder.toString());
            statement.execute();
            statement.close();
            statement = null;
            statement = bl2 ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
            ResultSet resultSet = statement.executeQuery();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            while (resultSet.next()) {
                Node node;
                int n;
                String string = resultSet.getString(2);
                if (bl2 && (string == null || string.length() == 0)) {
                    object2 = resultSet.getBinaryStream(3);
                    string = Gzip.decompress((InputStream)object2);
                }
                object2 = new StringReader(string);
                InputSource inputSource = new InputSource((Reader)object2);
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = null;
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new TauNamespaceContext());
                nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n).getFirstChild();
                    hashSet.add(node.getNodeValue());
                }
                nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n).getFirstChild();
                    hashSet.add(node.getNodeValue());
                }
            }
            resultSet.close();
            statement.close();
            statement = null;
        }
        catch (Exception exception) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            TAUdbGeneralChartData.dropTable(dB, "temp_trial");
        }
        object = new ArrayList(hashSet);
        Collections.sort(object, String.CASE_INSENSITIVE_ORDER);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTable(DB dB, String string) {
        Statement statement = null;
        try {
            if (dB.getDBType().compareTo("oracle") == 0) {
                statement = dB.prepareStatement("truncate table " + string);
                statement.execute();
                statement.close();
            }
            statement = dB.prepareStatement("drop table " + string);
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

