/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyClass;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyMethod$im_self_descriptor;
import org.python.core.PyMethod$instancemethod___call___exposer;
import org.python.core.PyMethod$instancemethod___get___exposer;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="instancemethod", isBaseType=false)
public class PyMethod
extends PyObject {
    public static final PyType TYPE;
    public PyObject im_class;
    public PyObject im_func;
    public PyObject im_self;

    public PyMethod(PyObject function, PyObject self, PyObject type) {
        if (self == Py.None) {
            self = null;
        }
        this.im_func = function;
        this.im_self = self;
        this.im_class = type;
    }

    @ExposedNew
    static final PyObject instancemethod___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("instancemethod", args, keywords, "func");
        ap.noKeywords();
        PyObject func = ap.getPyObject(0);
        PyObject self = ap.getPyObject(1);
        PyObject classObj = ap.getPyObject(2, null);
        if (!func.isCallable()) {
            throw Py.TypeError("first argument must be callable");
        }
        if (self == Py.None && classObj == null) {
            throw Py.TypeError("unbound methods must have non-NULL im_class");
        }
        return new PyMethod(func, self, classObj);
    }

    public PyObject __findattr_ex__(String name) {
        return this.instancemethod___findattr_ex__(name);
    }

    final PyObject instancemethod___findattr_ex__(String name) {
        PyObject ret = super.__findattr_ex__(name);
        if (ret != null) {
            return ret;
        }
        return this.im_func.__findattr_ex__(name);
    }

    final PyObject instancemethod___getattribute__(PyObject arg0) {
        String name = PyMethod.asName(arg0);
        PyObject ret = this.instancemethod___findattr_ex__(name);
        if (ret == null) {
            this.noAttributeError(name);
        }
        return ret;
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        return this.instancemethod___get__(obj, type);
    }

    final PyObject instancemethod___get__(PyObject obj, PyObject type) {
        if (obj == null || this.im_self != null) {
            return this;
        }
        if (Py.isSubClass(obj.fastGetClass(), this.im_class)) {
            return new PyMethod(this.im_func, obj, this.im_class);
        }
        return this;
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.instancemethod___call__(args, keywords);
    }

    public PyObject __call__(ThreadState state, PyObject[] args, String[] keywords) {
        PyObject self = this.checkSelf(null, args);
        if (self == null) {
            return this.im_func.__call__(state, args, keywords);
        }
        return this.im_func.__call__(state, self, args, keywords);
    }

    final PyObject instancemethod___call__(PyObject[] args, String[] keywords) {
        return this.__call__(Py.getThreadState(), args, keywords);
    }

    private PyObject checkSelf(PyObject arg, PyObject[] args) {
        PyObject self = this.im_self;
        if (self == null) {
            if (arg != null) {
                self = arg;
            } else if (args != null && args.length >= 1) {
                self = args[0];
            }
            boolean ok = self == null ? false : Py.isInstance(self, this.im_class);
            if (!ok) {
                String msg = String.format("unbound method %s%s must be called with %s instance as first argument (got %s%s instead)", this.getFuncName(), "()", this.getClassName(this.im_class), this.getInstClassName(self), self == null ? "" : " instance");
                throw Py.TypeError(msg);
            }
            return null;
        }
        return self;
    }

    public int __cmp__(PyObject other) {
        return this.instancemethod___cmp__(other);
    }

    final int instancemethod___cmp__(PyObject other) {
        if (!(other instanceof PyMethod)) {
            return -2;
        }
        PyMethod otherMethod = (PyMethod)other;
        int cmp = this.im_func._cmp(otherMethod.im_func);
        if (cmp != 0) {
            return cmp;
        }
        if (this.im_self == otherMethod.im_self) {
            return 0;
        }
        if (this.im_self == null || otherMethod.im_self == null) {
            return System.identityHashCode(this.im_self) < System.identityHashCode(otherMethod.im_self) ? -1 : 1;
        }
        return this.im_self._cmp(otherMethod.im_self);
    }

    public int hashCode() {
        int hashCode = this.im_self == null ? Py.None.hashCode() : this.im_self.hashCode();
        return hashCode ^ this.im_func.hashCode();
    }

    public PyObject getDoc() {
        return this.im_func.getDoc();
    }

    public String toString() {
        String className = "?";
        if (this.im_class != null) {
            className = this.getClassName(this.im_class);
        }
        if (this.im_self == null) {
            return String.format("<unbound method %s.%s>", className, this.getFuncName());
        }
        return String.format("<bound method %s.%s of %s>", className, this.getFuncName(), this.im_self.__str__());
    }

    private String getClassName(PyObject cls) {
        if (cls instanceof PyClass) {
            return ((PyClass)cls).__name__;
        }
        if (cls instanceof PyType) {
            return ((PyType)cls).fastGetName();
        }
        return "?";
    }

    private String getInstClassName(PyObject inst) {
        if (inst == null) {
            return "nothing";
        }
        PyObject classObj = inst.__findattr__("__class__");
        if (classObj == null) {
            classObj = inst.getType();
        }
        return this.getClassName(classObj);
    }

    private String getFuncName() {
        PyObject funcName = null;
        try {
            funcName = this.im_func.__findattr__("__name__");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        if (funcName == null) {
            return "?";
        }
        return funcName.toString();
    }

    static {
        PyType.addBuilder(PyMethod.class, new PyMethod$PyExposer());
        TYPE = PyType.fromClass(PyMethod.class);
    }

    public class PyMethod$instancemethod___getattribute___exposer
    extends PyBuiltinMethodNarrow {
        public PyMethod$instancemethod___getattribute___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getattribute__('name') <==> x.name";
        }

        public PyMethod$instancemethod___getattribute___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getattribute__('name') <==> x.name";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMethod$instancemethod___getattribute___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyMethod)this.self).instancemethod___getattribute__(pyObject);
        }
    }

    public class PyMethod$instancemethod___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyMethod$instancemethod___cmp___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__cmp__(y) <==> cmp(x,y)";
        }

        public PyMethod$instancemethod___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__cmp__(y) <==> cmp(x,y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMethod$instancemethod___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyMethod)this.self).instancemethod___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("instancemethod.__cmp__(x,y) requires y to be 'instancemethod', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyMethod$im_func_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMethod$im_func_descriptor() {
            super("im_func", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMethod)pyObject).im_func;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMethod$im_class_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMethod$im_class_descriptor() {
            super("im_class", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMethod)pyObject).im_class;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMethod$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyMethod.instancemethod___new__(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyMethod$PyExposer
    extends BaseTypeBuilder {
        public PyMethod$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyMethod$instancemethod___getattribute___exposer("__getattribute__"), new PyMethod$instancemethod___get___exposer("__get__"), new PyMethod$instancemethod___call___exposer("__call__"), new PyMethod$instancemethod___cmp___exposer("__cmp__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyMethod$im_self_descriptor(), new PyMethod$im_func_descriptor(), new PyMethod$im_class_descriptor()};
            super("instancemethod", PyMethod.class, Object.class, false, pyBuiltinMethodArray, pyDataDescrArray, new PyMethod$exposed___new__());
        }
    }
}

