/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.FuncNode;
import com.graphbuilder.math.OpNode;
import com.graphbuilder.math.TermNode;
import com.graphbuilder.math.ValNode;
import com.graphbuilder.math.VarMap;
import com.graphbuilder.math.VarNode;
import com.graphbuilder.struc.Bag;

public abstract class Expression {
    protected Expression parent = null;

    public abstract double eval(VarMap var1, FuncMap var2);

    public boolean isDescendent(Expression expression) {
        Expression expression2 = this;
        while (expression2 != null) {
            if (expression2 == expression) {
                return true;
            }
            expression2 = expression2.parent;
        }
        return false;
    }

    public Expression getParent() {
        return this.parent;
    }

    protected void checkBeforeAccept(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        if (expression.parent != null) {
            throw new IllegalArgumentException("expression must be removed parent");
        }
        if (this.isDescendent(expression)) {
            throw new IllegalArgumentException("cyclic reference");
        }
    }

    public String[] getVariableNames() {
        return this.getTermNames(true);
    }

    public String[] getFunctionNames() {
        return this.getTermNames(false);
    }

    private String[] getTermNames(boolean bl) {
        Bag bag = new Bag();
        Expression.getTermNames(this, bag, bl);
        String[] stringArray = new String[bag.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)bag.get(i);
        }
        return stringArray;
    }

    private static void getTermNames(Expression expression, Bag bag, boolean bl) {
        block4: {
            block5: {
                block3: {
                    if (!(expression instanceof OpNode)) break block3;
                    OpNode opNode = (OpNode)expression;
                    Expression.getTermNames(opNode.leftChild, bag, bl);
                    Expression.getTermNames(opNode.rightChild, bag, bl);
                    break block4;
                }
                if (!(expression instanceof VarNode)) break block5;
                if (!bl) break block4;
                VarNode varNode = (VarNode)expression;
                if (bag.contains(varNode.name)) break block4;
                bag.add(varNode.name);
                break block4;
            }
            if (expression instanceof FuncNode) {
                FuncNode funcNode = (FuncNode)expression;
                if (!bl && !bag.contains(funcNode.name)) {
                    bag.add(funcNode.name);
                }
                for (int i = 0; i < funcNode.numChildren(); ++i) {
                    Expression.getTermNames(funcNode.child(i), bag, bl);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Expression.toString(this, stringBuffer);
        return stringBuffer.toString();
    }

    private static void toString(Expression expression, StringBuffer stringBuffer) {
        if (expression instanceof OpNode) {
            OpNode opNode = (OpNode)expression;
            stringBuffer.append("(");
            Expression.toString(opNode.leftChild, stringBuffer);
            stringBuffer.append(opNode.getSymbol());
            Expression.toString(opNode.rightChild, stringBuffer);
            stringBuffer.append(")");
        } else if (expression instanceof TermNode) {
            TermNode termNode = (TermNode)expression;
            if (termNode.getNegate()) {
                stringBuffer.append("(");
                stringBuffer.append("-");
            }
            stringBuffer.append(termNode.getName());
            if (termNode instanceof FuncNode) {
                FuncNode funcNode = (FuncNode)termNode;
                stringBuffer.append("(");
                if (funcNode.numChildren() > 0) {
                    Expression.toString(funcNode.child(0), stringBuffer);
                }
                for (int i = 1; i < funcNode.numChildren(); ++i) {
                    stringBuffer.append(", ");
                    Expression.toString(funcNode.child(i), stringBuffer);
                }
                stringBuffer.append(")");
            }
            if (termNode.getNegate()) {
                stringBuffer.append(")");
            }
        } else if (expression instanceof ValNode) {
            stringBuffer.append(((ValNode)expression).val);
        }
    }
}

