/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class AtomicEvent {
    private AtomicEvent() {
    }

    public static Map<Integer, UserEvent> getAtomicEvents(DatabaseAPI databaseAPI, DB dB, String string) {
        if (dB.getSchemaVersion() > 0) {
            return AtomicEvent.getTAUdbAtomicEvents(databaseAPI, dB, string);
        }
        HashMap<Integer, UserEvent> hashMap = new HashMap<Integer, UserEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select u.id, u.trial, u.name ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_event u inner join " + dB.getSchemaPrefix() + "trial t on u.trial = t.id ");
        stringBuffer.append("inner join " + dB.getSchemaPrefix() + "experiment e on t.experiment = e.id ");
        stringBuffer.append(string);
        stringBuffer.append(" order by u.id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string2 = resultSet.getString(3);
                UserEvent userEvent = databaseAPI.getTrial().getDataSource().addUserEvent(string2);
                hashMap.put(n, userEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashMap;
    }

    private static Map<Integer, UserEvent> getTAUdbAtomicEvents(DatabaseAPI databaseAPI, DB dB, String string) {
        HashMap<Integer, UserEvent> hashMap = new HashMap<Integer, UserEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select u.id, u.trial, u.name ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "counter u ");
        stringBuffer.append(string);
        stringBuffer.append(" order by u.id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string2 = resultSet.getString(3);
                UserEvent userEvent = databaseAPI.getTrial().getDataSource().addUserEvent(string2);
                hashMap.put(n, userEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashMap;
    }

    public static int saveAtomicEvent(DB dB, int n, UserEvent userEvent) {
        if (dB.getSchemaVersion() > 0) {
            return AtomicEvent.saveCounter(dB, n, userEvent);
        }
        int n2 = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "atomic_event (trial, name) VALUES (?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, userEvent.getName());
            preparedStatement.executeUpdate();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'atomic_event'" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "atomic_event_id_seq.currval FROM dual" : "select currval('atomic_event_id_seq');")))));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n2;
    }

    public static int saveCounter(DB dB, int n, UserEvent userEvent) {
        int n2 = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "counter (trial, name, parent) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, userEvent.getName());
            System.out.println("TODO! NEED TO SAVE COUNTER CONTEXT");
            preparedStatement.setNull(3, 4);
            preparedStatement.executeUpdate();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM counter" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'counter'" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM counter" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM counter" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "counter_id_seq.currval FROM dual" : "select currval('counter_id_seq');")))));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n2;
    }

    public static void getMetaData(DB dB) {
        try {
            String[] stringArray;
            Object object;
            int n;
            ResultSet resultSet = null;
            String string = "atomic_event";
            if (dB.getSchemaVersion() > 0) {
                string = "counter";
            }
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, string.toUpperCase(), "%") : databaseMetaData.getColumns(null, null, string.toLowerCase(), "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl = false;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            }
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                stringArray = resultSet.getString("TYPE_NAME");
                Integer n2 = new Integer(resultSet.getInt("COLUMN_SIZE"));
                if (((String)object).equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
                arrayList.add(stringArray);
                arrayList2.add(n2);
            }
            resultSet.close();
            String[] stringArray2 = new String[vector.size()];
            object = new int[vector2.size()];
            stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
                stringArray[i] = (Integer)arrayList2.get(i) > 255 ? (String)arrayList.get(i) + "(" + ((Integer)arrayList2.get(i)).toString() + ")" : (String)arrayList.get(i);
            }
            dB.getDatabase().setAtomicEventFieldNames(stringArray2);
            dB.getDatabase().setAtomicEventFieldTypeNames(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

