/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.AtomicLocationProfile;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.TAUdbExperiment;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class DatabaseAPI {
    protected Application application = null;
    protected Experiment experiment = null;
    protected Trial trial = null;
    protected List<Integer> nodes = null;
    protected List<Integer> contexts = null;
    protected List<Integer> threads = null;
    protected List<Function> intervalEvents = null;
    protected List<UserEvent> atomicEvents = null;
    protected List<Metric> metrics = null;
    protected Map<Integer, Application> applications = null;
    protected Map<Integer, Experiment> experiments = null;
    protected Map<Integer, Trial> trials = null;
    protected Vector<IntervalLocationProfile> intervalEventData = null;
    protected Vector<UserEventProfile> atomicEventData = null;
    protected DB db = null;
    protected ConnectionManager connector;
    protected Map<Integer, Function> intervalEventHash = null;
    protected Map<Integer, UserEvent> atomicEventHash = null;
    protected boolean experimentChanged = true;
    protected boolean cancelUpload = false;
    protected Database database;
    protected int totalItems;
    private int itemsDone;

    public void cancelUpload() {
        this.cancelUpload = true;
    }

    public void copy(DatabaseAPI databaseAPI) {
        databaseAPI.database = this.database;
        databaseAPI.connector = this.connector;
        databaseAPI.db = this.connector.getDB();
        databaseAPI.application = this.application;
        databaseAPI.experiment = this.experiment;
        databaseAPI.trial = this.trial;
        databaseAPI.nodes = this.nodes;
        databaseAPI.contexts = this.contexts;
        databaseAPI.threads = this.threads;
        databaseAPI.intervalEvents = this.intervalEvents;
        databaseAPI.atomicEvents = this.atomicEvents;
        databaseAPI.metrics = this.metrics;
        databaseAPI.applications = this.applications;
        databaseAPI.experiments = this.experiments;
        databaseAPI.trials = this.trials;
        databaseAPI.intervalEventData = this.intervalEventData;
        databaseAPI.atomicEventData = this.atomicEventData;
        databaseAPI.intervalEventHash = this.intervalEventHash;
        databaseAPI.atomicEventHash = this.atomicEventHash;
        databaseAPI.cancelUpload = this.cancelUpload;
    }

    public String getMetricName(int n) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null && n < this.metrics.size()) {
            return this.metrics.get(n).getName();
        }
        return null;
    }

    public void setApplication(Application application) {
        this.experiments = null;
        this.trials = null;
        this.application = application;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
        this.experimentChanged = true;
    }

    public DB db() {
        return this.db;
    }

    public void setDB(DB dB) {
        this.db = dB;
    }

    public void initialize(String string, boolean bl) throws SQLException {
        if (string.startsWith("http") || new File(string).exists()) {
            this.initialize(new Database(string), bl);
        } else {
            System.err.println("Could not find file: " + string);
        }
    }

    public void initialize(String string, boolean bl, String string2) throws SQLException {
        if (string.startsWith("http") || new File(string).exists()) {
            this.initialize(new Database(string2, string), bl);
        } else {
            System.err.println("Could not find file: " + string);
        }
    }

    public void initialize(Database database, boolean bl) throws SQLException {
        this.database = database;
        this.connector = new ConnectionManager(database, bl);
        this.connector.connect();
        this.db = this.connector.getDB();
        if (this.db.getSchemaVersion() == 0) {
            Application.getMetaData(this.db);
            Experiment.getMetaData(this.db);
        }
        Trial.getMetaData(this.db);
    }

    public void initialize(Database database, String string) throws SQLException {
        this.database = database;
        this.connector = new ConnectionManager(database, string);
        this.connector.connect();
        this.db = this.connector.getDB();
        if (this.db.getSchemaVersion() == 0) {
            Application.getMetaData(this.db);
            Experiment.getMetaData(this.db);
        }
        Trial.getMetaData(this.db);
    }

    public void initialize(Database database) throws SQLException {
        this.database = database;
        this.connector = new ConnectionManager(database);
        this.connector.connect();
        this.db = this.connector.getDB();
        if (this.db.getSchemaVersion() == 0) {
            Application.getMetaData(this.db);
            Experiment.getMetaData(this.db);
        }
        Trial.getMetaData(this.db);
    }

    public void terminate() {
        this.connector.dbclose();
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public List<Application> getApplicationList() throws DatabaseException {
        String string = "";
        if (this.applications == null) {
            this.applications = new HashMap<Integer, Application>();
            Vector<Application> vector = Application.getApplicationList(this.db, string);
            for (Application application : vector) {
                this.applications.put(application.getID(), application);
            }
        }
        return new ArrayList<Application>(this.applications.values());
    }

    public List<Experiment> getExperimentList() throws DatabaseException {
        if (this.experiments == null) {
            Vector<Experiment> vector;
            Object object;
            if (this.db.getSchemaVersion() > 0) {
                object = "";
                if (this.application != null) {
                    object = this.application.getName();
                }
                vector = TAUdbExperiment.getExperimentList((String)object, this.db);
            } else {
                object = "";
                if (this.application != null) {
                    object = "WHERE application = " + this.application.getID();
                }
                vector = Experiment.getExperimentList(this.db, (String)object);
            }
            this.experiments = new HashMap<Integer, Experiment>();
            for (Experiment experiment : vector) {
                this.experiments.put(experiment.getID(), experiment);
            }
        }
        return new ArrayList<Experiment>(this.experiments.values());
    }

    public List<Trial> getTrialList(boolean bl) {
        if (this.trials == null || this.experimentChanged) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.experiment != null) {
                stringBuffer.append("WHERE t.experiment = " + this.experiment.getID());
            } else if (this.application != null) {
                stringBuffer.append("WHERE e.application = " + this.application.getID());
            }
            this.trials = new HashMap<Integer, Trial>();
            Vector<Trial> vector = Trial.getTrialList(this.db, stringBuffer.toString(), bl);
            for (Trial trial : vector) {
                this.trials.put(trial.getID(), trial);
            }
        }
        return new ArrayList<Trial>(this.trials.values());
    }

    public Application setApplication(int n) {
        this.application = null;
        this.experiment = null;
        this.experiments = null;
        this.trial = null;
        this.experiments = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        if (this.applications == null) {
            this.getApplicationList();
        }
        this.application = this.applications.get(n);
        return this.application;
    }

    public Application setApplication(String string, String string2) {
        Vector<Application> vector;
        this.application = null;
        this.experiment = null;
        this.experiments = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE name = '" + string + "'");
        if (string2 != null) {
            stringBuffer.append(" AND version = " + string2);
        }
        if ((vector = Application.getApplicationList(this.db, stringBuffer.toString())).size() == 1) {
            this.application = vector.elementAt(0);
            return this.application;
        }
        return null;
    }

    public Experiment setExperiment(int n) throws DatabaseException {
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        if (this.db.getSchemaVersion() > 0) {
            if (this.experiments == null) {
                this.getExperimentList();
            }
            this.experiment = this.experiments.get(n);
            return this.experiment;
        }
        String string = " WHERE id = " + n;
        Vector<Experiment> vector = Experiment.getExperimentList(this.db, string);
        if (vector.size() == 1) {
            this.experiment = vector.elementAt(0);
            this.experimentChanged = true;
            return this.experiment;
        }
        return null;
    }

    public Trial setTrial(int n, boolean bl) {
        return this.setTrial(n, true, bl);
    }

    private Trial setTrial(int n, boolean bl, boolean bl2) {
        this.trial = null;
        this.metrics = null;
        if (bl) {
            this.intervalEventHash = null;
            this.atomicEventHash = null;
        }
        if (this.trials == null) {
            String string = " WHERE t.id = " + n;
            Vector<Trial> vector = Trial.getTrialList(this.db, string, bl2);
            this.trial = vector.elementAt(0);
        } else {
            this.trial = this.trials.get(n);
        }
        return this.trial;
    }

    public Trial setTrial(String string, boolean bl) {
        return this.setTrial(string, true, bl);
    }

    private Trial setTrial(String string, boolean bl, boolean bl2) {
        String string2;
        Vector<Trial> vector;
        this.trial = null;
        this.metrics = null;
        if (bl) {
            this.intervalEventHash = null;
            this.atomicEventHash = null;
        }
        if ((vector = Trial.getTrialList(this.db, string2 = " WHERE t.name = '" + string + "'", bl2)).size() == 1) {
            this.trial = vector.elementAt(0);
        }
        return this.trial;
    }

    public Map<Integer, Function> getIntervalEvents(DataSource dataSource, int n) {
        String string = new String();
        if (this.db.getSchemaVersion() > 0) {
            if (this.trial != null) {
                string = " WHERE trial = " + this.trial.getID();
            } else if (this.experiment != null) {
                System.err.println("Need to query meta-data for experiment");
            } else if (this.application != null) {
                System.err.println("Need to query meta-data for application");
            }
        } else if (this.trial != null) {
            string = " WHERE trial = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE application = " + this.application.getID();
        }
        this.intervalEventHash = IntervalEvent.getIntervalEvents(this, this.db, string, dataSource, n);
        this.intervalEvents = new ArrayList<Function>(this.intervalEventHash.values());
        return this.intervalEventHash;
    }

    public Map<Integer, UserEvent> getAtomicEvents() {
        if (this.atomicEventHash == null) {
            String string = new String();
            if (this.trial != null) {
                string = " WHERE u.trial = " + this.trial.getID();
            } else if (this.experiment != null) {
                string = " WHERE t.experiment = " + this.experiment.getID();
            } else if (this.application != null) {
                string = " WHERE e.application = " + this.application.getID();
            }
            this.atomicEventHash = AtomicEvent.getAtomicEvents(this, this.db, string);
        }
        return this.atomicEventHash;
    }

    public void clearIntervalEvents() {
        this.intervalEvents = null;
    }

    public void setNode(int n) {
        Integer n2 = new Integer(n);
        this.nodes = new ArrayList<Integer>();
        this.nodes.add(n2);
    }

    public void setContext(int n) {
        Integer n2 = new Integer(n);
        this.contexts = new ArrayList<Integer>();
        this.contexts.add(n2);
    }

    public void setThread(int n) {
        Integer n2 = new Integer(n);
        this.threads = new ArrayList<Integer>();
        this.threads.add(n2);
    }

    public List<UserEventProfile> getAtomicEventData(DataSource dataSource) {
        Comparable<Integer> comparable;
        if (this.trial == null) {
            System.out.println("Please select a trial before getting user event data.");
            return null;
        }
        if (this.atomicEventHash == null) {
            this.getAtomicEvents();
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND e.id IN (");
            } else {
                stringBuffer.append(" WHERE e.id IN (");
            }
            for (int i = 0; i < this.atomicEvents.size(); ++i) {
                comparable = this.atomicEvents.get(i);
                stringBuffer.append(((UserEvent)comparable).getID());
                if (i + 1 < this.atomicEvents.size()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            Iterator<Integer> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                comparable = iterator.next();
                stringBuffer.append(comparable);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            Iterator<Integer> iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                comparable = iterator.next();
                stringBuffer.append(comparable);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            Iterator<Integer> iterator = this.threads.iterator();
            while (iterator.hasNext()) {
                comparable = iterator.next();
                stringBuffer.append(comparable);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.atomicEventData = AtomicLocationProfile.getAtomicEventData(this.db, stringBuffer.toString(), dataSource, this.atomicEventHash);
        return this.atomicEventData;
    }

    public int saveApplication(Application application) {
        try {
            return application.saveApplication(this.db);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving application", sQLException);
        }
    }

    public int saveExperiment(Experiment experiment) throws DatabaseException {
        try {
            return experiment.saveExperiment(this.db);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving experiment", sQLException);
        }
    }

    public int saveTrial() {
        int n = this.trial.saveTrial(this.db);
        return n;
    }

    private int saveMetric(int n, Metric metric) throws SQLException {
        int n2 = 0;
        PreparedStatement preparedStatement = null;
        preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "metric (name, trial) VALUES (?, ?)");
        preparedStatement.setString(1, metric.getName());
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        String string = new String();
        string = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'metric'" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "metric_id_seq.currval FROM dual" : "select currval('metric_id_seq');")))));
        n2 = Integer.parseInt(this.db.getDataItem(string));
        return n2;
    }

    protected Hashtable<Integer, Integer> saveMetrics(int n, Trial trial, int n2) throws SQLException {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        int n3 = 0;
        for (Metric metric : trial.getDataSource().getMetrics()) {
            int n4 = -1;
            if (n2 < 0 || n2 == n3) {
                n4 = this.saveMetric(n, metric);
            }
            hashtable.put(new Integer(n3), new Integer(n4));
            ++n3;
        }
        return hashtable;
    }

    private Hashtable<Integer, Integer> saveIntervalEvents(int n, Hashtable<Integer, Integer> hashtable, int n2) throws SQLException {
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        for (Function function : this.intervalEvents) {
            int n3 = IntervalEvent.saveIntervalEvent(this.db, n, function, hashtable, n2);
            hashtable2.put(new Integer(function.getID()), new Integer(n3));
        }
        return hashtable2;
    }

    private Hashtable<Integer, Integer> saveAtomicEvents(int n) {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        for (UserEvent userEvent : this.atomicEvents) {
            int n2 = AtomicEvent.saveAtomicEvent(this.db, n, userEvent);
            hashtable.put(new Integer(userEvent.getID()), new Integer(n2));
        }
        return hashtable;
    }

    private void saveAtomicEventData(Hashtable<Integer, Integer> hashtable, List<Thread> list) {
        AtomicLocationProfile.saveAtomicEventData(this.db, hashtable, list);
    }

    public int saveTrial(Trial trial) {
        return trial.saveTrial(this.db);
    }

    public int getProgress() {
        if (this.totalItems != 0) {
            return (int)((float)this.itemsDone / (float)this.totalItems * 100.0f);
        }
        return 0;
    }

    public synchronized int saveTrial(Trial trial, Metric metric) throws DatabaseException {
        Hashtable<Integer, Integer> hashtable;
        Hashtable<Integer, Integer> hashtable2;
        Group group;
        DataSource dataSource = trial.getDataSource();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Group> iterator = dataSource.getGroups();
        while (iterator.hasNext()) {
            group = iterator.next();
            arrayList.add(group.getName());
        }
        this.metrics = trial.getDataSource().getMetrics();
        int n = this.metrics.size();
        this.intervalEvents = new ArrayList<Function>();
        this.intervalEventData = new Vector();
        this.atomicEvents = new ArrayList<UserEvent>();
        this.atomicEventData = new Vector();
        group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        this.intervalEvents = dataSource.getFunctions();
        this.atomicEvents = dataSource.getUserEvents();
        for (Thread thread : trial.getDataSource().getAllThreads()) {
            hashtable2 = thread.getFunctionProfiles();
            hashtable = hashtable2.iterator();
            while (hashtable.hasNext()) {
                FunctionProfile functionProfile = hashtable.next();
                if (functionProfile == null || functionProfile.getFunction().isGroupMember(group)) continue;
                IntervalLocationProfile intervalLocationProfile = new IntervalLocationProfile(n);
                intervalLocationProfile.setNode(thread.getNodeID());
                intervalLocationProfile.setContext(thread.getContextID());
                intervalLocationProfile.setThread(thread.getThreadID());
                intervalLocationProfile.setIntervalEventID(functionProfile.getFunction().getID());
                intervalLocationProfile.setNumCalls(functionProfile.getNumCalls());
                intervalLocationProfile.setNumSubroutines(functionProfile.getNumSubr());
                for (int i = 0; i < n; ++i) {
                    intervalLocationProfile.setInclusive(i, functionProfile.getInclusive(i));
                    intervalLocationProfile.setExclusive(i, functionProfile.getExclusive(i));
                    intervalLocationProfile.setInclusivePercentage(i, functionProfile.getInclusivePercent(i));
                    intervalLocationProfile.setExclusivePercentage(i, functionProfile.getExclusivePercent(i));
                    intervalLocationProfile.setInclusivePerCall(i, functionProfile.getInclusivePerCall(i));
                }
                this.intervalEventData.add(intervalLocationProfile);
            }
            hashtable = thread.getUserEventProfiles();
            while (hashtable.hasNext()) {
                UserEventProfile userEventProfile = (UserEventProfile)hashtable.next();
                if (userEventProfile == null) continue;
                this.atomicEventData.add(userEventProfile);
            }
        }
        this.totalItems = this.intervalEvents.size() + this.intervalEventData.size() + this.atomicEvents.size() + this.atomicEventData.size();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n2 = 0;
        int n3 = -1;
        if (metric != null) {
            n3 = metric.getID();
        }
        try {
            hashtable2 = null;
            if (metric == null) {
                n2 = trial.saveTrial(this.db);
                trial.setID(n2);
                hashtable2 = this.saveMetrics(n2, trial, n3);
                if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                    hashtable = this.saveIntervalEvents(n2, hashtable2, n3);
                    this.saveIntervalLocationProfiles(this.db, hashtable, this.intervalEventData.elements(), hashtable2, n3);
                }
                if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
                    hashtable = this.saveAtomicEvents(n2);
                    if (this.atomicEventData != null && this.atomicEventData.size() > 0) {
                        this.saveAtomicEventData(hashtable, trial.getDataSource().getAllThreads());
                    }
                }
            } else {
                n2 = trial.getID();
                hashtable2 = this.saveMetrics(n2, trial, n3);
                if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                    hashtable = this.saveIntervalEvents(n2, hashtable2, n3);
                    this.saveIntervalLocationProfiles(this.db, hashtable, this.intervalEventData.elements(), hashtable2, n3);
                }
            }
            for (Integer n4 : hashtable2.keySet()) {
                int n5 = hashtable2.get(n4);
                for (Metric metric2 : trial.getDataSource().getMetrics()) {
                    if (metric2.getID() != n4.intValue() || n5 == -1) continue;
                    metric2.setDbMetricID(n5);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                sQLException.printStackTrace();
                throw new DatabaseException("Saving Trial Failed, rollbacks successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollbacks failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        return n2;
    }

    private Map<Metric, Integer> uploadMetrics(int n, DataSource dataSource) throws SQLException {
        HashMap<Metric, Integer> hashMap = new HashMap<Metric, Integer>();
        for (Metric metric : dataSource.getMetrics()) {
            PreparedStatement preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "metric (name, trial) VALUES (?, ?)");
            preparedStatement.setString(1, metric.getName());
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'metric'" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "metric_id_seq.currval FROM dual" : "select currval('metric_id_seq');")))));
            int n2 = Integer.parseInt(this.db.getDataItem(string));
            hashMap.put(metric, new Integer(n2));
        }
        return hashMap;
    }

    private Map<Function, Integer> uploadFunctions(int n, DataSource dataSource) throws SQLException {
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        Iterator<Function> iterator = dataSource.getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (function.isGroupMember(group)) continue;
            String string = null;
            List<Group> list = function.getGroups();
            StringBuffer stringBuffer = new StringBuffer();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(list.get(i).getName());
                }
                if (list.size() > 0) {
                    string = stringBuffer.toString();
                }
            }
            PreparedStatement preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string2 = new String();
            string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (this.db.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'interval_event'" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (this.db.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');")))));
            int n2 = Integer.parseInt(this.db.getDataItem(string2));
            hashMap.put(function, new Integer(n2));
            ++this.itemsDone;
        }
        return hashMap;
    }

    private Map<UserEvent, Integer> uploadUserEvents(int n, DataSource dataSource) throws SQLException {
        HashMap<UserEvent, Integer> hashMap = new HashMap<UserEvent, Integer>();
        String string = null;
        Iterator<UserEvent> iterator = dataSource.getUserEventIterator();
        while (iterator.hasNext()) {
            UserEvent userEvent = iterator.next();
            PreparedStatement preparedStatement = null;
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "atomic_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, userEvent.getName());
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string2 = new String();
            string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (this.db.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'atomic_event'" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (this.db.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "atomic_event_id_seq.currval FROM dual" : "select currval('atomic_event_id_seq');")))));
            int n2 = Integer.parseInt(this.db.getDataItem(string2));
            hashMap.put(userEvent, new Integer(n2));
            ++this.itemsDone;
        }
        return hashMap;
    }

    private void addBatchFunctionProfile(PreparedStatement preparedStatement, Thread thread, int n, int n2, FunctionProfile functionProfile, int n3, boolean bl, int n4) throws SQLException {
        preparedStatement.setInt(1, n3);
        preparedStatement.setInt(2, n2);
        preparedStatement.setDouble(3, functionProfile.getInclusivePercent(n));
        if (bl) {
            preparedStatement.setDouble(4, functionProfile.getInclusive(n) / (double)n4);
            preparedStatement.setDouble(5, functionProfile.getExclusivePercent(n));
            preparedStatement.setDouble(6, functionProfile.getExclusive(n) / (double)n4);
            preparedStatement.setDouble(7, functionProfile.getNumCalls() / (double)n4);
            preparedStatement.setDouble(8, functionProfile.getNumSubr() / (double)n4);
            preparedStatement.setDouble(9, functionProfile.getInclusivePerCall(n));
        } else {
            preparedStatement.setDouble(4, functionProfile.getInclusive(n));
            preparedStatement.setDouble(5, functionProfile.getExclusivePercent(n));
            preparedStatement.setDouble(6, functionProfile.getExclusive(n));
            preparedStatement.setDouble(7, functionProfile.getNumCalls());
            preparedStatement.setDouble(8, functionProfile.getNumSubr());
            preparedStatement.setDouble(9, functionProfile.getInclusivePerCall(n));
        }
        if (thread.getNodeID() >= 0) {
            preparedStatement.setInt(10, thread.getNodeID());
            preparedStatement.setInt(11, thread.getContextID());
            preparedStatement.setInt(12, thread.getThreadID());
        }
        ++this.itemsDone;
        preparedStatement.executeUpdate();
    }

    private void uploadFunctionProfiles(int n, DataSource dataSource, Map<Function, Integer> map, Map<Metric, Integer> map2, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        if (this.db.getDBType().compareTo("oracle") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else if (this.db.getDBType().compareTo("derby") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else if (this.db.getDBType().compareTo("mysql") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        for (Metric metric : dataSource.getMetrics()) {
            Integer n2 = map2.get(metric);
            Iterator<Function> iterator = dataSource.getFunctionIterator();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (function.isGroupMember(group)) continue;
                Integer n3 = map.get(function);
                Thread thread = dataSource.getTotalData();
                this.addBatchFunctionProfile(preparedStatement, thread, metric.getID(), n2, function.getTotalProfile(), n3, false, dataSource.getAllThreads().size());
                Thread thread2 = dataSource.getMeanData();
                this.addBatchFunctionProfile(preparedStatement2, thread2, metric.getID(), n2, function.getMeanProfile(), n3, false, dataSource.getAllThreads().size());
                if (bl) {
                    System.out.println("Only doing summary!");
                }
                Iterator<Thread> iterator2 = dataSource.getAllThreads().iterator();
                while (iterator2.hasNext() && !bl) {
                    Thread thread3 = iterator2.next();
                    FunctionProfile functionProfile = thread3.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    if (this.cancelUpload) {
                        return;
                    }
                    this.addBatchFunctionProfile(preparedStatement3, thread3, metric.getID(), n2, functionProfile, n3, false, dataSource.getAllThreads().size());
                }
            }
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    private void uploadUserEventProfiles(int n, DataSource dataSource, Map<UserEvent, Integer> map) throws SQLException {
        Iterator<Node> iterator = dataSource.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = iterator3.next();
                    Iterator<UserEventProfile> iterator4 = thread.getUserEventProfiles();
                    while (iterator4.hasNext()) {
                        UserEventProfile userEventProfile = iterator4.next();
                        if (this.cancelUpload) {
                            return;
                        }
                        if (userEventProfile == null) continue;
                        int n2 = map.get(userEventProfile.getUserEvent());
                        PreparedStatement preparedStatement = null;
                        preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "atomic_location_profile (atomic_event, node, context, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        preparedStatement.setInt(1, n2);
                        preparedStatement.setInt(2, thread.getNodeID());
                        preparedStatement.setInt(3, thread.getContextID());
                        preparedStatement.setInt(4, thread.getThreadID());
                        preparedStatement.setInt(5, (int)userEventProfile.getNumSamples());
                        preparedStatement.setDouble(6, userEventProfile.getMaxValue());
                        preparedStatement.setDouble(7, userEventProfile.getMinValue());
                        preparedStatement.setDouble(8, userEventProfile.getMeanValue());
                        preparedStatement.setDouble(9, userEventProfile.getSumSquared());
                        preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                }
            }
        }
    }

    private void computeUploadSize(DataSource dataSource) {
        this.totalItems = 0;
        Iterator<Function> iterator = dataSource.getFunctionIterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++this.totalItems;
        }
        int n = dataSource.getMetrics().size();
        Iterator<Function> iterator2 = dataSource.getFunctionIterator();
        while (iterator2.hasNext()) {
            Function function = iterator2.next();
            this.totalItems += n;
            this.totalItems += n;
            for (Thread thread : dataSource.getAllThreads()) {
                FunctionProfile functionProfile = thread.getFunctionProfile(function);
                if (functionProfile == null) continue;
                this.totalItems += n;
            }
        }
    }

    public synchronized int uploadTrial(Trial trial) throws DatabaseException {
        return this.uploadTrial(trial, false);
    }

    public synchronized int uploadTrial(Trial trial, boolean bl) throws DatabaseException {
        if (this.db.getSchemaVersion() > 0) {
            return TAUdbDatabaseAPI.uploadTrial(this.db, trial, bl);
        }
        DataSource dataSource = trial.getDataSource();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n = -1;
        try {
            n = trial.saveTrial(this.db);
            trial.setID(n);
            this.computeUploadSize(dataSource);
            Map<Metric, Integer> map = this.uploadMetrics(n, dataSource);
            for (Metric object2 : map.keySet()) {
                int n2 = map.get(object2);
                object2.setDbMetricID(n2);
            }
            Map<Function, Integer> map2 = this.uploadFunctions(n, dataSource);
            this.uploadFunctionProfiles(n, dataSource, map2, map, bl);
            Map<UserEvent, Integer> map3 = this.uploadUserEvents(n, dataSource);
            this.uploadUserEventProfiles(n, dataSource, map3);
            if (this.cancelUpload) {
                this.db.rollback();
                this.deleteTrial(n);
                return -1;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                sQLException.printStackTrace();
                throw new DatabaseException("Saving Trial Failed, rollbacks successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollbacks failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        return n;
    }

    public int saveApplication() {
        int n = 0;
        try {
            if (this.application != null) {
                n = this.application.saveApplication(this.db);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            throw new DatabaseException("Error saving application", sQLException);
        }
        return n;
    }

    public int saveExperiment() {
        int n = 0;
        try {
            if (this.experiment != null) {
                n = this.experiment.saveExperiment(this.db);
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving experiment", sQLException);
        }
        return n;
    }

    public void deleteTrial(int[] nArray) throws SQLException {
        if (this.db.getSchemaVersion() <= 0) {
            for (int i = 0; i < nArray.length; ++i) {
                Trial.deleteTrial(this.db, nArray[i]);
            }
            return;
        }
        TAUdbTrial.deleteTrial(this.db, nArray);
    }

    public void deleteTrial(int n) throws SQLException {
        int[] nArray = new int[]{n};
        Trial.deleteTrial(this.db, nArray[0]);
    }

    public void deleteExperiment(int n) throws DatabaseException, SQLException {
        DatabaseAPI databaseAPI = null;
        databaseAPI = this.db().getSchemaVersion() > 0 ? new TAUdbDatabaseAPI() : new DatabaseAPI();
        databaseAPI.setDB(this.db());
        databaseAPI.setExperiment(n);
        ListIterator<Trial> listIterator = databaseAPI.getTrialList(false).listIterator();
        while (listIterator.hasNext()) {
            Trial trial = listIterator.next();
            Trial.deleteTrial(this.db, trial.getID());
        }
        Experiment.deleteExperiment(this.db, n);
    }

    public void deleteApplication(int n) throws DatabaseException, SQLException {
        DatabaseAPI databaseAPI = null;
        databaseAPI = this.db().getSchemaVersion() > 0 ? new TAUdbDatabaseAPI() : new DatabaseAPI();
        databaseAPI.setDB(this.db());
        databaseAPI.setApplication(n);
        ListIterator<Experiment> listIterator = databaseAPI.getExperimentList().listIterator();
        while (listIterator.hasNext()) {
            Experiment experiment = listIterator.next();
            databaseAPI.setExperiment(experiment.getID());
            ListIterator<Trial> listIterator2 = databaseAPI.getTrialList(false).listIterator();
            while (listIterator2.hasNext()) {
                Trial trial = listIterator2.next();
                Trial.deleteTrial(this.db, trial.getID());
            }
            Experiment.deleteExperiment(this.db, experiment.getID());
        }
        Application.deleteApplication(this.db, n);
    }

    public int getNumberOfMetrics() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id, name ");
        stringBuffer.append("FROM " + this.db.getSchemaPrefix() + "metric ");
        stringBuffer.append("WHERE trial = ");
        stringBuffer.append(this.trial.getID());
        stringBuffer.append(" ORDER BY id ");
        try {
            ResultSet resultSet = this.db.executeQuery(stringBuffer.toString());
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            resultSet.close();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public void saveIntervalLocationProfiles(DB dB, Hashtable<Integer, Integer> hashtable, Enumeration<IntervalLocationProfile> enumeration, Hashtable<Integer, Integer> hashtable2, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)")));
        int n2 = 0;
        Integer n3 = null;
        while (enumeration.hasMoreElements()) {
            IntervalLocationProfile intervalLocationProfile = enumeration.nextElement();
            Integer n4 = hashtable.get(new Integer(intervalLocationProfile.getIntervalEventID()));
            n2 = 0;
            n3 = hashtable2.get(new Integer(n2));
            while (n3 != null) {
                if (n < 0 || n2 == n) {
                    preparedStatement.setInt(1, n4);
                    preparedStatement.setInt(2, intervalLocationProfile.getNode());
                    preparedStatement.setInt(3, intervalLocationProfile.getContext());
                    preparedStatement.setInt(4, intervalLocationProfile.getThread());
                    preparedStatement.setInt(5, n3);
                    preparedStatement.setDouble(6, intervalLocationProfile.getInclusivePercentage(n2));
                    preparedStatement.setDouble(7, intervalLocationProfile.getInclusive(n2));
                    preparedStatement.setDouble(8, intervalLocationProfile.getExclusivePercentage(n2));
                    preparedStatement.setDouble(9, intervalLocationProfile.getExclusive(n2));
                    preparedStatement.setDouble(10, intervalLocationProfile.getNumCalls());
                    preparedStatement.setDouble(11, intervalLocationProfile.getNumSubroutines());
                    preparedStatement.setDouble(12, intervalLocationProfile.getInclusivePerCall(n2));
                    preparedStatement.executeUpdate();
                }
                n3 = hashtable2.get(new Integer(++n2));
            }
        }
        preparedStatement.close();
    }

    public Application getApplication(String string, boolean bl) {
        List<Application> list = this.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            return application;
        }
        if (bl) {
            Application application = new Application();
            application.setDatabase(this.database);
            application.setName(string);
            this.setApplication(application);
            int n = this.saveApplication();
            application.setID(n);
            return application;
        }
        return null;
    }

    public Experiment getExperiment(Application application, String string, boolean bl) {
        this.setApplication(application);
        List<Experiment> list = this.getExperimentList();
        for (Experiment experiment : list) {
            if (!experiment.getName().equals(string)) continue;
            return experiment;
        }
        if (bl) {
            Experiment experiment = new Experiment();
            experiment.setName(string);
            experiment.setApplicationID(application.getID());
            experiment.setDatabase(this.database);
            this.setExperiment(experiment);
            int n = this.saveExperiment();
            experiment.setID(n);
            return experiment;
        }
        return null;
    }

    public Trial getTrial(Application application, Experiment experiment, String string) {
        this.setApplication(application);
        List<Experiment> list = this.getExperimentList();
        for (Experiment experiment2 : list) {
            if (!experiment2.getName().equals(string)) continue;
            this.setExperiment(experiment2);
            List<Trial> list2 = this.getTrialList(false);
            for (Trial trial : list2) {
                if (!experiment.getName().equals(string)) continue;
                return trial;
            }
        }
        return null;
    }

    public Experiment getExperiment(String string, String string2, boolean bl) {
        Application application = this.getApplication(string, bl);
        if (application == null) {
            return null;
        }
        return this.getExperiment(application, string2, bl);
    }

    public DB getDb() {
        return this.db;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public FunctionProfile getIntervalEventDetail(Function function) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE ms.interval_event = " + function.getID());
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND ms.metric in (");
            Iterator<Metric> iterator = this.metrics.iterator();
            while (iterator.hasNext()) {
                Metric metric = iterator.next();
                stringBuffer.append(metric.getID());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        return IntervalLocationProfile.getIntervalEventDetail(this.db, function, stringBuffer.toString());
    }
}

