/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FunctionProfile {
    private static final int METRIC_SIZE = 2;
    private static final int CALLS = 0;
    private static final int SUBR = 1;
    private static final int INCLUSIVE = 2;
    private static final int EXCLUSIVE = 3;
    private Function function;
    private Thread thread;
    private double[] data;
    private CallPathData callPathData;

    public FunctionProfile(Function function) {
        this(function, 1);
    }

    public FunctionProfile(Function function, int n) {
        this(function, n, 1);
    }

    public FunctionProfile(Function function, int n, int n2) {
        n = Math.max(n, 1);
        this.data = new double[((n + 1) * 2 + 2) * n2];
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public String getName() {
        return this.function.getName();
    }

    public void setInclusive(int n, double d) {
        this.putDouble(n, 2, d);
    }

    public void setInclusive(int n, int n2, double d) {
        this.putDouble(n, n2, 2, d);
    }

    public double getInclusive(int n) {
        return this.getDouble(n, 2);
    }

    public double getInclusive(int n, int n2) {
        return this.getDouble(n, n2, 2);
    }

    public void setExclusive(int n, double d) {
        this.putDouble(n, 3, d);
    }

    public void setExclusive(int n, int n2, double d) {
        this.putDouble(n, n2, 3, d);
    }

    public double getExclusive(int n, int n2) {
        return this.getDouble(n, n2, 3);
    }

    public double getExclusive(int n) {
        double d = this.getDouble(n, 3);
        return d;
    }

    public double getInclusivePercent(int n, int n2) {
        if (n == -1) {
            n = this.thread.getNumSnapshots() - 1;
        }
        if (this.thread.getNodeID() >= 0) {
            double d = this.thread.getPercentDivider(n2, n);
            if (d == 0.0) {
                return 0.0;
            }
            return this.getInclusive(n, n2) / d;
        }
        if (this.thread.getNodeID() == -2 || this.thread.getNodeID() == -1 || this.thread.getNodeID() == -4 || this.thread.getNodeID() == -5 || this.thread.getNodeID() == -6) {
            double d = this.thread.getPercentDivider(n2, n);
            if (d == 0.0) {
                return 0.0;
            }
            if (this.thread.getNodeID() == -4) {
                return this.function.getMinProfile().getInclusive(n, n2) / (d /= (double)this.thread.getDataSource().getAllThreads().size());
            }
            if (this.thread.getNodeID() == -5) {
                return this.function.getMaxProfile().getInclusive(n, n2) / (d /= (double)this.thread.getDataSource().getAllThreads().size());
            }
            return this.function.getTotalProfile().getInclusive(n, n2) / d;
        }
        if (this.thread.getNodeID() == -3 || this.thread.getNodeID() == -7) {
            return this.getInclusive(n, n2) / this.function.getMeanInclusive(n2) * 100.0;
        }
        throw new RuntimeException("Bad Thread ID = " + this.thread);
    }

    public double getInclusivePercent(int n) {
        return this.getInclusivePercent(-1, n);
    }

    public double getExclusivePercent(int n, int n2) {
        if (n == -1) {
            n = this.thread.getNumSnapshots() - 1;
        }
        if (this.thread.getNodeID() >= 0) {
            double d = this.thread.getPercentDivider(n2, n);
            if (d == 0.0) {
                return 0.0;
            }
            return this.getExclusive(n, n2) / d;
        }
        if (this.thread.getNodeID() == -2 || this.thread.getNodeID() == -1 || this.thread.getNodeID() == -4 || this.thread.getNodeID() == -5 || this.thread.getNodeID() == -6) {
            double d = this.thread.getPercentDivider(n2, n);
            if (d == 0.0) {
                return 0.0;
            }
            if (this.thread.getNodeID() == -2) {
                return this.function.getTotalProfile().getExclusive(n, n2) / d;
            }
            if (this.thread.getNodeID() == -4) {
                return this.function.getMinProfile().getExclusive(n, n2) / (d /= (double)this.thread.getDataSource().getAllThreads().size());
            }
            if (this.thread.getNodeID() == -5) {
                return this.function.getMaxProfile().getExclusive(n, n2) / (d /= (double)this.thread.getDataSource().getAllThreads().size());
            }
            return this.function.getMeanProfile().getExclusive(n, n2) / (d /= (double)this.thread.getDataSource().getAllThreads().size());
        }
        if (this.thread.getNodeID() == -3 || this.thread.getNodeID() == -7) {
            return this.getExclusive(n2) / this.function.getMeanExclusive(n2);
        }
        throw new RuntimeException("Bad Thread ID = " + this.thread);
    }

    public double getExclusivePercent(int n) {
        return this.getExclusivePercent(-1, n);
    }

    public void setNumCalls(int n, double d) {
        this.putDouble(n, 0, 0, d);
    }

    public void setNumCalls(double d) {
        this.putDouble(0, 0, d);
    }

    public double getNumCalls() {
        return this.getNumCalls(-1);
    }

    public double getNumCalls(int n) {
        if (n == -1) {
            n = this.thread != null ? this.thread.getNumSnapshots() - 1 : 0;
        }
        return this.getDouble(n, 0, 0);
    }

    public void setNumSubr(int n, double d) {
        this.putDouble(n, 0, 1, d);
    }

    public void setNumSubr(double d) {
        this.putDouble(0, 1, d);
    }

    public double getNumSubr() {
        return this.getNumSubr(-1);
    }

    public double getNumSubr(int n) {
        if (n == -1) {
            n = this.thread != null ? this.thread.getNumSnapshots() - 1 : 0;
        }
        return this.getDouble(n, 0, 1);
    }

    public double getInclusivePerCall(int n) {
        return this.getInclusivePerCall(-1, n);
    }

    public double getInclusivePerCall(int n, int n2) {
        if (n == -1) {
            n = this.thread.getNumSnapshots() - 1;
        }
        if (this.getNumCalls(n) == 0.0) {
            return 0.0;
        }
        return this.getInclusive(n, n2) / this.getNumCalls(n);
    }

    public double getExclusivePerCall(int n) {
        return this.getExclusivePerCall(-1, n);
    }

    public double getExclusivePerCall(int n, int n2) {
        if (n == -1) {
            n = this.thread.getNumSnapshots() - 1;
        }
        if (this.getNumCalls(n) == 0.0) {
            return 0.0;
        }
        return this.getExclusive(n, n2) / this.getNumCalls(n);
    }

    public void addMetric() {
        int n = this.thread.getNumMetrics() - 1;
        int n2 = this.thread.getNumSnapshots();
        int n3 = n + 1;
        double[] dArray = new double[(n3 + 1) * 2 * n2];
        for (int i = 0; i < n2; ++i) {
            int n4 = i * 2 * (n + 1);
            int n5 = i * 2 * (n3 + 1);
            for (int j = 0; j < 2 * (n + 1); ++j) {
                if (n5 + j >= dArray.length || n5 + j >= this.data.length) {
                    if (n5 + j >= dArray.length) {
                        System.out.println(this.function.getName() + ", metric " + j + ": New metric data array entry out of bounds (addMetric)");
                    }
                    if (n5 + j < this.data.length) continue;
                    System.out.println(this.function.getName() + ", metric " + j + ": Metric data array access out of bounds (addMetric)");
                    continue;
                }
                dArray[n5 + j] = this.data[n4 + j];
            }
        }
        this.data = dArray;
    }

    public void addSnapshot() {
        int n = this.thread.getNumMetrics();
        int n2 = this.thread.getNumSnapshots() * (2 * n + 2);
        if (n2 > this.data.length) {
            double[] dArray = new double[(int)((double)n2 * 1.5)];
            System.arraycopy(this.data, 0, dArray, 0, this.data.length);
            this.data = dArray;
        }
    }

    public void addChildProfile(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Set<FunctionProfile> set;
        CallPathData callPathData = this.getCallPathData();
        if (callPathData.childProfiles == null) {
            callPathData.childProfiles = new HashSet<FunctionProfile>();
        }
        callPathData.childProfiles.add(functionProfile);
        if (callPathData.childProfileCallPathSets == null) {
            callPathData.childProfileCallPathSets = new HashMap<FunctionProfile, Set<FunctionProfile>>();
        }
        if ((set = callPathData.childProfileCallPathSets.get(functionProfile)) == null) {
            set = new HashSet<FunctionProfile>();
            callPathData.childProfileCallPathSets.put(functionProfile, set);
        }
        set.add(functionProfile2);
    }

    public void addParentProfile(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Set<FunctionProfile> set;
        CallPathData callPathData = this.getCallPathData();
        if (callPathData.parentProfiles == null) {
            callPathData.parentProfiles = new HashSet<FunctionProfile>();
        }
        callPathData.parentProfiles.add(functionProfile);
        if (callPathData.parentProfileCallPathSets == null) {
            callPathData.parentProfileCallPathSets = new HashMap<FunctionProfile, Set<FunctionProfile>>();
        }
        if ((set = callPathData.parentProfileCallPathSets.get(functionProfile)) == null) {
            set = new HashSet<FunctionProfile>();
            callPathData.parentProfileCallPathSets.put(functionProfile, set);
        }
        set.add(functionProfile2);
    }

    public Iterator<FunctionProfile> getChildProfiles() {
        CallPathData callPathData = this.getCallPathData();
        if (callPathData.childProfiles != null) {
            return callPathData.childProfiles.iterator();
        }
        return new UtilFncs.EmptyIterator();
    }

    public Iterator<FunctionProfile> getParentProfiles() {
        CallPathData callPathData = this.getCallPathData();
        if (callPathData.parentProfiles != null) {
            return callPathData.parentProfiles.iterator();
        }
        return new UtilFncs.EmptyIterator();
    }

    public Iterator<FunctionProfile> getParentProfileCallPathIterator(FunctionProfile functionProfile) {
        CallPathData callPathData = this.getCallPathData();
        if (callPathData.parentProfileCallPathSets == null) {
            return new UtilFncs.EmptyIterator();
        }
        return callPathData.parentProfileCallPathSets.get(functionProfile).iterator();
    }

    public Iterator<FunctionProfile> getChildProfileCallPathIterator(FunctionProfile functionProfile) {
        CallPathData callPathData = this.getCallPathData();
        if (callPathData.childProfileCallPathSets == null) {
            return new UtilFncs.EmptyIterator();
        }
        return callPathData.childProfileCallPathSets.get(functionProfile).iterator();
    }

    public boolean isCallPathFunction() {
        return this.function.isCallPathFunction();
    }

    private void putDouble(int n, int n2, int n3, double d) {
        int n4 = this.thread.getNumMetrics();
        int n5 = n * (2 * (n4 + 1)) + n2 * 2 + n3;
        this.data[n5] = d;
    }

    private void putDouble(int n, int n2, double d) {
        int n3;
        int n4 = 0;
        int n5 = n;
        if (this.thread != null) {
            n4 = this.thread.getNumSnapshots() - 1;
            n5 = this.thread.getNumMetrics();
        }
        if ((n3 = n4 * (2 * (n5 + 1)) + n * 2 + n2) >= this.data.length) {
            System.out.println(this.function.getName() + ", Metric " + n + ": Data array input out of bounds (putDouble)");
            return;
        }
        this.data[n3] = d;
    }

    private double getDouble(int n, int n2, int n3) {
        if (n == -1) {
            n = this.thread.getNumSnapshots() - 1;
        }
        int n4 = n2;
        if (this.thread != null) {
            n4 = this.thread.getNumMetrics();
        }
        int n5 = n * (2 * (n4 + 1)) + n2 * 2 + n3;
        return this.data[n5];
    }

    private double getDouble(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n;
        if (this.thread != null) {
            n4 = this.thread.getNumSnapshots() - 1;
            n5 = this.thread.getNumMetrics();
        }
        if ((n3 = n4 * (2 * (n5 + 1)) + n * 2 + n2) >= this.data.length) {
            System.out.println(this.function.getName() + ", Metric " + n + ": Data array access out of bounds (getDouble)");
            return 0.0;
        }
        return this.data[n3];
    }

    public String toString() {
        return this.thread + " : " + this.function;
    }

    private CallPathData getCallPathData() {
        if (this.callPathData == null) {
            this.callPathData = new CallPathData();
        }
        return this.callPathData;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    private static class CallPathData {
        public Set<FunctionProfile> childProfiles;
        public Set<FunctionProfile> parentProfiles;
        public Map<FunctionProfile, Set<FunctionProfile>> childProfileCallPathSets;
        public Map<FunctionProfile, Set<FunctionProfile>> parentProfileCallPathSets;

        private CallPathData() {
        }
    }
}

