/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.HPCMetric;
import edu.uoregon.tau.perfdmf.HPCToolkitDataSource;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HPCToolkitXMLHandler
extends DefaultHandler {
    private HPCToolkitDataSource dataSource;
    private Function currentFunction;
    private int numMetrics = 0;
    private String currentFile;
    private Map<String, Metric> metricMap = new HashMap<String, Metric>();
    private Map<String, HPCMetric> hpcMetricMap = new HashMap<String, HPCMetric>();
    private Thread theThread;
    private ArrayList<Thread> threads;
    private Stack<String> nameStack = new Stack();
    private Group defaultGroup;
    private Group callpathGroup;
    private String version = null;
    private HashMap<String, String> procedures;

    public HPCToolkitXMLHandler(HPCToolkitDataSource hPCToolkitDataSource) {
        this.dataSource = hPCToolkitDataSource;
        this.procedures = new HashMap();
    }

    @Override
    public void startDocument() throws SAXException {
        this.threads = new ArrayList();
        this.theThread = this.dataSource.addThread(0, 0, 0);
        this.threads.add(this.theThread);
        this.defaultGroup = this.dataSource.addGroup("HPC_DEFAULT");
        this.callpathGroup = this.dataSource.addGroup("HPC_CALLPATH");
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private FunctionProfile createFunctionProfile(Thread thread, Function function) {
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function, this.numMetrics);
            thread.addFunctionProfile(functionProfile);
        }
        return functionProfile;
    }

    private void stackName(String string) {
        Function function;
        String string2 = string;
        Stack stack = (Stack)this.nameStack.clone();
        while (stack.size() != 0) {
            string = (String)stack.pop() + " => " + string;
        }
        this.nameStack.push(string2);
        this.currentFunction = function = this.dataSource.addFunction(string);
        if (string.indexOf("=>") != -1) {
            function.addGroup(this.callpathGroup);
        } else {
            function.addGroup(this.defaultGroup);
        }
        this.getFlatFunctionProfile(this.theThread, function);
    }

    private FunctionProfile getFlatFunctionProfile(Thread thread, Function function) {
        Function function2;
        Object object;
        if (function.getName().lastIndexOf("=>") != -1) {
            object = function.getName().substring(function.getName().lastIndexOf("=>") + 2).trim();
            function2 = this.dataSource.addFunction((String)object);
        } else {
            function2 = this.dataSource.addFunction(function.getName());
        }
        function2.addGroup(this.defaultGroup);
        object = thread.getFunctionProfile(function2);
        if (object == null) {
            object = new FunctionProfile(function2, this.dataSource.getNumberOfMetrics());
            thread.addFunctionProfile((FunctionProfile)object);
        }
        return object;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.version == null) {
            if (string2.equalsIgnoreCase("HPCToolkitExperiment")) {
                this.version = attributes.getValue("version");
            } else if (string2.equalsIgnoreCase("CSPROFILE")) {
                this.version = attributes.getValue("version");
            }
        } else if (this.version.startsWith("1")) {
            if (string2.equalsIgnoreCase("METRIC")) {
                String string4 = attributes.getValue("displayName");
                String string5 = attributes.getValue("shortName");
                if (string4 == null) {
                    string4 = attributes.getValue("nativeName");
                }
                Metric metric = this.dataSource.addMetric(string4);
                this.metricMap.put(string5, metric);
                ++this.numMetrics;
            } else if (string2.equalsIgnoreCase("PGM")) {
                this.stackName(attributes.getValue("n"));
            } else if (string2.equalsIgnoreCase("LM")) {
                this.stackName("Load module " + attributes.getValue("n"));
            } else if (string2.equalsIgnoreCase("L")) {
                this.stackName("loop at " + this.currentFile + ": " + attributes.getValue("b") + "-" + attributes.getValue("e"));
            } else if (string2.equalsIgnoreCase("LN")) {
                this.stackName(this.currentFile + ": " + attributes.getValue("b"));
            } else if (string2.equalsIgnoreCase("F")) {
                this.stackName(attributes.getValue("n"));
                this.currentFile = attributes.getValue("n");
            } else if (string2.equalsIgnoreCase("P")) {
                this.stackName(attributes.getValue("n"));
            } else if (string2.equalsIgnoreCase("M")) {
                String string6 = attributes.getValue("n");
                Metric metric = this.metricMap.get(string6);
                double d = Double.parseDouble(attributes.getValue("v"));
                FunctionProfile functionProfile = this.createFunctionProfile(this.theThread, this.currentFunction);
                functionProfile.setInclusive(metric.getID(), d);
                functionProfile.setExclusive(metric.getID(), d);
            }
        } else if (this.version.startsWith("2")) {
            if (string2.equalsIgnoreCase("METRIC")) {
                int n;
                String string7;
                Object object;
                HPCMetric hPCMetric = new HPCMetric(attributes);
                this.hpcMetricMap.put(hPCMetric.id, hPCMetric);
                Matcher matcher = Pattern.compile(".*(\\([IE]\\)).*").matcher(hPCMetric.getName());
                if (matcher.matches()) {
                    object = hPCMetric.getName().substring(0, matcher.start(1));
                    hPCMetric.setName(((String)object).trim());
                }
                object = Pattern.compile(".*(\\[(\\d*),(\\d*)\\]).*").matcher(hPCMetric.getName());
                Matcher matcher2 = Pattern.compile("(\\d+)..*").matcher(hPCMetric.getName());
                if (((Matcher)object).matches()) {
                    Thread thread;
                    string7 = hPCMetric.getName().substring(0, ((Matcher)object).start(1));
                    hPCMetric.setName(string7.trim());
                    n = Integer.valueOf(((Matcher)object).group(2));
                    if (this.threads.size() <= n) {
                        thread = this.dataSource.addThread(n, 0, 0);
                        this.threads.add(thread);
                    } else {
                        thread = this.threads.get(n);
                    }
                    hPCMetric.setThread(thread);
                } else if (matcher2.matches()) {
                    Thread thread;
                    string7 = hPCMetric.getName().substring(0, matcher2.start(1));
                    hPCMetric.setName(string7.trim());
                    n = Integer.valueOf(matcher2.group(1));
                    if (this.threads.size() <= n) {
                        thread = this.dataSource.addThread(n, 0, 0);
                        this.threads.add(thread);
                    } else {
                        thread = this.threads.get(n);
                    }
                    hPCMetric.setThread(thread);
                } else {
                    hPCMetric.setThread(this.theThread);
                }
                string7 = hPCMetric.getPartnerID();
                if (string7 != null && this.hpcMetricMap.containsKey(string7)) {
                    HPCMetric hPCMetric2 = this.hpcMetricMap.get(string7);
                    hPCMetric.setPartner(hPCMetric2);
                    hPCMetric.setMetric(hPCMetric2.getMetric());
                    hPCMetric2.setPartner(hPCMetric);
                } else {
                    Metric metric = this.dataSource.addMetric(hPCMetric.name);
                    hPCMetric.setMetric(metric);
                    ++this.numMetrics;
                }
            } else if (string2.equalsIgnoreCase("PF")) {
                String string8 = attributes.getValue("n");
                if (this.procedures.containsKey(string8)) {
                    this.stackName(this.procedures.get(string8));
                } else {
                    this.stackName(string8);
                }
            } else if (string2.equalsIgnoreCase("Procedure")) {
                this.procedures.put(attributes.getValue("i"), attributes.getValue("n"));
            } else if (string2.equalsIgnoreCase("M")) {
                String string9 = attributes.getValue("n");
                HPCMetric hPCMetric = this.hpcMetricMap.get(string9);
                double d = Double.parseDouble(attributes.getValue("v"));
                hPCMetric.setValue(d);
                this.theThread = hPCMetric.getThread();
                if (hPCMetric.hasPartner()) {
                    HPCMetric hPCMetric3 = hPCMetric.partner;
                    if (hPCMetric3.hasValue()) {
                        FunctionProfile functionProfile = this.createFunctionProfile(this.theThread, this.getCurrentFunction());
                        hPCMetric3.setFunctionValue(functionProfile);
                        hPCMetric.setFunctionValue(functionProfile);
                        hPCMetric.resetValue();
                        functionProfile.setNumCalls(functionProfile.getNumCalls() + 1.0);
                    }
                } else {
                    FunctionProfile functionProfile = this.createFunctionProfile(this.theThread, this.getCurrentFunction());
                    hPCMetric.setFunctionValue(functionProfile);
                    hPCMetric.resetValue();
                    functionProfile.setNumCalls(functionProfile.getNumCalls() + 1.0);
                }
            }
        }
    }

    private Function getCurrentFunction() {
        if (this.currentFunction == null) {
            Function function;
            String string = "Default";
            this.currentFunction = function = this.dataSource.addFunction(string);
            if (string.indexOf("=>") != -1) {
                function.addGroup(this.callpathGroup);
            } else {
                function.addGroup(this.defaultGroup);
            }
            this.getFlatFunctionProfile(this.theThread, function);
        }
        return this.currentFunction;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.version.startsWith("1")) {
            if (string2.equalsIgnoreCase("PGM")) {
                this.nameStack.pop();
            } else if (string2.equalsIgnoreCase("LM")) {
                this.nameStack.pop();
            } else if (string2.equalsIgnoreCase("P")) {
                this.nameStack.pop();
            } else if (string2.equalsIgnoreCase("F")) {
                this.nameStack.pop();
            } else if (string2.equalsIgnoreCase("L")) {
                this.nameStack.pop();
            } else if (string2.equalsIgnoreCase("LN")) {
                this.nameStack.pop();
            }
        } else if (this.version.startsWith("2") && string2.equalsIgnoreCase("PF")) {
            this.nameStack.pop();
        }
    }
}

