/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class IntervalEvent {
    private IntervalEvent() {
    }

    public static Map<Integer, Function> getIntervalEvents(DatabaseAPI databaseAPI, DB dB, String string, DataSource dataSource, int n) {
        if (dB.getSchemaVersion() > 0) {
            return IntervalEvent.getTAUdbIntervalEvents(databaseAPI, dB, string, dataSource, n);
        }
        HashMap<Integer, Function> hashMap = new HashMap<Integer, Function>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name, group_name, trial ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_event ");
        stringBuffer.append(string);
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append(" order by dbms_lob.substr(name) asc");
        } else if (dB.getDBType().compareTo("derby") == 0) {
            stringBuffer.append(" order by cast (name as varchar(4000)) asc");
        } else if (dB.getDBType().compareTo("db2") == 0) {
            stringBuffer.append(" order by cast (name as varchar(256)) asc");
        } else {
            stringBuffer.append(" order by name asc ");
        }
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                int n3 = resultSet.getInt(4);
                Function function = dataSource.addFunction(string2, n);
                dataSource.addGroups(string3, function);
                hashMap.put(n2, function);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashMap;
    }

    private static Map<Integer, Function> getTAUdbIntervalEvents(DatabaseAPI databaseAPI, DB dB, String string, DataSource dataSource, int n) {
        HashMap<Integer, Function> hashMap = new HashMap<Integer, Function>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("with recursive cp (id, parent, timer, name) as (");
        stringBuffer.append("SELECT tc.id, tc.parent, tc.timer, t.name FROM ");
        stringBuffer.append(dB.getSchemaPrefix());
        stringBuffer.append("timer_callpath tc INNER JOIN ");
        stringBuffer.append(dB.getSchemaPrefix());
        stringBuffer.append("timer t on tc.timer = t.id WHERE ");
        if (databaseAPI.getTrial() != null) {
            stringBuffer.append(" t.trial = " + databaseAPI.getTrial().getID() + " AND ");
        }
        stringBuffer.append(" tc.parent is null ");
        stringBuffer.append("UNION ALL ");
        stringBuffer.append("SELECT d.id, d.parent, d.timer, ");
        if (dB.getDBType().compareTo("h2") == 0) {
            stringBuffer.append("concat (cp.name, ' => ', dt.name) FROM ");
        } else {
            stringBuffer.append("cp.name || ' => ' || dt.name FROM ");
        }
        stringBuffer.append(dB.getSchemaPrefix());
        stringBuffer.append("timer_callpath AS d JOIN cp on (d.parent = cp.id) JOIN ");
        stringBuffer.append(dB.getSchemaPrefix());
        stringBuffer.append("timer dt on d.timer = dt.id ");
        if (databaseAPI.getTrial() != null) {
            stringBuffer.append("where dt.trial = " + databaseAPI.getTrial().getID() + " ");
        }
        stringBuffer.append(") ");
        stringBuffer.append("SELECT distinct cp.id, cp.timer, cp.name, t.short_name, t.source_file, t.line_number, ");
        stringBuffer.append("t.line_number_end, t.column_number, t.column_number_end, g.group_name, t.trial FROM cp join ");
        stringBuffer.append(dB.getSchemaPrefix());
        stringBuffer.append("timer t on cp.timer = t.id join ");
        stringBuffer.append(dB.getSchemaPrefix());
        stringBuffer.append("timer_group g on t.id = g.timer ");
        stringBuffer.append(string);
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append(" order by dbms_lob.substr(name) asc");
        } else if (dB.getDBType().compareTo("derby") == 0) {
            stringBuffer.append(" order by cast (name as varchar(4000)) asc");
        } else if (dB.getDBType().compareTo("db2") == 0) {
            stringBuffer.append(" order by cast (name as varchar(256)) asc");
        } else {
            stringBuffer.append(" order by name asc ");
        }
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            Function function = null;
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(10);
                int n3 = resultSet.getInt(11);
                function = (Function)hashMap.get(n2);
                boolean bl = false;
                if (string2 != null && string2.contains(" => ")) {
                    bl = true;
                    if (string3 != null && !string3.contains("TAU_CALLPATH")) {
                        string3 = string3 + "|TAU_CALLPATH";
                    }
                }
                if (function != null) {
                    dataSource.addGroups(string3, function);
                    continue;
                }
                Function function2 = dataSource.addFunction(string2, n);
                function2.setDatabaseID(n2);
                dataSource.addGroups(string3, function2);
                hashMap.put(n2, function2);
                SourceRegion sourceRegion = new SourceRegion();
                sourceRegion.setFilename(resultSet.getString(5));
                sourceRegion.setStartLine(resultSet.getInt(6));
                sourceRegion.setEndLine(resultSet.getInt(7));
                sourceRegion.setStartColumn(resultSet.getInt(8));
                sourceRegion.setEndColumn(resultSet.getInt(9));
                function2.callpathFunction = bl;
                function2.setShortName(resultSet.getString(4));
                function2.setSourceRegion(sourceRegion);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashMap;
    }

    public static int saveIntervalEvent(DB dB, int n, Function function, Hashtable<Integer, Integer> hashtable, int n2) throws SQLException {
        if (dB.getSchemaVersion() > 0) {
            return IntervalEvent.saveTAUdbIntervalEvent(dB, n, function, hashtable, n2);
        }
        int n3 = -1;
        PreparedStatement preparedStatement = null;
        if (n2 < 0) {
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            preparedStatement.setString(3, function.getGroupString());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'interval_event'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');")))));
            n3 = Integer.parseInt(dB.getDataItem(string));
        } else {
            preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where dbms_lob.instr(name, ?) > 0 and trial = ?") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where cast(name as varchar(4000)) = ? and trial = ?") : dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where name = ? and trial = ?"));
            preparedStatement.setString(1, function.getName());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        if (n3 == -1) {
            throw new RuntimeException("Unable to find event in database, event: " + function.getName(), null);
        }
        if (function.getMeanProfile() != null) {
            System.out.println("TODO! SAVE THE MEAN SUMMARY!");
        }
        if (function.getTotalProfile() != null) {
            System.out.println("TODO! SAVE THE TOTAL SUMMARY!");
        }
        return n3;
    }

    public static int saveTAUdbIntervalEvent(DB dB, int n, Function function, Hashtable<Integer, Integer> hashtable, int n2) throws SQLException {
        int n3 = -1;
        PreparedStatement preparedStatement = null;
        if (n2 < 0) {
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer (trial, name) VALUES (?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'interval_event'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');")))));
            n3 = Integer.parseInt(dB.getDataItem(string));
            List<Group> list = function.getGroups();
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_group (timer, group_name) VALUES (?, ?)");
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setInt(1, n3);
                preparedStatement.setString(2, list.get(i).getName().trim());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("with recursive cp (id, parent, timer, name) as (SELECT tc.id, tc.parent, tc.timer, t.name FROM timer_callpath tc INNER JOIN timer t on tc.timer = t.id WHERE t.trial = " + n + " and tc.parent is null " + "UNION ALL SELECT d.id, d.parent, d.timer, ");
            if (dB.getDBType().compareTo("h2") == 0) {
                stringBuilder.append("concat (cp.name, ' => ', dt.name) FROM ");
            } else {
                stringBuilder.append("cp.name || ' => ' || dt.name FROM ");
            }
            stringBuilder.append("timer_callpath AS d JOIN cp on (d.parent = cp.id) JOIN timer dt on d.timer = dt.id where dt.trial = " + n + " ) " + "SELECT distinct cp.id, cp.timer, cp.name, t.trial " + "FROM cp join timer t on cp.timer = t.id " + "join timer_group g on t.id = g.timer WHERE trial = ? and ");
            preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement(stringBuilder.toString() + "dbms_lob.instr(cp.name, ?) > 0") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement(stringBuilder.toString() + "cast(cp.name as varchar(4000)) = ?") : dB.prepareStatement(stringBuilder.toString() + "cp.name = ?"));
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        if (n3 == -1) {
            throw new RuntimeException("Unable to find event in database, event: " + function.getName(), null);
        }
        return n3;
    }

    public static void getMetaData(DB dB) {
        try {
            String[] stringArray;
            Object object;
            int n;
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("h2") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "INTERVAL_EVENT", "%") : databaseMetaData.getColumns(null, null, "interval_event", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl = false;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            }
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                stringArray = resultSet.getString("TYPE_NAME");
                Integer n2 = new Integer(resultSet.getInt("COLUMN_SIZE"));
                if (((String)object).equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
                arrayList.add(stringArray);
                arrayList2.add(n2);
            }
            resultSet.close();
            String[] stringArray2 = new String[vector.size()];
            object = new int[vector2.size()];
            stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
                stringArray[i] = (Integer)arrayList2.get(i) > 255 ? (String)arrayList.get(i) + "(" + ((Integer)arrayList2.get(i)).toString() + ")" : (String)arrayList.get(i);
            }
            dB.getDatabase().setIntervalEventFieldNames(stringArray2);
            dB.getDatabase().setIntervalEventFieldTypeNames(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

