/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.XMLCleanWrapInputStream;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MetaDataParser {
    public static MetaDataMap parse(MetaDataMap metaDataMap, String string, Thread thread) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            XMLParser xMLParser = new XMLParser(thread);
            xMLReader.setContentHandler(xMLParser);
            xMLReader.setErrorHandler(xMLParser);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            xMLReader.parse(new InputSource((InputStream)new XMLCleanWrapInputStream((InputStream)byteArrayInputStream)));
            metaDataMap = xMLParser.getMap();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return metaDataMap;
    }

    public static MetaDataMap parse(String string, Thread thread) {
        MetaDataMap metaDataMap = new MetaDataMap();
        return MetaDataParser.parse(metaDataMap, string, thread);
    }

    private static class XMLParser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private Thread thread = null;
        private MetaDataMap.MetaDataKey key = null;
        private MetaDataMap map = null;

        public XMLParser(Thread thread) {
            this.map = new MetaDataMap();
            this.thread = thread;
        }

        public XMLParser(MetaDataMap metaDataMap, Thread thread) {
            this.map = metaDataMap;
            this.thread = thread;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator = new StringBuffer();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals("name") || string2.equals("tau:name")) {
                this.key = this.map.newKey(this.accumulator.toString().trim());
            } else if (string2.equals("value") || string2.equals("tau:value")) {
                String string4 = this.accumulator.toString().trim();
                this.map.put(this.key, (Object)string4);
            } else if (string2.equals("timer_context") || string2.equals("tau:timer_context")) {
                this.key.timer_context = this.accumulator.toString().trim();
            } else if (string2.equals("call_number") || string2.equals("tau:call_number")) {
                this.key.call_number = Integer.parseInt(this.accumulator.toString().trim());
            } else if (string2.equals("timestamp") || string2.equals("tau:timestamp")) {
                this.key.timestamp = Long.parseLong(this.accumulator.toString().trim());
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.accumulator.append(cArray, n, n2);
        }

        public MetaDataMap getMap() {
            return this.map;
        }
    }
}

