/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Node
implements Comparable<Node> {
    private int nodeID = -1;
    private Map<Integer, Context> contexts = new TreeMap<Integer, Context>();
    private DataSource dataSource;

    Node(int n, DataSource dataSource) {
        this.nodeID = n;
        this.dataSource = dataSource;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public Context addContext(int n) {
        Context context = this.contexts.get(new Integer(n));
        if (context != null) {
            return context;
        }
        Context context2 = new Context(this.nodeID, n, this.dataSource);
        this.contexts.put(new Integer(n), context2);
        return context2;
    }

    public Iterator<Context> getContexts() {
        return this.contexts.values().iterator();
    }

    public Context getContext(int n) {
        return this.contexts.get(new Integer(n));
    }

    public int getNumberOfContexts() {
        return this.contexts.size();
    }

    @Override
    public int compareTo(Node node) {
        return this.nodeID - node.getNodeID();
    }

    public List<Thread> getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator<Context> iterator = this.getContexts();
        while (iterator.hasNext()) {
            Context context = iterator.next();
            Iterator<Thread> iterator2 = context.getThreads();
            while (iterator2.hasNext()) {
                Thread thread = iterator2.next();
                arrayList.add(thread);
            }
        }
        return arrayList;
    }
}

