/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ParaverDataSource
extends DataSource {
    private File file = null;
    private volatile long totalBytes = 0L;
    private volatile TrackerInputStream tracker;
    private double duration = 0.0;
    private double exclusiveDuration = 0.0;
    private double durationMicrosecondsPercent = 0.0;
    private String fileIndex = "";
    private String metricName = "";
    private String selectedFunction = "";
    private String shortMetric = null;
    private int metricIndex = 0;
    private boolean doingBursts = false;
    private boolean doingInclusive = false;
    private NumberFormat nfDLocal = NumberFormat.getNumberInstance();
    private NumberFormat nfScientific = new DecimalFormat("0.0E0");
    private static final double NANOSECONDS = 0.001;
    private static final double MICROSECONDS = 1.0;
    private static final double MILLISECONDS = 1000.0;
    private static final double SECONDS = 1000000.0;
    private static final double HOURS = 3.6E9;
    private List<String> functionNames = null;
    private File[] files;

    public ParaverDataSource(File[] fileArray) {
        this.files = fileArray;
        System.out.println("Processing " + this.files.length + " files...");
    }

    public ParaverDataSource(File file) {
        this.files[0] = file;
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        if (this.totalBytes != 0L) {
            return (int)((float)this.tracker.byteCount() / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    @Override
    public void load() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Thread thread = null;
        for (int i = 0; i < this.files.length; ++i) {
            this.file = this.files[i];
            this.fileIndex = "[" + Integer.toString(i) + "]";
            this.getMetaData().put("Data File Name" + this.fileIndex, this.file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(this.file);
            this.tracker = new TrackerInputStream((InputStream)fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.tracker);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.totalBytes = this.file.length();
            this.processGlobalSection(bufferedReader);
            String string = null;
            String string2 = null;
            this.doingBursts = false;
            this.doingInclusive = false;
            while ((string = bufferedReader.readLine()) != null) {
                double d;
                Object object;
                if ((string = string.trim()).trim().length() == 0) continue;
                if (string.startsWith("Objects/Intervals")) {
                    this.functionNames = new ArrayList<String>();
                    object = new StringTokenizer(string, " \t\n\r");
                    string2 = ((StringTokenizer)object).nextToken();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object).nextToken();
                        this.functionNames.add(string2);
                    }
                    continue;
                }
                if (!string.startsWith("THREAD")) continue;
                this.exclusiveDuration = this.duration;
                object = null;
                FunctionProfile functionProfile = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                int n = this.functionNames.size();
                int n2 = stringTokenizer.countTokens();
                boolean bl = false;
                if (n2 == n * 2 + 2) {
                    bl = true;
                }
                double d2 = 1.0;
                string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
                string2 = stringTokenizer2.nextToken();
                string2 = stringTokenizer2.nextToken();
                int n3 = Integer.parseInt(string2) - 1;
                string2 = stringTokenizer2.nextToken();
                thread = this.addThread(n3, 0, Integer.parseInt(string2) - 1);
                this.figureOutMetricName();
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    Object object2;
                    string2 = stringTokenizer.nextToken();
                    d = 0.0;
                    try {
                        object2 = new StringTokenizer(string2.toUpperCase(), "E+");
                        if (((StringTokenizer)object2).countTokens() == 2) {
                            double d3 = this.nfScientific.parse(((StringTokenizer)object2).nextToken()).doubleValue();
                            double d4 = this.nfScientific.parse(((StringTokenizer)object2).nextToken()).doubleValue();
                            d = d3 * Math.pow(10.0, d4);
                        } else {
                            d = this.nfDLocal.parse(string2).doubleValue();
                        }
                    }
                    catch (ParseException parseException) {
                        continue;
                    }
                    if (bl) {
                        object2 = stringTokenizer.nextToken();
                        if (((String)object2).equalsIgnoreCase("ns")) {
                            d2 = 0.001;
                        } else if (((String)object2).equalsIgnoreCase("us")) {
                            d2 = 1.0;
                        } else if (((String)object2).equalsIgnoreCase("ms")) {
                            d2 = 1000.0;
                        } else if (((String)object2).equalsIgnoreCase("s")) {
                            d2 = 1000000.0;
                        } else if (((String)object2).equalsIgnoreCase("h")) {
                            d2 = 3.6E9;
                        } else if (((String)object2).equalsIgnoreCase("%")) {
                            d2 = this.durationMicrosecondsPercent;
                        }
                    }
                    if (!((String)(object2 = this.functionNames.get(n4))).equalsIgnoreCase("End")) {
                        this.exclusiveDuration -= d;
                        d *= d2;
                        object = this.addFunction((String)object2, this.metrics.size());
                        functionProfile = thread.getFunctionProfile((Function)object);
                        if (functionProfile == null) {
                            functionProfile = new FunctionProfile((Function)object, this.metrics.size());
                            thread.addFunctionProfile(functionProfile);
                        }
                        if (((String)object2).startsWith("MPI")) {
                            ((Function)object).addGroup(this.addGroup("MPI"));
                        } else {
                            ((Function)object).addGroup(this.addGroup("TAU_DEFAULT"));
                        }
                        if (this.doingInclusive) {
                            functionProfile.setInclusive(this.metricIndex, d);
                        } else if (this.doingBursts) {
                            functionProfile.setNumCalls(d);
                        } else {
                            functionProfile.setNumCalls(1.0);
                            functionProfile.setNumSubr(0.0);
                            if (!(functionProfile.getInclusive(this.metricIndex) > 0.0)) {
                                functionProfile.setInclusive(this.metricIndex, d);
                            }
                            functionProfile.setExclusive(this.metricIndex, d);
                        }
                    }
                    ++n4;
                }
                object = this.addFunction(".TAU application", this.metrics.size());
                functionProfile = thread.getFunctionProfile((Function)object);
                if (functionProfile == null) {
                    functionProfile = new FunctionProfile((Function)object, this.metrics.size());
                    thread.addFunctionProfile(functionProfile);
                }
                ((Function)object).addGroup(this.addGroup("TAU_DEFAULT"));
                functionProfile.setNumCalls(1.0);
                functionProfile.setNumSubr(0.0);
                if (this.doingBursts) continue;
                functionProfile.setInclusive(this.metricIndex, this.duration);
                d = functionProfile.getExclusive(this.metricIndex);
                if (d > 0.0) {
                    functionProfile.setExclusive(this.metricIndex, Math.max(this.duration - (d + this.exclusiveDuration), 1.0));
                    continue;
                }
                functionProfile.setExclusive(this.metricIndex, Math.max(this.exclusiveDuration, 0.0));
            }
            l = System.currentTimeMillis() - l;
            fileInputStream.close();
        }
        this.generateDerivedData();
        this.aggregateMetaData();
        this.buildXMLMetaData();
        this.setGroupNamesPresent(true);
    }

    private void figureOutMetricName() {
        Metric metric = null;
        if (this.selectedFunction.replaceAll("%", "").trim().equalsIgnoreCase("time")) {
            this.metricName = "Time";
            metric = this.addMetric(this.metricName);
        } else if (this.selectedFunction.equalsIgnoreCase("# Bursts")) {
            this.doingBursts = true;
            if (this.metrics == null || this.metrics.size() == 0) {
                this.metricName = "Time";
                metric = this.addMetric(this.metricName);
            }
        } else {
            metric = this.shortMetric != null ? this.addMetric(this.shortMetric) : this.addMetric(this.metricName);
        }
        if (metric != null) {
            this.metricIndex = metric.getID();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processGlobalSection(BufferedReader bufferedReader) {
        String string = null;
        String string2 = null;
        this.metricName = new String();
        try {
            while ((string = bufferedReader.readLine()) != null) {
                String string3;
                StringTokenizer stringTokenizer;
                if ((string = string.trim()).startsWith("Paraver 2D histogram") || string.startsWith("Paraver 3D histogram")) continue;
                if (string.startsWith("Trace File:")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = string2.replaceAll("\"", "");
                    this.getMetaData().put("Trace File" + this.fileIndex, string2);
                    continue;
                }
                if (string.startsWith("Selected Function:")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    boolean bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                    }
                    this.getMetaData().put("Selected Function" + this.fileIndex, string3);
                    this.selectedFunction = string3;
                    this.metricName = this.metricName + string3 + " ";
                    continue;
                }
                if (string.startsWith("Begin Time")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    this.getMetaData().put("Begin Time" + this.fileIndex, string2);
                    try {
                        this.nfDLocal.parse(string2).doubleValue();
                    }
                    catch (ParseException parseException) {
                        System.err.println("Error parsing: " + string2);
                    }
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    this.getMetaData().put("End Time" + this.fileIndex, string2);
                    try {
                        this.nfDLocal.parse(string2).doubleValue();
                    }
                    catch (ParseException parseException) {
                        System.err.println("Error parsing: " + string2);
                    }
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    this.getMetaData().put("Duration" + this.fileIndex, string2);
                    try {
                        this.duration = this.nfDLocal.parse(string2).doubleValue() * 0.001;
                        this.durationMicrosecondsPercent = this.duration * 0.01;
                        continue;
                    }
                    catch (ParseException parseException) {
                        System.err.println("Error parsing: " + string2);
                        continue;
                    }
                }
                if (string.startsWith("Control Window")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    boolean bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                    }
                    this.getMetaData().put("Control Window" + this.fileIndex, string3);
                    this.metricName = this.metricName + string3 + " ";
                    continue;
                }
                if (string.startsWith("Data Window")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    boolean bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                    }
                    this.getMetaData().put("Data Window" + this.fileIndex, string3);
                    this.metricName = this.metricName + string3 + " ";
                    continue;
                }
                if (string.startsWith("Window name")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    boolean bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                        if (!string2.startsWith("(") || !string2.endsWith(")")) continue;
                        this.shortMetric = new String(string2.substring(1, string2.length() - 1));
                    }
                    this.getMetaData().put("Window name" + this.fileIndex, string3);
                    continue;
                }
                if (string.startsWith("Config File")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    boolean bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                        if (!string2.equalsIgnoreCase("inclusive")) continue;
                        this.doingInclusive = true;
                    }
                    this.getMetaData().put("Config File" + this.fileIndex, string3);
                    continue;
                }
                if (string.startsWith("Extra Control Window")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r:");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    boolean bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                    }
                    this.getMetaData().put("Extra Control Window" + this.fileIndex, string3);
                    this.metricName = this.metricName + string3 + " ";
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    bl = false;
                    if (string2.endsWith("\"")) {
                        bl = true;
                    }
                    string3 = string2.replaceAll("\"", "");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.endsWith("\"")) {
                            bl = true;
                            string2 = string2.replaceAll("\"", "");
                        }
                        string3 = string3 + " " + string2;
                    }
                    this.getMetaData().put("Fixed Value" + this.fileIndex, string3);
                    this.metricName = this.metricName + string3 + " ";
                    continue;
                }
                if (string.trim().length() != 0) continue;
            }
            this.metricName = this.metricName.trim();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

