/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.common.XMLCleanWrapInputStream;
import edu.uoregon.tau.common.XMLRootWrapInputStream;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.EBSTraceReader;
import edu.uoregon.tau.perfdmf.SnapshotXMLHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SnapshotDataSource
extends DataSource {
    private volatile long totalBytes = 0L;
    private volatile long bytesRead = 0L;
    private volatile TrackerInputStream tracker;
    private File[] files;

    public SnapshotDataSource(File[] fileArray) {
        this.files = fileArray;
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        if (this.totalBytes != 0L && this.tracker != null) {
            return (int)((float)(this.bytesRead + (long)this.tracker.byteCount()) / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    @Override
    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        String string = null;
        try {
            int n;
            long l = System.currentTimeMillis();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.totalBytes = 0L;
            for (n = 0; n < this.files.length; ++n) {
                this.totalBytes += this.files[n].length();
            }
            for (n = 0; n < this.files.length; ++n) {
                GZIPInputStream gZIPInputStream;
                Object object;
                FileInputStream fileInputStream = new FileInputStream(this.files[n]);
                string = this.files[n].toString();
                this.tracker = new TrackerInputStream((InputStream)fileInputStream);
                try {
                    object = new GZIPInputStream((InputStream)this.tracker);
                    gZIPInputStream = object;
                }
                catch (IOException iOException) {
                    fileInputStream.close();
                    fileInputStream = new FileInputStream(this.files[n]);
                    this.tracker = new TrackerInputStream((InputStream)fileInputStream);
                    gZIPInputStream = this.tracker;
                }
                object = new SnapshotXMLHandler(this);
                if (this.getSelectedRanks() != null) {
                    ((SnapshotXMLHandler)object).setSelectedRanks(this.getSelectedRanks());
                }
                xMLReader.setContentHandler((ContentHandler)object);
                xMLReader.setErrorHandler((ErrorHandler)object);
                xMLReader.parse(new InputSource((InputStream)new XMLRootWrapInputStream((InputStream)new XMLCleanWrapInputStream((InputStream)new BufferedInputStream(gZIPInputStream)))));
                this.bytesRead += this.files[n].length();
            }
            l = System.currentTimeMillis() - l;
            EBSTraceReader.processEBSTraces(this, new File(System.getProperty("user.dir")));
            this.derivedProvided = true;
            this.generateDerivedData();
            this.aggregateMetaData();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new DataSourceException(sAXException, string);
        }
    }
}

