/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.SnapshotDataSource;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SnapshotXMLHandler
extends DefaultHandler {
    private SnapshotDataSource dataSource;
    private static final String TNR = " t\n\r";
    private Map<String, ThreadData> threadMap = new HashMap<String, ThreadData>();
    private ThreadData currentThread;
    private Snapshot currentSnapshot;
    private int[] currentMetrics;
    private StringBuffer accumulator = new StringBuffer();
    private int currentId;
    private String currentName;
    private String currentValue;
    private String currentGroup;
    private long currentTimestamp;
    private boolean unified;
    private ThreadData unifiedDefinitions;
    private Set<Integer> selectedRanks = null;
    private boolean mSet = false;
    private boolean mNNSet = false;
    private boolean tSet = false;
    private boolean sDSet = false;
    private boolean sDNNSet = false;
    private boolean unknownDerivedProfile = false;
    private static final String THREAD = "thread";
    private static final String ID = "id";
    private static final String DERIVEDENTITY = "derivedentity";
    private static final String DERIVEDPROFILE = "derivedprofile";
    private boolean bypassRanksFlag = false;

    public SnapshotXMLHandler(SnapshotDataSource snapshotDataSource) {
        this.dataSource = snapshotDataSource;
    }

    public void setSelectedRanks(Set<Integer> set) {
        this.selectedRanks = set;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private void handleMetric(String string) {
        Metric metric = this.dataSource.addMetric(string);
        while (this.currentId >= this.currentThread.metricMap.size()) {
            this.currentThread.metricMap.add(null);
        }
        this.currentThread.metricMap.set(this.currentId, metric);
    }

    private void handleEvent(String string, String string2) {
        int n = this.currentId;
        Function function = this.dataSource.addFunction(string);
        this.dataSource.addGroups(string2, function);
        while (n >= this.currentThread.eventMap.size()) {
            this.currentThread.eventMap.add(null);
        }
        this.currentThread.eventMap.set(n, function);
    }

    private void handleUserEvent(String string) {
        int n = this.currentId;
        UserEvent userEvent = this.dataSource.addUserEvent(string);
        while (n >= this.currentThread.userEventMap.size()) {
            this.currentThread.userEventMap.add(null);
        }
        this.currentThread.userEventMap.set(n, userEvent);
    }

    private void handleThread(Attributes attributes) {
        String string = attributes.getValue(ID);
        int n = Integer.parseInt(attributes.getValue("node"));
        if (this.selectedRanks != null && !this.selectedRanks.contains(n) && n != 0) {
            this.bypassRanksFlag = true;
            return;
        }
        int n2 = Integer.parseInt(attributes.getValue("context"));
        int n3 = Integer.parseInt(attributes.getValue(THREAD));
        ThreadData threadData = new ThreadData();
        if (this.unified) {
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
        }
        threadData.thread = this.dataSource.addThread(n, n2, n3);
        this.threadMap.put(string, threadData);
        this.currentThread = threadData;
    }

    private void handleDerivedEntity(Attributes attributes) {
        String string = attributes.getValue(ID);
        if (string.equals("mean_all")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.meanDataAll = new Thread(-6, -6, -6, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.mSet = true;
        } else if (string.equals("mean_no_null")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.meanDataNoNull = new Thread(-1, -1, -1, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.mNNSet = true;
        } else if (string.equals("total")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.totalData = new Thread(-2, -2, -2, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.tSet = true;
        } else if (string.equals("stddev_all")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.stddevDataAll = new Thread(-7, -7, -7, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.sDSet = true;
        } else if (string.equals("stddev_no_null")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.stddevDataNoNull = new Thread(-3, -3, -3, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.sDNNSet = true;
        } else if (string.equals("min_no_null")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.minData = new Thread(-4, -4, -4, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.sDNNSet = true;
        } else if (string.equals("max_no_null")) {
            ThreadData threadData = new ThreadData();
            threadData.eventMap = this.unifiedDefinitions.eventMap;
            threadData.userEventMap = this.unifiedDefinitions.userEventMap;
            threadData.metricMap = this.unifiedDefinitions.metricMap;
            threadData.thread = this.dataSource.maxData = new Thread(-5, -5, -5, this.dataSource.getNumberOfMetrics(), this.dataSource);
            this.threadMap.put(string, threadData);
            this.currentThread = threadData;
            this.sDNNSet = true;
        }
        if (this.mSet && this.tSet && this.sDSet && this.sDNNSet && this.mNNSet) {
            this.dataSource.derivedProvided = true;
        }
    }

    private void handleDefinitions(Attributes attributes) {
        String string = attributes.getValue(THREAD);
        if (string.equals("*")) {
            this.unified = true;
            this.currentThread = this.unifiedDefinitions = new ThreadData();
        } else {
            this.currentThread = this.threadMap.get(string);
        }
    }

    private void handleProfile(Attributes attributes) {
        String string = attributes.getValue(THREAD);
        this.currentThread = this.threadMap.get(string);
        this.currentSnapshot = this.currentThread.thread.addSnapshot("");
    }

    private void handleDerivedProfile(Attributes attributes) {
        String string = attributes.getValue(DERIVEDENTITY);
        this.currentThread = this.threadMap.get(string);
        if (this.currentThread == null) {
            this.unknownDerivedProfile = true;
            return;
        }
        this.currentSnapshot = this.currentThread.thread.addSnapshot("");
    }

    private void handleIntervalData(Attributes attributes) {
        String string = attributes.getValue("metrics");
        StringTokenizer stringTokenizer = new StringTokenizer(string, TNR);
        this.currentMetrics = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            this.currentMetrics[n++] = n2;
        }
    }

    private void handleAtomicDataEnd() {
        String string = this.accumulator.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, TNR);
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            if (n < 0 || n > this.currentThread.userEventMap.size() - 1) {
                System.out.println("Skipping undefined atomic event, id# " + n);
                return;
            }
            UserEvent userEvent = this.currentThread.userEventMap.get(n);
            UserEventProfile userEventProfile = this.currentThread.thread.getUserEventProfile(userEvent);
            if (userEventProfile == null) {
                userEventProfile = new UserEventProfile(userEvent, this.currentThread.thread.getSnapshots().size());
                this.currentThread.thread.addUserEventProfile(userEventProfile);
            }
            double d = Double.parseDouble(stringTokenizer.nextToken());
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            double d3 = Double.parseDouble(stringTokenizer.nextToken());
            double d4 = Double.parseDouble(stringTokenizer.nextToken());
            double d5 = Double.parseDouble(stringTokenizer.nextToken());
            userEventProfile.setNumSamples(d);
            userEventProfile.setMaxValue(d2);
            userEventProfile.setMinValue(d3);
            userEventProfile.setMeanValue(d4);
            userEventProfile.setSumSquared(d5);
        }
    }

    private void handleIntervalDataEnd() {
        String string = this.accumulator.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, TNR);
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            if (n < 0 || n > this.currentThread.eventMap.size() - 1) {
                System.out.println("Skipping undefined interval event, id# " + n);
                return;
            }
            Function function = this.currentThread.eventMap.get(n);
            FunctionProfile functionProfile = this.currentThread.thread.getFunctionProfile(function);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile(function, this.dataSource.getNumberOfMetrics(), this.currentThread.thread.getSnapshots().size());
                this.currentThread.thread.addFunctionProfile(functionProfile);
            }
            double d = Double.parseDouble(stringTokenizer.nextToken());
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            for (int i = 0; i < this.currentMetrics.length; ++i) {
                int n2 = this.currentMetrics[i];
                Metric metric = this.currentThread.metricMap.get(n2);
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                functionProfile.setExclusive(metric.getID(), d3);
                functionProfile.setInclusive(metric.getID(), d4);
            }
            functionProfile.setNumCalls(d);
            functionProfile.setNumSubr(d2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.unknownDerivedProfile) {
            return;
        }
        if (this.bypassRanksFlag) {
            return;
        }
        if (string2.equals(THREAD)) {
            this.handleThread(attributes);
        } else if (string2.equals("name")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("value")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("group")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("utc_date")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("timestamp")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals("definitions")) {
            this.handleDefinitions(attributes);
        } else if (string2.equals("metric")) {
            this.currentId = Integer.parseInt(attributes.getValue(ID));
        } else if (string2.equals("event")) {
            this.currentId = Integer.parseInt(attributes.getValue(ID));
        } else if (string2.equals("userevent")) {
            this.currentId = Integer.parseInt(attributes.getValue(ID));
        } else if (string2.equals("profile")) {
            this.handleProfile(attributes);
        } else if (string2.equals("interval_data") || string2.equals("derivedinterval_data")) {
            this.handleIntervalData(attributes);
            this.accumulator = new StringBuffer();
        } else if (string2.equals("atomic_data") || string2.equals("derivedatomic_data")) {
            this.accumulator = new StringBuffer();
        } else if (string2.equals(DERIVEDENTITY)) {
            this.handleDerivedEntity(attributes);
        } else if (string2.equals(DERIVEDPROFILE)) {
            this.handleDerivedProfile(attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.unknownDerivedProfile) {
            if (string2.equals(DERIVEDPROFILE)) {
                this.unknownDerivedProfile = false;
            }
            return;
        }
        if (this.bypassRanksFlag) {
            if (string2.equals("profile_xml")) {
                this.bypassRanksFlag = false;
            }
            return;
        }
        if (string2.equals("thread_definition")) {
            this.currentThread = null;
        } else if (string2.equals("name")) {
            this.currentName = this.accumulator.toString();
        } else if (string2.equals("value")) {
            this.currentValue = this.accumulator.toString();
        } else if (string2.equals("utc_date")) {
            try {
                DataSource.dateTime.parse(this.accumulator.toString());
            }
            catch (ParseException parseException) {}
        } else if (string2.equals("timestamp")) {
            this.currentTimestamp = Long.parseLong(this.accumulator.toString());
        } else if (string2.equals("group")) {
            this.currentGroup = this.accumulator.toString();
        } else if (string2.equals("profile")) {
            this.currentSnapshot.setName(this.currentName);
            this.currentSnapshot.setTimestamp(this.currentTimestamp);
        } else if (string2.equals("metric")) {
            this.handleMetric(this.currentName);
        } else if (string2.equals("event")) {
            this.handleEvent(this.currentName, this.currentGroup);
        } else if (string2.equals("userevent")) {
            this.handleUserEvent(this.currentName);
        } else if (string2.equals("attribute")) {
            this.currentThread.thread.getMetaData().put(this.currentName, this.currentValue);
        } else if (string2.equals("interval_data") || string2.equals("derivedinterval_data")) {
            this.handleIntervalDataEnd();
        } else if (string2.equals("atomic_data")) {
            this.handleAtomicDataEnd();
        } else if (string2.equals("derivedatomic_data")) {
            this.handleAtomicDataEnd();
            this.dataSource.derivedAtomicProvided = true;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.accumulator.append(cArray, n, n2);
    }

    private static class ThreadData {
        public Thread thread;
        public List<Metric> metricMap = new ArrayList<Metric>();
        public List<Function> eventMap = new ArrayList<Function>();
        public List<UserEvent> userEventMap = new ArrayList<UserEvent>();

        private ThreadData() {
        }
    }
}

