/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.TauRuntimeException;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Thread
implements Comparable<Thread> {
    private int nodeID;
    private int contextID;
    private int threadID;
    private List<FunctionProfile> functionProfiles = new ArrayList<FunctionProfile>();
    private Map<Integer, UserEventProfile> userEventProfiles = new HashMap<Integer, UserEventProfile>();
    private boolean trimmed;
    private boolean relationsBuilt;
    private int numMetrics;
    public static final int MEAN = -1;
    public static final int TOTAL = -2;
    public static final int STDDEV = -3;
    public static final int MIN = -4;
    public static final int MAX = -5;
    public static final int MEAN_ALL = -6;
    public static final int STDDEV_ALL = -7;
    private List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private MetaDataMap metaData = null;
    private boolean firstSnapshotFound;
    private ThreadData[][] threadData;
    private long startTime;
    private DataSource dataSource;

    public void setMetaData(MetaDataMap metaDataMap) {
        this.metaData = metaDataMap;
    }

    public Thread(int n, int n2, int n3, int n4, DataSource dataSource) {
        n4 = Math.max(n4, 1);
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.numMetrics = n4;
        this.dataSource = dataSource;
        if (dataSource == null) {
            throw new TauRuntimeException("Error: dataSource should never be null in Thread constructor");
        }
        this.recreateData();
        Snapshot snapshot = new Snapshot("", this.snapshots.size());
        this.snapshots.add(snapshot);
    }

    public String toString() {
        if (this.nodeID == -1) {
            return "Mean";
        }
        if (this.nodeID == -2) {
            return "Total";
        }
        if (this.nodeID == -3) {
            return "Standard Deviation";
        }
        if (this.nodeID == -4) {
            return "Min";
        }
        if (this.nodeID == -5) {
            return "Max";
        }
        if (this.nodeID == -6) {
            return "Mean, All Threads";
        }
        if (this.nodeID == -7) {
            return "Standard Deviation, All Threads";
        }
        return "n,c,t " + this.nodeID + "," + this.contextID + "," + this.threadID;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getContextID() {
        return this.contextID;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public int getNumMetrics() {
        return this.numMetrics;
    }

    public void addMetric() {
        ++this.numMetrics;
        this.recreateData();
        for (FunctionProfile functionProfile : this.getFunctionProfiles()) {
            if (functionProfile == null) continue;
            functionProfile.addMetric();
        }
    }

    public Snapshot addSnapshot(String string) {
        if (!this.firstSnapshotFound) {
            this.firstSnapshotFound = true;
            Snapshot snapshot = this.snapshots.get(0);
            snapshot.setName(string);
            return snapshot;
        }
        Snapshot snapshot = new Snapshot(string, this.snapshots.size());
        this.snapshots.add(snapshot);
        if (this.snapshots.size() > 1) {
            for (FunctionProfile object : this.functionProfiles) {
                if (object == null) continue;
                object.addSnapshot();
            }
            for (UserEventProfile userEventProfile : this.userEventProfiles.values()) {
                if (userEventProfile == null) continue;
                userEventProfile.addSnapshot();
            }
        }
        this.recreateData();
        return snapshot;
    }

    public void addSnapshots(int n) {
        this.firstSnapshotFound = true;
        while (this.snapshots.size() < n) {
            this.addSnapshot("UNKNOWN");
        }
    }

    private void recreateData() {
        this.threadData = new ThreadData[this.getNumSnapshots()][this.getNumMetrics()];
        for (int i = 0; i < this.getNumSnapshots(); ++i) {
            for (int j = 0; j < this.getNumMetrics(); ++j) {
                this.threadData[i][j] = new ThreadData();
            }
        }
    }

    public List<Snapshot> getSnapshots() {
        return this.snapshots;
    }

    public int getNumSnapshots() {
        return Math.max(1, this.snapshots.size());
    }

    public void addFunctionProfile(FunctionProfile functionProfile) {
        int n = functionProfile.getFunction().getID();
        while (n >= this.functionProfiles.size()) {
            this.functionProfiles.add(null);
        }
        this.functionProfiles.set(n, functionProfile);
        functionProfile.setThread(this);
    }

    public void deleteFunctionProfile(FunctionProfile functionProfile) {
        int n = functionProfile.getFunction().getID();
        this.functionProfiles.set(n, null);
    }

    public void addUserEventProfile(UserEventProfile userEventProfile) {
        int n = userEventProfile.getUserEvent().getID();
        this.userEventProfiles.put(new Integer(n), userEventProfile);
    }

    public FunctionProfile getFunctionProfile(Function function) {
        if (this.functionProfiles != null && function.getID() < this.functionProfiles.size()) {
            return this.functionProfiles.get(function.getID());
        }
        return null;
    }

    public FunctionProfile getOrCreateFunctionProfile(Function function, int n) {
        FunctionProfile functionProfile = this.getFunctionProfile(function);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function, n);
            this.addFunctionProfile(functionProfile);
            return functionProfile;
        }
        return functionProfile;
    }

    public List<FunctionProfile> getFunctionProfiles() {
        return this.functionProfiles;
    }

    public Iterator<FunctionProfile> getFunctionProfileIterator() {
        return this.functionProfiles.iterator();
    }

    public UserEventProfile getUserEventProfile(UserEvent userEvent) {
        return this.userEventProfiles.get(new Integer(userEvent.getID()));
    }

    public Iterator<UserEventProfile> getUserEventProfiles() {
        return this.userEventProfiles.values().iterator();
    }

    public void setTrimmed(boolean bl) {
        this.trimmed = bl;
    }

    public boolean trimmed() {
        return this.trimmed;
    }

    public void setRelationsBuilt(boolean bl) {
        this.relationsBuilt = bl;
    }

    public boolean relationsBuilt() {
        return this.relationsBuilt;
    }

    @Override
    public int compareTo(Thread thread) {
        return this.threadID - thread.getThreadID();
    }

    public void setThreadData(int n) {
        this.setThreadValues(n, n, 0, this.getNumSnapshots() - 1);
    }

    public void setThreadDataAllMetrics() {
        this.setThreadValues(0, this.getNumMetrics() - 1, 0, this.getNumSnapshots() - 1);
    }

    private void setThreadValues(int n, int n2, int n3, int n4) {
        String string;
        n = 0;
        n2 = this.getNumMetrics() - 1;
        if (this.getMetaData() != null && (string = this.getMetaData().get("Starting Timestamp")) != null) {
            this.setStartTime(Long.parseLong(string));
        }
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                ThreadData threadData = this.threadData[i][j];
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                Iterator<FunctionProfile> iterator = this.getFunctionProfileIterator();
                while (iterator.hasNext()) {
                    FunctionProfile functionProfile = iterator.next();
                    if (functionProfile == null) continue;
                    if (functionProfile.getFunction().isPhase()) {
                        d2 = Math.max(d2, functionProfile.getInclusive(i, j));
                        d4 = Math.max(d4, functionProfile.getInclusivePerCall(i, j));
                    } else {
                        d2 = Math.max(d2, functionProfile.getExclusive(i, j));
                        d4 = Math.max(d4, functionProfile.getExclusivePerCall(i, j));
                    }
                    d = Math.max(d, functionProfile.getInclusive(i, j));
                    d3 = Math.max(d3, functionProfile.getInclusivePerCall(i, j));
                    d5 = Math.max(d5, functionProfile.getNumCalls(i));
                    d6 = Math.max(d6, functionProfile.getNumSubr(i));
                }
                threadData.maxExclusive = d2;
                threadData.maxInclusive = d;
                threadData.maxExclusivePerCall = d4;
                threadData.maxInclusivePerCall = d3;
                threadData.maxNumCalls = d5;
                threadData.maxNumSubr = d6;
                if (this.getNodeID() >= 0) {
                    threadData.percentDivider = threadData.maxInclusive / 100.0;
                }
                double d7 = 0.0;
                double d8 = 0.0;
                Iterator<FunctionProfile> iterator2 = this.getFunctionProfileIterator();
                while (iterator2.hasNext()) {
                    FunctionProfile functionProfile = iterator2.next();
                    if (functionProfile == null) continue;
                    d8 = Math.max(d8, functionProfile.getExclusivePercent(i, j));
                    d7 = Math.max(d7, functionProfile.getInclusivePercent(i, j));
                }
                threadData.maxExclusivePercent = d8;
                threadData.maxInclusivePercent = d7;
            }
        }
    }

    public MetaDataMap getMetaData() {
        if (this.metaData == null) {
            this.metaData = new MetaDataMap();
        }
        return this.metaData;
    }

    public double getMaxInclusive(int n, int n2) {
        if (n2 == -1) {
            n2 = this.getNumSnapshots() - 1;
        }
        return this.threadData[n2][n].maxInclusive;
    }

    public double getMaxExclusive(int n, int n2) {
        return this.threadData[n2][n].maxExclusive;
    }

    public double getMaxInclusivePercent(int n, int n2) {
        return this.threadData[n2][n].maxInclusivePercent;
    }

    public double getMaxExclusivePercent(int n, int n2) {
        return this.threadData[n2][n].maxExclusivePercent;
    }

    public double getMaxInclusivePerCall(int n, int n2) {
        return this.threadData[n2][n].maxInclusivePerCall;
    }

    public double getMaxExclusivePerCall(int n, int n2) {
        return this.threadData[n2][n].maxExclusivePerCall;
    }

    public void setPercentDivider(int n, int n2, double d) {
        this.threadData[n2][n].percentDivider = d;
    }

    public double getPercentDivider(int n, int n2) {
        return this.threadData[n2][n].percentDivider;
    }

    public double getMaxNumCalls(int n) {
        return this.threadData[n][0].maxNumCalls;
    }

    public double getMaxNumSubr(int n) {
        return this.threadData[n][0].maxNumSubr;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private static class ThreadData {
        public double maxNumCalls;
        public double maxNumSubr;
        public double maxInclusive;
        public double maxInclusivePercent;
        public double maxInclusivePerCall;
        public double maxExclusive;
        public double maxExclusivePercent;
        public double maxExclusivePerCall;
        public double percentDivider;

        private ThreadData() {
        }
    }
}

