/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.analysis;

public class DistanceMatrix {
    public double[][] dataMatrix = null;
    public double[][] distanceMatrix = null;
    public String[] eventName = null;
    public double[] total = null;
    public int matrixSize = 0;
    public int dimensionCount = 0;
    private double maxDistance = 0.0;
    private final int[] colorMap = new int[]{-16777216, -16777199, -16777182, -16777165, -16777148, -16777131, -16777114, -16777097, -16777080, -16777063, -16777046, -16777029, -16777012, -16776995, -16776978, -16776961, -16772864, -16768512, -16764160, -16759808, -16755456, -16751104, -16746752, -16742400, -16738048, -16733696, -16729344, -16724992, -16720640, -16716288, -16711936, -15602176, -14492416, -13382656, -12272896, -11163136, -10053376, -8943616, -7833856, -6724096, -5614336, -4504576, -3394816, -2285056, -1175296, -65536};

    public DistanceMatrix(int n, int n2) {
        this.dataMatrix = new double[n][n2];
        this.total = new double[n];
        this.matrixSize = n;
        this.dimensionCount = n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.dataMatrix[i][j] = 0.0;
            }
        }
    }

    public void getEuclideanDistance() {
        this.distanceMatrix = new double[this.matrixSize][this.matrixSize];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.matrixSize; ++i) {
            for (int j = i; j < this.matrixSize; ++j) {
                d2 = 0.0;
                for (int k = 0; k < this.dimensionCount; ++k) {
                    d = this.dataMatrix[i][k] - this.dataMatrix[j][k];
                    d2 += d * d;
                }
                this.distanceMatrix[i][j] = StrictMath.sqrt(d2);
                this.distanceMatrix[j][i] = StrictMath.sqrt(d2);
            }
        }
    }

    public void getManhattanDistance() {
        this.distanceMatrix = new double[this.matrixSize][this.matrixSize];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.matrixSize; ++i) {
            for (int j = i; j < this.matrixSize; ++j) {
                d2 = 0.0;
                for (int k = 0; k < this.dimensionCount; ++k) {
                    d = this.dataMatrix[i][k] - this.dataMatrix[j][k];
                    d2 += StrictMath.abs(d);
                }
                this.distanceMatrix[i][j] = d2;
                this.distanceMatrix[j][i] = d2;
                if (!(this.maxDistance < d2)) continue;
                this.maxDistance = d2;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# Matrix Size: " + this.matrixSize + "\n");
        stringBuffer.append("# Dimension Count: " + this.dimensionCount + "\n");
        stringBuffer.append("# Distance Matrix:\n");
        for (int i = 0; i < this.matrixSize; ++i) {
            stringBuffer.append("# row " + i + ":\n");
            for (int j = 0; j < this.matrixSize; ++j) {
                stringBuffer.append(this.distanceMatrix[i][j]);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int[] toImage(boolean bl, boolean bl2) {
        int[] nArray = new int[this.matrixSize * this.matrixSize];
        int n = 255;
        double d = bl ? 255.0 / this.maxDistance : 127.5;
        int n2 = 0;
        if (bl2) {
            for (int i = 0; i < this.matrixSize; ++i) {
                for (int j = i; j < this.matrixSize; ++j) {
                    int n3;
                    int n4;
                    n2 = i * this.matrixSize + j;
                    int n5 = n4 = (int)(this.distanceMatrix[i][j] * d);
                    int n6 = n4;
                    nArray[n2] = n3 = n << 24 | n6 << 16 | n5 << 8 | n4;
                }
            }
        } else {
            for (int i = 0; i < this.matrixSize; ++i) {
                for (int j = 0; j < this.matrixSize; ++j) {
                    int n7;
                    int n8 = n7 = (int)(this.distanceMatrix[i][j] * d);
                    int n9 = n7;
                    int n10 = n << 24 | n9 << 16 | n8 << 8 | n7;
                    nArray[n2++] = n10;
                }
            }
        }
        System.out.println("Image range: 0.0 to " + this.maxDistance);
        return nArray;
    }

    public int[] toColorImage(boolean bl, boolean bl2) {
        int[] nArray = new int[this.matrixSize * this.matrixSize];
        double d = bl ? 45.0 / this.maxDistance : 22.5;
        int n = 0;
        if (bl2) {
            for (int i = 0; i < this.matrixSize; ++i) {
                for (int j = i; j < this.matrixSize; ++j) {
                    n = i * this.matrixSize + j;
                    nArray[n] = this.colorMap[(int)(this.distanceMatrix[i][j] * d)];
                }
            }
        } else {
            for (int i = 0; i < this.matrixSize; ++i) {
                for (int j = 0; j < this.matrixSize; ++j) {
                    nArray[n++] = this.colorMap[(int)(this.distanceMatrix[i][j] * d)];
                }
            }
        }
        System.out.println("Image range: 0.0 to " + this.maxDistance);
        return nArray;
    }
}

