/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.common.Common;
import edu.uoregon.tau.common.TauRuntimeException;
import edu.uoregon.tau.common.Wget;
import edu.uoregon.tau.common.tar.Tar;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordField;
import edu.uoregon.tau.perfdmf.loader.ConfigureTest;
import edu.uoregon.tau.perfdmf.loader.DatabaseConfigurationException;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class Configure {
    private static String Usage = "Usage: configure [{-h,--help}] --create-default [{-g,--configfile} filename] [{-c --config} configuration_name] [{-t,--tauroot} path]";
    private static final String GREETING = "\nWelcome to the configuration program for PerfDMF.\nThis program will prompt you for some information necessary to ensure\nthe desired behavior for the PerfDMF tools.\n";
    private static final List<String> ALL_DB_NAMES = Arrays.asList("oracle", "postgresql", "mysql", "derby", "db2", "h2", "sqlite");
    private static final List<String> FILE_DB_NAMES = Arrays.asList("derby", "h2", "sqlite");
    private String configuration_name = "";
    private String jardir;
    private String schemadir;
    private String jdbc_db_jarfile = "h2.jar";
    private String jdbc_db_driver = "org.h2.Driver";
    private String jdbc_db_type = "h2";
    private String db_hostname = "";
    private String db_portnum = "";
    private String db_dbname = "perfdmf";
    private String db_username = "";
    private String db_password = "";
    private String db_schemaprefix = "";
    private String db_schemafile = "taudb.sql";
    private String xml_parser = "xerces.jar";
    private boolean store_db_password = false;
    private boolean db_use_ssl = false;
    private boolean db_use_ssl_keys = false;
    private String db_keystore = "";
    private String db_keystore_password = "";
    private String db_truststore = "";
    private String db_truststore_password = "";
    private ParseConfig parser;
    private boolean configFileFound = false;
    private String configFileName;

    public Configure(String string, String string2) {
        this.jardir = string;
        this.schemadir = string2;
    }

    public void errorPrint(String string) {
        System.err.println(string);
    }

    public void initialize(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        try {
            this.configFileName = string;
            File file = new File(this.configFileName);
            if (file.exists()) {
                System.out.println("Configuration file found...");
                this.parseConfigFile();
                this.configuration_name = string2;
                this.configFileFound = true;
            } else {
                System.out.println("Configuration file NOT found...");
                System.out.println("a new configuration file will be created.");
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void initialize(String string) {
        this.initialize(string, null);
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        System.out.println("Parsing config file...");
        this.parser = new ParseConfig(this.configFileName);
        this.jdbc_db_jarfile = this.parser.getJDBCJarFile();
        this.jdbc_db_driver = this.parser.getJDBCDriver();
        this.jdbc_db_type = this.parser.getDBType();
        this.db_hostname = this.parser.getDBHost();
        this.db_portnum = this.parser.getDBPort();
        this.db_schemaprefix = this.parser.getDBSchemaPrefix();
        this.db_dbname = this.parser.getDBName();
        this.db_username = this.parser.getDBUserName();
        this.db_password = this.parser.getDBPasswd();
        this.db_schemafile = this.parser.getDBSchema();
        this.xml_parser = this.parser.getXMLSAXParser();
        this.db_use_ssl = this.parser.getDBUseSSL();
        this.db_keystore = this.parser.getDBKeystore();
        this.db_keystore_password = this.parser.getDBKeystorePasswd();
        this.db_truststore = this.parser.getDBTruststore();
        this.db_truststore_password = this.parser.getDBTruststorePasswd();
    }

    private String getUserJarDir() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.trim().startsWith("windows")) {
            return this.jardir;
        }
        String string2 = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator;
        File file = new File(string2);
        file.mkdirs();
        return string2;
    }

    public void useDefaults(String string) {
        this.jdbc_db_jarfile = this.jardir + File.separator + "h2.jar";
        this.db_dbname = string == null ? System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf" + File.separator + "perfdmf" : System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + string + File.separator + "perfdmf";
        this.jdbc_db_driver = "org.h2.Driver";
        this.db_schemafile = this.schemadir + File.separator + "taudb.sql";
        this.db_hostname = "";
        this.db_portnum = "";
        this.store_db_password = true;
        this.db_use_ssl = false;
        this.db_use_ssl_keys = false;
    }

    private boolean promptYN(BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        do {
            System.out.print(string + " (y/n): ");
            string2 = bufferedReader.readLine();
            if (!string2.equalsIgnoreCase("yes") && !string2.equalsIgnoreCase("y")) continue;
            return true;
        } while (!string2.equalsIgnoreCase("no") && !string2.equalsIgnoreCase("n"));
        return false;
    }

    private String promptString(BufferedReader bufferedReader, String string, String string2) throws IOException {
        System.out.print(string + "\n(" + string2 + "): ");
        String string3 = bufferedReader.readLine();
        if (string3.length() > 0) {
            return string3;
        }
        return string2;
    }

    private String promptPassword(String string) throws IOException {
        String string2;
        String string3;
        while (!(string3 = new PasswordField().getPassword(string + " ")).equals(string2 = new PasswordField().getPassword("Confirm password: "))) {
            System.out.println("Passwords do not match.");
            System.out.println();
        }
        return string3;
    }

    private String join(List<String> list, String string) {
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : list) {
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            string2 = string;
        }
        return stringBuilder.toString();
    }

    public void promptForData() {
        System.out.println(GREETING);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nYou will now be prompted for new values, if desired.  The current or default\nvalues for each prompt are shown in parenthesis.\nTo accept the current/default value, just press Enter/Return.\n");
        try {
            File file;
            Object object;
            this.configuration_name = this.promptString(bufferedReader, "Please enter the name of this configuration.", this.configuration_name);
            String string = this.jdbc_db_type;
            do {
                this.jdbc_db_type = this.promptString(bufferedReader, "Please enter the database vendor (" + this.join(ALL_DB_NAMES, ", ") + ").", this.jdbc_db_type);
            } while (!ALL_DB_NAMES.contains(this.jdbc_db_type));
            if (this.configFileFound) {
                if (this.jdbc_db_type.compareTo("postgresql") == 0 && string.compareTo("postgresql") != 0) {
                    this.jdbc_db_jarfile = this.jardir + File.separator + "postgresql.jar";
                    this.jdbc_db_driver = "org.postgresql.Driver";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.sql";
                    this.db_portnum = "5432";
                    this.db_hostname = "localhost";
                    this.db_dbname = "perfdmf";
                } else if (this.jdbc_db_type.compareTo("mysql") == 0 && string.compareTo("mysql") != 0) {
                    this.jdbc_db_jarfile = this.jardir + File.separator + "mysql.jar";
                    this.jdbc_db_driver = "org.gjt.mm.mysql.Driver";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.mysql.sql";
                    this.db_portnum = "3306";
                    this.db_hostname = "localhost";
                    this.db_dbname = "perfdmf";
                } else if (this.jdbc_db_type.compareTo("oracle") == 0 && string.compareTo("oracle") != 0) {
                    this.jdbc_db_jarfile = this.getUserJarDir() + "ojdbc14.jar";
                    this.jdbc_db_driver = "oracle.jdbc.OracleDriver";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.oracle.sql";
                    this.db_portnum = "1521";
                    this.db_hostname = "localhost";
                    this.db_dbname = "perfdmf";
                } else if (this.jdbc_db_type.compareTo("derby") == 0 && string.compareTo("derby") != 0) {
                    this.jdbc_db_jarfile = this.jardir + File.separator + "derby.jar";
                    this.jdbc_db_driver = "org.apache.derby.jdbc.EmbeddedDriver";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.derby.sql";
                    this.db_dbname = this.jardir + File.separator + "perfdmf";
                    this.db_hostname = "";
                    this.db_portnum = "";
                } else if (this.jdbc_db_type.compareTo("sqlite") == 0 && string.compareTo("sqlite") != 0) {
                    this.jdbc_db_jarfile = this.jardir + File.separator + "sqlite.jar";
                    this.jdbc_db_driver = "org.sqlite.JDBC";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.sqlite.sql";
                    this.db_dbname = this.jardir + File.separator + this.configuration_name + ".db";
                    this.db_hostname = "";
                    this.db_portnum = "";
                } else if (this.jdbc_db_type.compareTo("h2") == 0 && string.compareTo("h2") != 0) {
                    this.jdbc_db_jarfile = this.jardir + File.separator + "h2.jar";
                    this.jdbc_db_driver = "org.h2.Driver";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.sql";
                    this.db_dbname = this.jardir + File.separator + this.configuration_name;
                    this.db_hostname = "";
                    this.db_portnum = "";
                } else if (this.jdbc_db_type.compareTo("db2") == 0 && string.compareTo("db2") != 0) {
                    this.jdbc_db_jarfile = "";
                    this.jdbc_db_driver = "com.ibm.db2.jcc.DB2Driver";
                    this.db_schemafile = this.schemadir + File.separator + "taudb.db2.sql";
                    this.db_dbname = "perfdmf";
                    this.db_schemaprefix = "perfdmf";
                    this.db_hostname = "localhost";
                    this.db_portnum = "446";
                } else if (this.jdbc_db_type.compareTo("db2") == 0 && string.compareTo("db2") == 0) {
                    int n = this.jdbc_db_jarfile.indexOf("java" + File.separator + "db2java.zip:");
                    this.jdbc_db_jarfile = n == -1 ? ((n = this.jdbc_db_jarfile.indexOf("java" + File.separator + "db2jcc.jar:")) == -1 ? "" : this.jdbc_db_jarfile.substring(0, n - 1)) : this.jdbc_db_jarfile.substring(0, n - 1);
                }
            } else if (this.jdbc_db_type.compareTo("postgresql") == 0) {
                this.jdbc_db_jarfile = "postgresql.jar";
                this.jdbc_db_driver = "org.postgresql.Driver";
                this.db_schemafile = "taudb.sql";
                this.db_hostname = "localhost";
                this.db_portnum = "5432";
            } else if (this.jdbc_db_type.compareTo("mysql") == 0) {
                this.jdbc_db_jarfile = "mysql.jar";
                this.jdbc_db_driver = "org.gjt.mm.mysql.Driver";
                this.db_schemafile = "taudb.mysql.sql";
                this.db_hostname = "localhost";
                this.db_portnum = "3306";
            } else if (this.jdbc_db_type.compareTo("oracle") == 0) {
                this.jdbc_db_jarfile = "ojdbc14.jar";
                this.jdbc_db_driver = "oracle.jdbc.OracleDriver";
                this.db_schemafile = "taudb.oracle.sql";
                this.db_hostname = "localhost";
                this.db_portnum = "1521";
            } else if (this.jdbc_db_type.compareTo("derby") == 0) {
                this.jdbc_db_jarfile = "derby.jar";
                this.jdbc_db_driver = "org.apache.derby.jdbc.EmbeddedDriver";
                this.db_schemafile = "taudb.derby.sql";
                this.db_dbname = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf";
                this.db_hostname = "";
                this.db_portnum = "";
            } else if (this.jdbc_db_type.compareTo("sqlite") == 0) {
                this.jdbc_db_jarfile = "sqlite.jar";
                this.jdbc_db_driver = "org.sqlite.JDBC";
                this.db_schemafile = "taudb.sqlite.sql";
                this.db_dbname = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + this.configuration_name + ".db";
                this.db_hostname = "";
                this.db_portnum = "";
            } else if (this.jdbc_db_type.compareTo("h2") == 0) {
                this.jdbc_db_jarfile = "h2.jar";
                this.jdbc_db_driver = "org.h2.Driver";
                this.db_schemafile = "taudb.sql";
                this.db_dbname = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + this.configuration_name;
                this.db_hostname = "";
                this.db_portnum = "";
            } else if (this.jdbc_db_type.compareTo("db2") == 0) {
                this.jdbc_db_jarfile = "";
                this.jdbc_db_driver = "com.ibm.db2.jcc.DB2Driver";
                this.db_schemafile = "taudb.db2.sql";
                this.db_dbname = "perfdmf";
                this.db_schemaprefix = "perfdmf";
                this.db_hostname = "localhost";
                this.db_portnum = "446";
            }
            if (!this.configFileFound) {
                this.jdbc_db_jarfile = this.jdbc_db_type.compareTo("derby") == 0 ? this.jardir + File.separator + "derby.jar" : this.jardir + File.separator + this.jdbc_db_jarfile;
            }
            this.jdbc_db_jarfile = this.jdbc_db_type.compareTo("db2") == 0 ? this.promptString(bufferedReader, "Please enter the path to the DB2 sqllib directory,\noften something like /home/db2_srv/sqllib.", this.jdbc_db_jarfile) : this.promptString(bufferedReader, "Please enter the JDBC jar file.", this.jdbc_db_jarfile);
            this.jdbc_db_jarfile = this.jdbc_db_jarfile.replaceAll("~", System.getProperty("user.home"));
            if (!new File(this.jdbc_db_jarfile).exists()) {
                if (this.jdbc_db_type.compareToIgnoreCase("oracle") == 0) {
                    System.out.println("\nSorry, can't automatically download drivers for Oracle");
                    System.out.println("Please acquire them manually\n");
                } else if (this.jdbc_db_type.compareToIgnoreCase("db2") == 0) {
                    System.out.println("\nSorry, can't automatically download drivers for db2");
                    System.out.println("Please acquire them manually\n");
                } else {
                    System.out.println("\n\nCouldn't find jarfile: " + this.jdbc_db_jarfile);
                    System.out.println("\nJDBC drivers are not distributed with TAU.  You should acquire the JDBC driver");
                    System.out.println("that corresponds to the database you are connecting to.  TAU can now attempt ");
                    System.out.println("to download a JDBC driver that will *probably* work.");
                    System.out.println("\n");
                    if (this.promptYN(bufferedReader, "Would you like to attempt to automatically download a JDBC driver?")) {
                        try {
                            String string2;
                            new File(".perfdmf_tmp").mkdirs();
                            System.setProperty("tar.location", ".perfdmf_tmp");
                            if (this.jdbc_db_type.equalsIgnoreCase("postgresql")) {
                                Wget.wget((String)"http://www.cs.uoregon.edu/research/paracomp/tau/postgresql-redirect.html", (String)(".perfdmf_tmp" + File.separator + "postgresql-redirect.html"), (boolean)false);
                                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(new FileInputStream(new File(".perfdmf_tmp" + File.separator + "postgresql-redirect.html"))));
                                object = "";
                                string2 = bufferedReader2.readLine();
                                while (string2 != null) {
                                    if (string2.startsWith("URL=")) {
                                        object = string2.substring(4);
                                    }
                                    string2 = bufferedReader2.readLine();
                                }
                                bufferedReader2.close();
                                System.out.println("\nDownloading... " + (String)object);
                                System.out.print("Please Wait...");
                                Wget.wget((String)object, (String)this.jdbc_db_jarfile, (boolean)true);
                                System.out.println(" Done");
                            }
                            if (this.jdbc_db_type.equalsIgnoreCase("mysql")) {
                                Wget.wget((String)"http://www.cs.uoregon.edu/research/paracomp/tau/mysql-redirect.html", (String)(".perfdmf_tmp" + File.separator + "mysql-redirect.html"), (boolean)false);
                                BufferedReader bufferedReader3 = new BufferedReader(new InputStreamReader(new FileInputStream(new File(".perfdmf_tmp" + File.separator + "mysql-redirect.html"))));
                                object = "";
                                string2 = "";
                                String string3 = "";
                                String string4 = bufferedReader3.readLine();
                                while (string4 != null) {
                                    if (string4.startsWith("URL=")) {
                                        object = string4.substring(4);
                                    }
                                    if (string4.startsWith("FILE=")) {
                                        string2 = string4.substring(5);
                                    }
                                    if (string4.startsWith("JAR=")) {
                                        string3 = string4.substring(4);
                                    }
                                    string4 = bufferedReader3.readLine();
                                }
                                bufferedReader3.close();
                                System.out.println("\nDownloading... " + (String)object);
                                System.out.print("Please Wait...");
                                Wget.wget((String)object, (String)(".perfdmf_tmp/" + string2), (boolean)true);
                                System.out.println(" Done");
                                System.out.println("\nUncompressing...");
                                Tar.guntar((String)(".perfdmf_tmp/" + string2));
                                Common.copy((String)(".perfdmf_tmp/" + string3), (String)this.jdbc_db_jarfile);
                            }
                            if (!new File(this.jdbc_db_jarfile).exists()) {
                                System.out.println("Unable to retrieve jarfile, please retrieve it manually");
                            }
                            Common.deltree((File)new File(".perfdmf_tmp"));
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to retrieve jarfile:");
                            exception.printStackTrace();
                        }
                    }
                }
            }
            if (this.jdbc_db_type.equals("db2")) {
                this.jdbc_db_jarfile = this.jdbc_db_jarfile + File.separator + "java" + File.separator + "db2java.zip:" + this.jdbc_db_jarfile + File.separator + "java" + File.separator + "db2jcc.jar:" + this.jdbc_db_jarfile + File.separator + "function:" + this.jdbc_db_jarfile + File.separator + "java" + File.separator + "db2jcc_license_cu.jar";
            }
            this.jdbc_db_driver = this.promptString(bufferedReader, "Please enter the JDBC Driver name.", this.jdbc_db_driver);
            if (!FILE_DB_NAMES.contains(this.jdbc_db_driver)) {
                this.db_hostname = this.promptString(bufferedReader, "Please enter the hostname for the database server.", this.db_hostname);
                this.db_portnum = this.promptString(bufferedReader, "Please enter the port number for the database JDBC connection.", this.db_portnum);
            }
            this.db_dbname = this.jdbc_db_type.equals("oracle") ? this.promptString(bufferedReader, "Please enter the oracle TCP service name.", this.db_dbname) : (FILE_DB_NAMES.contains(this.jdbc_db_type) ? this.promptString(bufferedReader, "Please enter the path to the database directory.", this.db_dbname) : this.promptString(bufferedReader, "Please enter the database name.", this.db_dbname));
            if (FILE_DB_NAMES.contains(this.jdbc_db_type)) {
                this.db_dbname = this.db_dbname.replaceAll("~", System.getProperty("user.home"));
            }
            if (this.jdbc_db_type.compareTo("derby") == 0 && (file = new File(this.db_dbname)).exists()) {
                object = new File(file + File.separator + "seg0");
                System.out.println(object);
                if (!((File)object).exists()) {
                    System.out.println("\n\nWarning!  Directory \"" + this.db_dbname + "\" exists and does not appear to be a derby database.\n" + "Connection will most likely fail\n\n" + "If you are trying to create a new Derby database, please specify a path that does not exist\n\n");
                }
            }
            if (this.jdbc_db_type.compareTo("h2") == 0) {
                File file2 = new File(this.db_dbname);
                if (file2.exists()) {
                    object = new File(file2 + File.separator + "perfdmf.h2.db");
                    System.out.println(object);
                    if (!((File)object).exists()) {
                        System.out.println("\n\nWarning!  Directory \"" + this.db_dbname + "\" exists and does not appear to be a h2 database.\n" + "Connection will most likely fail\n\n" + "If you are trying to create a new h2 database, please specify a path that does not exist\n\n");
                    }
                }
                this.db_dbname = this.db_dbname + File.separator + "perfdmf";
            }
            if (Arrays.asList("oracle", "db2").contains(this.jdbc_db_type)) {
                this.db_schemaprefix = this.promptString(bufferedReader, "Please enter the database schema name, or your username if you are creating the tables now.", this.db_schemaprefix);
            }
            if (this.db_username.equals("")) {
                this.db_username = System.getProperty("user.name");
            }
            this.db_username = this.promptString(bufferedReader, "Please enter the database username.", this.db_username);
            this.db_use_ssl = this.promptYN(bufferedReader, "Use SSL to connect to this database?");
            if (this.db_use_ssl) {
                this.db_keystore = DBConnector.DEFAULT_KEYSTORE_PATH;
                this.db_keystore_password = "changeit";
                this.db_truststore = DBConnector.DEFAULT_TRUSTSTORE_PATH;
                this.db_truststore_password = "changeit";
                this.db_use_ssl_keys = this.promptYN(bufferedReader, "Use SSL keys for authentication (requires password if not)?");
                if (this.db_use_ssl_keys) {
                    System.out.println("    To use SSL client certificates with TauDB, use taudb_keygen to");
                    System.out.println("    create a key and have it signed by your database administrator.");
                    System.out.println("    Then use taudb_install_cert to add it to your TauDB configuration.");
                }
            }
            if (!this.db_use_ssl_keys) {
                this.store_db_password = this.promptYN(bufferedReader, "Store the database password in CLEAR TEXT in your configuration file?");
                this.db_password = this.promptPassword("Please enter the database password:");
            }
            this.db_schemafile = this.promptString(bufferedReader, "Please enter the PerfDMF schema file.", this.configFileFound ? this.db_schemafile : this.schemadir + File.separator + this.db_schemafile);
            this.db_schemafile = this.db_schemafile.replaceAll("~", System.getProperty("user.home"));
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void testDBConnection() {
    }

    public void testDBTransaction() {
    }

    public String writeConfigFile() {
        try {
            File file = new File(System.getProperty("user.home") + File.separator + ".ParaProf");
            file.mkdirs();
            File file2 = this.configuration_name.length() != 0 ? new File(System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg." + this.configuration_name) : (this.configFileName == null || this.configFileName.length() == 0 ? (this.configuration_name.length() == 0 ? new File(System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg") : new File(this.configFileName + "." + this.configuration_name)) : new File(this.configFileName));
            System.out.println("\nWriting configuration file: " + file2);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            bufferedWriter.write("# This is the configuration file for the PerfDMF tools & API\n");
            bufferedWriter.write("# Items are listed as name:value, one per line.\n");
            bufferedWriter.write("# Comment lines begin with a '#' symbol.\n");
            bufferedWriter.write("# DO NOT EDIT THIS FILE!  It is modified by the configure utility.\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database JDBC jar file (with path to location)\n");
            bufferedWriter.write("jdbc_db_jarfile:" + this.jdbc_db_jarfile + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database JDBC driver name\n");
            bufferedWriter.write("jdbc_db_driver:" + this.jdbc_db_driver + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database type\n");
            bufferedWriter.write("jdbc_db_type:" + this.jdbc_db_type + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database host name\n");
            bufferedWriter.write("db_hostname:" + this.db_hostname + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database port number\n");
            bufferedWriter.write("db_portnum:" + this.db_portnum + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database name\n");
            bufferedWriter.write("db_dbname:" + this.db_dbname + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database Schema name\n");
            bufferedWriter.write("db_schemaprefix:" + this.db_schemaprefix + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database username\n");
            bufferedWriter.write("db_username:" + this.db_username + "\n");
            bufferedWriter.newLine();
            if (this.db_use_ssl) {
                bufferedWriter.write("# Use SSL to connect to database?\n");
                bufferedWriter.write("db_use_ssl: yes\n");
                bufferedWriter.newLine();
                bufferedWriter.write("# Keystore for client authentication certificates.\n");
                bufferedWriter.write("db_keystore:" + this.db_keystore + "\n");
                bufferedWriter.newLine();
                bufferedWriter.write("# Keystore password.\n");
                bufferedWriter.write("db_keystore_password:" + this.db_keystore_password + "\n");
                bufferedWriter.newLine();
                bufferedWriter.write("# Truststore for server certs.\n");
                bufferedWriter.write("db_truststore:" + this.db_truststore + "\n");
                bufferedWriter.newLine();
                bufferedWriter.write("# Truststore password.\n");
                bufferedWriter.write("db_truststore_password:" + this.db_truststore_password + "\n");
                bufferedWriter.newLine();
            }
            if (this.store_db_password) {
                bufferedWriter.write("# Database password\n");
                bufferedWriter.write("db_password:" + this.db_password + "\n");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("# Database Schema file - note: the path is absolute\n");
            bufferedWriter.write("db_schemafile:" + this.db_schemafile + "\n");
            bufferedWriter.newLine();
            bufferedWriter.write("# Database XML parser jar file - note: the path is absolute\n");
            bufferedWriter.write("xml_sax_parser:" + this.xml_parser + "\n");
            bufferedWriter.newLine();
            bufferedWriter.close();
            return file2.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new TauRuntimeException((Exception)iOException);
        }
    }

    public void setJDBCJarfile(String string) {
        this.jdbc_db_jarfile = string;
    }

    public String getJDBCJarfile() {
        return this.jdbc_db_jarfile;
    }

    public void setJDBCDriver(String string) {
        this.jdbc_db_driver = string;
    }

    public String getJDBCDriver() {
        return this.jdbc_db_driver;
    }

    public void setJDBCType(Object object) {
        this.jdbc_db_type = (String)object;
    }

    public String getJDBCType() {
        return this.jdbc_db_type;
    }

    public void setDBHostname(String string) {
        this.db_hostname = string;
    }

    public String getDBHostname() {
        return this.db_hostname;
    }

    public void setDBPortNum(String string) {
        this.db_portnum = string;
    }

    public String getDBPortNum() {
        return this.db_portnum;
    }

    public void setDBName(String string) {
        this.db_dbname = string;
    }

    public String getDBName() {
        return this.db_dbname;
    }

    public void setDBUsername(String string) {
        this.db_username = string;
    }

    public String getDBUsername() {
        return this.db_username;
    }

    public void setDBPassword(String string) {
        this.db_password = string;
    }

    public String getDBPassword() {
        return this.db_password;
    }

    public void setDBSchemaFile(String string) {
        this.db_schemafile = string;
    }

    public String getDBSchemaFile() {
        return this.db_schemafile;
    }

    public void setXMLPaser(String string) {
        this.xml_parser = string;
    }

    public String getXMLPaser() {
        return this.xml_parser;
    }

    public void setConfigFileName(String string) {
        this.configuration_name = string;
    }

    public String getConfigFileName() {
        return this.configuration_name;
    }

    public void savePassword() {
        this.store_db_password = true;
    }

    public void createDB() throws DatabaseConfigurationException {
        ConnectionManager connectionManager = null;
        DB dB = null;
        try {
            connectionManager = new ConnectionManager(new Database(this.configFileName), true);
            connectionManager.connect();
            dB = connectionManager.getDB();
        }
        catch (SQLException sQLException) {
            System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
            System.out.println("the database " + this.db_dbname + " has been created.");
            throw new DatabaseException("Error Connection to Database" + this.db_dbname, sQLException);
        }
        try {
            String string = new String("select * from trial;");
            ResultSet resultSet = dB.executeQuery(string);
            resultSet.close();
            connectionManager.dbclose();
        }
        catch (Exception exception) {
            System.out.println(this.configFileName);
            connectionManager.genParentSchema(this.db_schemafile);
            connectionManager.dbclose();
            System.out.println("Congratulations! PerfDMF is configured and the database has been built.");
            System.out.println("You may begin loading applications.");
        }
        System.out.println("Configuration complete.");
    }

    public static void createDefault(String string, String string2, String string3, String string4) {
        Configure configure = new Configure(string2, string3);
        configure.initialize(string);
        configure.useDefaults(string4);
        configure.setDBName(string4);
        String string5 = configure.writeConfigFile();
        ConfigureTest configureTest = new ConfigureTest();
        configureTest.initialize(string5);
        try {
            configureTest.createDB(false);
        }
        catch (DatabaseConfigurationException databaseConfigurationException) {
            databaseConfigurationException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('c', "config");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('j', "jardir");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('a', "schemadir");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option6 = cmdLineParser.addBooleanOption('d', "create-default");
        CmdLineParser.Option option7 = cmdLineParser.addBooleanOption('C', "connect-without-prompt");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String string = (String)cmdLineParser.getOptionValue(option);
        String string2 = (String)cmdLineParser.getOptionValue(option2);
        String string3 = (String)cmdLineParser.getOptionValue(option3);
        String string4 = (String)cmdLineParser.getOptionValue(option4);
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option5);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option6);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option7);
        if (bl != null && bl.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (string == null) {
            string = string2 == null ? System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg" : System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg." + string2;
        }
        System.out.println(bl3);
        if (bl3 == null || !bl3.booleanValue()) {
            if (bl2 == null) {
                bl2 = Boolean.FALSE;
            }
            object = new Configure(string3, string4);
            ((Configure)object).initialize(string, string2);
            if (bl2 == Boolean.TRUE) {
                ((Configure)object).useDefaults(string2);
            } else {
                ((Configure)object).promptForData();
            }
            string = ((Configure)object).writeConfigFile();
        }
        object = new ConfigureTest();
        ((ConfigureTest)object).initialize(string);
        try {
            ((ConfigureTest)object).createDB(false);
        }
        catch (DatabaseConfigurationException databaseConfigurationException) {
            databaseConfigurationException.printStackTrace();
            System.exit(0);
        }
    }
}

